/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.statistics;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;

public class StatisticsMibDBRegister {
    public static final String STATISTICS_MIB_NO_THRESHOLD = "0";
    public static final String STATISTICS_MIB_NO_TYPE = "";
    private static Logger logger = null;
    private String targetip;
    private int version;
    private String community;
    private ArrayList statisList;

    public StatisticsMibDBRegister(String targetIP, int version, String community) {
        this.targetip = targetIP;
        this.version = version;
        this.community = community;
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void setDatabaseStatisMibInfomation(String getOid, String period, String threshHold, String type) {
        this.statisList = null;
        MibGetNextInfo mibGetInstance = null;
        try {
            try {
                int checkCount = 0;
                while (mibGetInstance == null) {
                    mibGetInstance = MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(this.targetip, Thread.currentThread().getName());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        logger.warning(e1.getMessage());
                        e1.printStackTrace();
                    }
                    MibGetNextInfoQueue.getInstance().checkTimeout(this.targetip, getOid, ++checkCount, this.version);
                }
                mibGetInstance.setMibGetNext(this.targetip, this.version, this.community);
                this.statisList = mibGetInstance.getNextMibValueList(getOid);
                if (this.statisList != null) {
                    this.setMibSstatisticsDB(getOid, period, threshHold, type, this.statisList);
                }
            }
            catch (UnknownHostException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + getOid + " Period=" + period + " Threshold=" + threshHold + " Type=" + type);
                e.printStackTrace();
            }
            catch (SocketException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + getOid + " Period=" + period + " Threshold=" + threshHold + " Type=" + type);
                e.printStackTrace();
            }
            catch (SnmpMIBGetException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + getOid + " Period=" + period + " Threshold=" + threshHold + " Type=" + type);
                e.printStackTrace();
            }
        }
        finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(this.targetip, Thread.currentThread().getName());
            }
        }
    }

    private void setMibSstatisticsDB(String oid, String period, String threshHold, String type, ArrayList statisItemList) {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                DBTableStatisticsMIBControl statisticsMib = DBTableStatisticsMIBControl.getInstance();
                int j = 0;
                while (j < statisItemList.size()) {
                    statisticsMib.putInstanceTable(this.targetip, oid, ((MibValue)statisItemList.get(j)).getMibName());
                    statisticsMib.addStatisticsMibDataColumn(this.targetip, ((MibValue)statisItemList.get(j)).getMibName().replace('.', '_'));
                    ++j;
                }
                statisticsMib.putStatisticsTable(this.targetip, oid, period, threshHold, type, statisItemList.size());
                NodeWatchInfo nodeInfo = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(this.targetip);
                nodeInfo.setStatisticsMIBStatus("OK");
                BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodeInfo);
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + oid + " Period=" + period + " Threshold=" + threshHold + " Type=" + type);
                e.printStackTrace();
            }
            catch (SQLException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + oid + " Period=" + period + " Threshold=" + threshHold + " Type=" + type);
                e.printStackTrace();
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public void updateMibStatisticsSetDatabase(String oid, String period, String threshHold, String type) {
        try {
            DBTableStatisticsMIBControl statisticsMib = DBTableStatisticsMIBControl.getInstance();
            statisticsMib.updateStatisticsTable(this.targetip, oid, period, threshHold, type);
        }
        catch (DatabaseConnectionException e) {
            logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + oid + " Period=" + period + " Threshold=" + threshHold + " Type=" + type);
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + oid + " Period=" + period + " Threshold=" + threshHold + " Type=" + type);
            e.printStackTrace();
        }
    }
}

