/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.ping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;

public class PingExcecEngine {
    public static final String SYSTEM_PROPERTY_OS_NAME = "os.name";
    public static final String WINDOWS_OS_NAME = "windows";
    public static final String PING_COMMAND = "ping ";
    public static final String PING_RESPONSE_TIME_UNIT_MS = "ms";
    public static final int NORMAL = 0;
    public static final int UNREACHABLE = 1;
    public static final int TIMEOUT = 2;
    private static Logger logger = null;
    public static final String WINDOWS_PING_NORMAL_RESPONSE = "Reply from";
    public static final String WINDOWS_PING_UNREACHABLE = "unreachable.";
    public static final String WINDOWS_PING_SPECIFIED_INVALID = "Destination specified is invalid.";
    public static final String LINUX_PING_NORMAL_RESPONSE = "bytes from";
    public static final String LINUX_PING_UNREACHABLE = "Uunreachable";
    public static final String LINUX_PING_UNREACHABLE1 = "filtered";
    private boolean isOSLinux = false;
    private static String pingParameter;
    private String targetIPAddress;
    private static long diffTime;
    private ResourceInfo resourceInfo;
    private int timeOutLinux;
    private int retryLinux;

    public PingExcecEngine(String timeoutMilliSecParam, String retryParam) {
        logger = Logger.getLogger(this.getClass().getName());
        this.resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        String osName = System.getProperty(SYSTEM_PROPERTY_OS_NAME);
        String[] lowerOSName = osName.toLowerCase().split(" ");
        if (lowerOSName.length > 1 && lowerOSName[0].equals(WINDOWS_OS_NAME)) {
            pingParameter = timeoutMilliSecParam == null || retryParam == null ? " -w " + this.resourceInfo.getPingTimeout() + " -n " + this.resourceInfo.getPingRetry() + " " : " -w " + timeoutMilliSecParam + " -n " + retryParam + " ";
            this.isOSLinux = false;
        } else {
            if (timeoutMilliSecParam == null || retryParam == null) {
                this.timeOutLinux = Integer.parseInt(this.resourceInfo.getPingTimeout());
                this.retryLinux = Integer.parseInt(this.resourceInfo.getPingRetry());
            } else {
                this.timeOutLinux = Integer.parseInt(timeoutMilliSecParam) / 1000;
                this.retryLinux = Integer.parseInt(retryParam);
            }
            pingParameter = " -w " + this.timeOutLinux + " -c " + this.retryLinux + " ";
            this.isOSLinux = true;
            logger.info("OS Not Windows Ping param : " + pingParameter);
        }
    }

    public boolean checkPingResponse() {
        boolean isResult = false;
        isResult = this.isOSLinux ? PingExcecEngine.pingLinux(this.targetIPAddress, this.retryLinux, this.timeOutLinux) : PingExcecEngine.pingWindows(this.targetIPAddress);
        return isResult;
    }

    private static synchronized boolean pingWindows(String targetIPAddress) {
        boolean resultFlag;
        block43: {
            Process process;
            Runtime runTime;
            InputStreamReader ir;
            InputStream is;
            BufferedReader in;
            long pingTestFinishTime;
            long pingTestStartTime;
            int responseType;
            block41: {
                boolean bl;
                block42: {
                    responseType = 0;
                    resultFlag = false;
                    pingTestStartTime = 0L;
                    pingTestFinishTime = 0L;
                    in = null;
                    is = null;
                    ir = null;
                    runTime = null;
                    process = null;
                    runTime = Runtime.getRuntime();
                    pingTestStartTime = System.currentTimeMillis();
                    process = runTime.exec(PING_COMMAND + pingParameter + targetIPAddress);
                    if (process != null) break block41;
                    logger.warning("Abort create process");
                    bl = resultFlag;
                    if (in == null) break block42;
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (ir != null) {
                    try {
                        ir.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (runTime != null) {
                    runTime.gc();
                }
                if (process != null) {
                    process.destroy();
                }
                return bl;
            }
            try {
                try {
                    String line;
                    is = process.getInputStream();
                    ir = new InputStreamReader(is);
                    in = new BufferedReader(ir);
                    while ((line = in.readLine()) != null) {
                        if (line.indexOf(WINDOWS_PING_NORMAL_RESPONSE) >= 0 || line.indexOf(LINUX_PING_NORMAL_RESPONSE) >= 0) {
                            resultFlag = true;
                            responseType = 0;
                            break;
                        }
                        if (line.indexOf(WINDOWS_PING_UNREACHABLE) >= 0 || line.indexOf(LINUX_PING_UNREACHABLE) >= 0 || line.indexOf(LINUX_PING_UNREACHABLE1) >= 0) {
                            responseType = 1;
                            break;
                        }
                        responseType = 2;
                    }
                    pingTestFinishTime = System.currentTimeMillis();
                    if (resultFlag) {
                        diffTime = pingTestFinishTime - pingTestStartTime;
                        break block43;
                    }
                    AlarmMessageMake alarmMessageMakeInstance = AlarmMessageMake.getInstance();
                    switch (responseType) {
                        case 1: {
                            logger.info("Destination host unreachable. : " + diffTime + PING_RESPONSE_TIME_UNIT_MS);
                            alarmMessageMakeInstance.setEorrorPingDestinationHostUnreachable(targetIPAddress);
                            break;
                        }
                        case 2: {
                            diffTime = pingTestFinishTime - pingTestStartTime;
                            logger.info("Time out error : " + diffTime + PING_RESPONSE_TIME_UNIT_MS);
                            alarmMessageMakeInstance.setErrorPingTimeout(targetIPAddress);
                            break;
                        }
                        default: {
                            logger.warning("Ping excecute error");
                            break;
                        }
                    }
                }
                catch (IOException io) {
                    logger.warning(io.toString());
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (ir != null) {
                    try {
                        ir.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (runTime != null) {
                    runTime.gc();
                }
                if (process != null) {
                    process.destroy();
                }
            }
        }
        return resultFlag;
    }

    public static synchronized boolean pingLinux(String targetIPAddress, int retryLinux, int timeOutLinux) {
        boolean resultFlag = false;
        try {
            long max = 0L;
            long min = 0L;
            long sum = 0L;
            int num = 0;
            InetAddress address = InetAddress.getByName(targetIPAddress);
            int retryCount = 0;
            while (retryCount < retryLinux) {
                long start = System.currentTimeMillis();
                boolean isReachable = address.isReachable(timeOutLinux);
                long end = System.currentTimeMillis();
                if (isReachable) {
                    resultFlag = true;
                    diffTime = end - start;
                    logger.info("Reply from " + address.getHostAddress() + ": ");
                    sum += diffTime;
                    if (retryCount == 0) {
                        max = diffTime;
                        min = diffTime;
                    } else if (diffTime > max) {
                        max = diffTime;
                    } else if (diffTime < min) {
                        min = diffTime;
                    }
                    ++num;
                    if (diffTime > 0L) {
                        logger.info("time=" + diffTime + PING_RESPONSE_TIME_UNIT_MS);
                    } else {
                        logger.info("time<1ms");
                    }
                } else {
                    resultFlag = false;
                    diffTime = end - start;
                    logger.info("Time out error : " + diffTime + PING_RESPONSE_TIME_UNIT_MS + " (set " + timeOutLinux + "ms)");
                    if (diffTime >= (long)timeOutLinux) {
                        logger.info("Request timed out.");
                    } else {
                        logger.info("Reply from " + address.getHostAddress() + ": Destination net unreachable.");
                        ++num;
                    }
                }
                ++retryCount;
            }
            if (!resultFlag) {
                AlarmMessageMake alarmMessageMakeInstance = AlarmMessageMake.getInstance();
                alarmMessageMakeInstance.setErrorPingTimeout(targetIPAddress);
            }
            logger.info("Ping statistics for " + address.getHostAddress() + ":");
            int lost = num == 0 ? 100 : (retryCount - num) * 100 / num;
            logger.info("    Packets: Sent = " + retryCount + ", Received = " + num + ", Lost = " + (retryCount - num) + " (" + lost + "% loss),");
            if (num != 0) {
                logger.info("Approximate round trip times in milli-seconds:");
                long average = num != 0 ? sum / (long)num : 0L;
                logger.info("    Minimum = " + min + "ms, Maximum = " + max + "ms, Average = " + average + PING_RESPONSE_TIME_UNIT_MS);
            }
        }
        catch (UnknownHostException unknownHostException) {
            logger.warning("Unknown host " + targetIPAddress + ".");
        }
        catch (IOException iOException) {
            logger.warning("Network Error Occurred.");
        }
        return resultFlag;
    }

    public long getDifftime() {
        return diffTime;
    }

    public void setTargetIPAddress(String string) {
        this.targetIPAddress = string;
    }
}

