/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.nodemaneger.map;

import java.util.ArrayList;
import netjfwatcher.engine.nodemaneger.map.NodeMapInfo;
import netjfwatcher.engine.nodemaneger.map.NodeMapViewDraw;
import netjfwatcher.engine.nodemaneger.map.NodeMapViewPopUpMenu;
import netjfwatcher.engine.nodemaneger.map.NodeMapViewPopUpMenuSocket;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class NodeMapViewMouseListener
extends MouseAdapter
implements MouseMoveListener {
    private Composite parent;
    private GC gc;
    private ArrayList<NodeMapInfo> nodeMapNodeInfoList;
    private NodeMapLinkInformation nodMapLinkInformationList;
    private int lineStartX;
    private int lineStartY;
    private NodeInformation startNode;
    private boolean isLineSelected = false;
    private boolean isLineStart = false;
    private NodeMapViewDraw mapDraw;
    private NodeMapViewPopUpMenu popMenu;

    public NodeMapViewMouseListener(ScrolledComposite scrollComposite, Display display, Composite parent, Canvas canvas, GC gc, SubStatusLineManager statusLineManager, boolean isSocket) {
        this.gc = gc;
        this.parent = parent;
        this.mapDraw = new NodeMapViewDraw(scrollComposite, canvas, gc);
        this.popMenu = isSocket ? new NodeMapViewPopUpMenuSocket(display, canvas, this.mapDraw, this, statusLineManager) : new NodeMapViewPopUpMenu(display, canvas, this.mapDraw, this, statusLineManager);
    }

    public void mouseDown(MouseEvent event) {
        boolean isFoundSelectedNode = false;
        this.popMenu.setPopUpMenu(this.parent);
        this.nodeMapNodeInfoList = this.popMenu.getNodeMapNodeInfoList();
        int i = 0;
        while (i < this.nodeMapNodeInfoList.size()) {
            NodeMapInfo nodeMapInfo = this.nodeMapNodeInfoList.get(i);
            if (!isFoundSelectedNode && event.x > nodeMapInfo.getX() && event.x < nodeMapInfo.getX() + nodeMapInfo.getWidth() && event.y > nodeMapInfo.getY() && event.y < nodeMapInfo.getY() + nodeMapInfo.getHeight()) {
                if (!this.isLineSelected) {
                    this.popMenu.setNodeMenu(nodeMapInfo.getNodeInfo());
                    nodeMapInfo.setSelected(true);
                    this.isLineStart = false;
                } else {
                    this.isLineStart = true;
                    this.lineStartX = event.x;
                    this.lineStartY = event.y;
                    this.startNode = nodeMapInfo.getNodeInfo();
                }
                isFoundSelectedNode = true;
            } else {
                nodeMapInfo.setSelected(false);
            }
            this.nodeMapNodeInfoList.set(i, nodeMapInfo);
            ++i;
        }
        this.nodMapLinkInformationList = this.popMenu.getNodMapLinkInformationList();
        this.mapDraw.redraw(this.nodeMapNodeInfoList, this.nodMapLinkInformationList);
    }

    public void mouseUp(MouseEvent event) {
        this.nodeMapNodeInfoList = this.popMenu.getNodeMapNodeInfoList();
        this.nodMapLinkInformationList = this.popMenu.getNodMapLinkInformationList();
        if (this.isLineSelected && this.isLineStart) {
            this.isLineStart = false;
            this.mapDraw.redraw(this.nodeMapNodeInfoList, this.nodMapLinkInformationList);
            int i = 0;
            while (i < this.nodeMapNodeInfoList.size()) {
                NodeMapInfo nodeMapInfo = this.nodeMapNodeInfoList.get(i);
                if (event.x > nodeMapInfo.getX() && event.x < nodeMapInfo.getX() + nodeMapInfo.getWidth() && event.y > nodeMapInfo.getY() && event.y < nodeMapInfo.getY() + nodeMapInfo.getHeight()) {
                    boolean isLineCut = false;
                    if (this.nodMapLinkInformationList == null) {
                        return;
                    }
                    ArrayList node0List = this.nodMapLinkInformationList.getNode0address();
                    ArrayList node1List = this.nodMapLinkInformationList.getNode1address();
                    int linkNodeCount = 0;
                    while (linkNodeCount < node0List.size()) {
                        if (this.startNode.getIpaddress().equals(node0List.get(linkNodeCount)) && nodeMapInfo.getNodeInfo().getIpaddress().equals(node1List.get(linkNodeCount))) {
                            node0List.remove(linkNodeCount);
                            node1List.remove(linkNodeCount);
                            isLineCut = true;
                            break;
                        }
                        ++linkNodeCount;
                    }
                    linkNodeCount = 0;
                    while (linkNodeCount < node1List.size()) {
                        if (this.startNode.getIpaddress().equals(node1List.get(linkNodeCount)) && nodeMapInfo.getNodeInfo().getIpaddress().equals(node0List.get(linkNodeCount))) {
                            node1List.remove(linkNodeCount);
                            node0List.remove(linkNodeCount);
                            isLineCut = true;
                            break;
                        }
                        ++linkNodeCount;
                    }
                    if (!isLineCut) {
                        node0List.add(this.startNode.getIpaddress());
                        node1List.add(nodeMapInfo.getNodeInfo().getIpaddress());
                    }
                    this.nodMapLinkInformationList.setNode0address(node0List);
                    this.nodMapLinkInformationList.setNode1address(node1List);
                    this.mapDraw.redraw(this.nodeMapNodeInfoList, this.nodMapLinkInformationList);
                    break;
                }
                ++i;
            }
        } else {
            this.isLineStart = false;
            int i = 0;
            while (i < this.nodeMapNodeInfoList.size()) {
                NodeMapInfo nodeMapInfo = this.nodeMapNodeInfoList.get(i);
                if (nodeMapInfo.isSelected()) {
                    int x = nodeMapInfo.getX();
                    int y = nodeMapInfo.getY();
                    if (x < 0) {
                        x = event.x;
                    }
                    if (y < 0) {
                        y = event.y;
                    }
                    nodeMapInfo.setX(x);
                    nodeMapInfo.setY(y);
                    NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();
                    String nodeX = Integer.toString(x);
                    String nodeY = Integer.toString(y);
                    nodeInfo.setNodeX(nodeX);
                    nodeInfo.setNodeY(nodeY);
                    nodeMapInfo.setNodeInfo(nodeInfo);
                    this.nodeMapNodeInfoList.set(i, nodeMapInfo);
                    this.mapDraw.redraw(this.nodeMapNodeInfoList, this.nodMapLinkInformationList);
                    nodeMapInfo.setSelected(false);
                    this.nodeMapNodeInfoList.set(i, nodeMapInfo);
                }
                ++i;
            }
        }
    }

    public void mouseMove(MouseEvent event) {
        this.nodeMapNodeInfoList = this.popMenu.getNodeMapNodeInfoList();
        this.nodMapLinkInformationList = this.popMenu.getNodMapLinkInformationList();
        if (this.isLineSelected && this.isLineStart) {
            this.mapDraw.redraw(this.nodeMapNodeInfoList, this.nodMapLinkInformationList);
            this.gc.drawLine(this.lineStartX, this.lineStartY, event.x, event.y);
        } else {
            this.isLineStart = false;
            int i = 0;
            while (i < this.nodeMapNodeInfoList.size()) {
                NodeMapInfo nodeMapInfo = this.nodeMapNodeInfoList.get(i);
                if (nodeMapInfo.isSelected()) {
                    String nodeX = Integer.toString(event.x);
                    String nodeY = Integer.toString(event.y);
                    nodeMapInfo.setX(event.x);
                    nodeMapInfo.setY(event.y);
                    NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();
                    nodeInfo.setNodeX(nodeX);
                    nodeInfo.setNodeY(nodeY);
                    nodeMapInfo.setNodeInfo(nodeInfo);
                    this.nodeMapNodeInfoList.set(i, nodeMapInfo);
                    this.mapDraw.redraw(this.nodeMapNodeInfoList, this.nodMapLinkInformationList);
                }
                ++i;
            }
        }
    }

    public void redraw() {
        this.nodeMapNodeInfoList = this.popMenu.getNodeMapNodeInfoList();
        this.nodMapLinkInformationList = this.popMenu.getNodMapLinkInformationList();
        this.mapDraw.redraw(this.nodeMapNodeInfoList, this.nodMapLinkInformationList);
    }

    public NodeMapViewPopUpMenu getPopMenu() {
        return this.popMenu;
    }

    public boolean isLineSelected() {
        return this.isLineSelected;
    }

    public void setLineSelected(boolean isLineSelected) {
        this.isLineSelected = isLineSelected;
    }

    public boolean isLineStart() {
        return this.isLineStart;
    }

    public void setLineStart(boolean isLineStart) {
        this.isLineStart = isLineStart;
    }
}

