/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.thread;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmpmanager.trap.ITrapListener;
import netjfwatcher.snmpmanager.trap.TrapDispatcher;

public final class TrapReceiveThread
extends DataStringDisplay
implements Runnable {
    private static Logger logger;
    private DatagramSocket dSocket;
    private Thread trapReceiveThread;
    private List<ITrapListener> listenerList;

    private TrapReceiveThread() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void addTrapListener(ITrapListener listener) {
        int i = 0;
        while (i < this.listenerList.size()) {
            if (listener == this.listenerList.get(i)) {
                return;
            }
            ++i;
        }
        this.listenerList.add(listener);
    }

    public void removeTrapListener(ITrapListener listener) {
        int i = 0;
        while (i < this.listenerList.size()) {
            if (listener == this.listenerList.get(i)) {
                this.listenerList.remove(i);
                break;
            }
            ++i;
        }
    }

    public boolean checkThread() {
        return this.trapReceiveThread != null && this.trapReceiveThread.isAlive();
    }

    public void startReceiving() throws SocketException {
        if (this.trapReceiveThread == null || !this.trapReceiveThread.isAlive()) {
            try {
                this.dSocket = new DatagramSocket(SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpTrapPort());
                this.listenerList = Collections.synchronizedList(new LinkedList());
                this.trapReceiveThread = new Thread(this);
            }
            catch (SocketException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                throw e;
            }
            if (this.trapReceiveThread != null) {
                this.trapReceiveThread.start();
            }
        }
    }

    public void stopReceiving() {
        if (this.trapReceiveThread != null) {
            this.trapReceiveThread.interrupt();
            this.trapReceiveThread = null;
        }
        if (this.dSocket != null) {
            this.dSocket.close();
            while (this.trapReceiveThread != null && this.trapReceiveThread.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
            this.dSocket = null;
        }
        logger.info("Trap thread stop");
        this.trapReceiveThread = null;
    }

    public void run() {
        logger.info("Trap receive start");
        while (this.trapReceiveThread != null && !this.trapReceiveThread.isInterrupted()) {
            TrapDispatcher dispPatcher = new TrapDispatcher();
            try {
                dispPatcher.disptcher(this.dSocket, this.listenerList);
            }
            catch (SocketException e) {
                if (this.dSocket == null || this.dSocket.isClosed()) {
                    logger.info("Trap Receive Socket closed : " + e.getMessage());
                    continue;
                }
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            }
            catch (GeneralSecurityException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            catch (SnmpV3ConfigurationException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            catch (SnmpV3DecryptAbortException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
                break;
            }
        }
        logger.info("Trap receive Thread interrupt!!");
    }

    public static TrapReceiveThread getInstance() {
        return SingletonResource.RESOURCE;
    }

    public Thread getTrapReceiveThread() {
        return this.trapReceiveThread;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.dSocket != null) {
            this.dSocket.close();
        }
    }

    /* synthetic */ TrapReceiveThread(TrapReceiveThread trapReceiveThread) {
        this();
    }

    private static class SingletonResource {
        static final TrapReceiveThread RESOURCE = new TrapReceiveThread(null);

        private SingletonResource() {
        }
    }
}

