/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.net.URL;
import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.model.hsqldb.HsqldbControl;
import netjfwatcher.database.access.model.hsqldb.HsqldbDatabaseManager;
import netjfwatcher.database.access.model.hsqldb.HsqldbException;
import netjfwatcher.engine.model.action.DatabaseControl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class ActionBuilderDatabase {
    private static Logger logger;
    private IAction startDatabase = new ActionStartDatabase();
    private IAction startHSQLDB = new ActionStartHSQLDBThread();
    private IAction stopHSQLDB = new ActionStopHSQLDBThread();
    private IAction startHSQLDBManager = new ActionStartHSQLDBManager();
    private IAction stopHSQLDBManager = new ActionStopHSQLDBManager();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderDatabase() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction getActionStartDatabase() {
        return this.startDatabase;
    }

    public IAction getActionStartHSQLDB() {
        return this.startHSQLDB;
    }

    public IAction getActionStopHSQLDB() {
        return this.stopHSQLDB;
    }

    public IAction getActionStartHSQLDBManager() {
        return this.startHSQLDBManager;
    }

    public IAction getActionStopHSQLDBManager() {
        return this.stopHSQLDBManager;
    }

    private abstract class AbstractDatabaseAction
    extends Action {
        private AbstractDatabaseAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    private final class ActionStartDatabase
    extends AbstractDatabaseAction {
        private ActionStartDatabase() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderDatabase.this.bundle.getEntry("icons/database.gif"));
        }

        public String getText() {
            return "Database driver start";
        }

        public String getToolTipText() {
            return "Database driver start";
        }

        protected void doTask() {
            Shell shell = new Shell();
            if (MessageDialog.openQuestion((Shell)shell, (String)"Confirm", (String)"Initialize Database")) {
                DatabaseControl.getInstance().startDatabase(true);
            } else {
                DatabaseControl.getInstance().startDatabase(false);
            }
            shell.dispose();
        }
    }

    private final class ActionStartHSQLDBThread
    extends AbstractDatabaseAction {
        private ActionStartHSQLDBThread() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderDatabase.this.bundle.getEntry("icons/hsqldb_start.gif"));
        }

        public String getText() {
            return "HSQLDB Start";
        }

        public String getToolTipText() {
            return "HSQLDB Start";
        }

        protected void doTask() {
            try {
                HsqldbControl.getInstance().startHsqlDB();
            }
            catch (HsqldbException e) {
                Shell shell = new Shell();
                MessageDialog.openInformation((Shell)shell, (String)"Hsqldb Status", (String)e.getMessage());
                shell.dispose();
            }
        }
    }

    private final class ActionStopHSQLDBThread
    extends AbstractDatabaseAction {
        private ActionStopHSQLDBThread() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderDatabase.this.bundle.getEntry("icons/hsqldb_stop.gif"));
        }

        public String getText() {
            return "HSQLDB Stop";
        }

        public String getToolTipText() {
            return "HSQLDB Stop";
        }

        protected void doTask() {
            try {
                HsqldbControl.getInstance().stopHsqlDB();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                shell.dispose();
            }
            catch (SQLException e) {
                e.printStackTrace();
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                shell.dispose();
            }
        }
    }

    private final class ActionStartHSQLDBManager
    extends AbstractDatabaseAction {
        private ActionStartHSQLDBManager() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderDatabase.this.bundle.getEntry("icons/hsqldb_mansa.gif"));
        }

        public String getText() {
            return "HSQLDB Manager Start";
        }

        public String getToolTipText() {
            return "HSQLDB Manager Start";
        }

        protected void doTask() {
            HsqldbDatabaseManager manager = new HsqldbDatabaseManager();
            manager.run((IAction)this);
        }
    }

    private final class ActionStopHSQLDBManager
    extends AbstractDatabaseAction {
        private ActionStopHSQLDBManager() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderDatabase.this.bundle.getEntry("icons/hsqldb_mansa_stop.gif"));
        }

        public String getText() {
            return "HSQLDB Manager Stop";
        }

        public String getToolTipText() {
            return "HSQLDB Manager Stop";
        }

        protected void doTask() {
            try {
                HsqldbDatabaseManager.createEmptyHsqlDatabase();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                shell.dispose();
            }
            catch (SQLException e) {
                e.printStackTrace();
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                shell.dispose();
            }
        }
    }
}

