/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyNetworkServer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class ActionBuilderApacheDerby {
    private static Logger logger;
    private IAction startApacheDerby = new ActionStartApacheDerbyThread();
    private IAction stopApacheDerby = new ActionStopApacheDerbyThread();
    private IAction startEmbeddedApacheDerby = new ActionStartEmbeddedApacheDerbyThread();
    private IAction stopEmbeddedApacheDerby = new ActionStopEmbeddedApacheDerbyThread();
    private IAction sysInfoApacheDerby = new ActionSysInfoApacheDerby();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderApacheDerby() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction getActionStartApacheDerby() {
        return this.startApacheDerby;
    }

    public IAction getActionStopApacheDerby() {
        return this.stopApacheDerby;
    }

    public IAction getActionSysInfoApacheDerby() {
        return this.sysInfoApacheDerby;
    }

    public IAction getActionEmbeddedStartApacheDerby() {
        return this.startEmbeddedApacheDerby;
    }

    public IAction getActionEmbeddedStopApacheDerby() {
        return this.stopEmbeddedApacheDerby;
    }

    private abstract class AbstractDatabaseAction
    extends Action {
        private AbstractDatabaseAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    private final class ActionStartApacheDerbyThread
    extends AbstractDatabaseAction {
        private ActionStartApacheDerbyThread() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderApacheDerby.this.bundle.getEntry("icons/derby_start.gif"));
        }

        public String getText() {
            return "Apache Derby Start";
        }

        public String getToolTipText() {
            return "Apache Derby Start";
        }

        protected void doTask() {
            logger.info("Apache Derby Start task");
            try {
                ApacheDerbyNetworkServer.getInstance().startDerbyNetworkServer();
            }
            catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Abort start Apache Derby " + e.getMessage()));
                shell.dispose();
            }
        }
    }

    private final class ActionStopApacheDerbyThread
    extends AbstractDatabaseAction {
        private ActionStopApacheDerbyThread() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderApacheDerby.this.bundle.getEntry("icons/derby_stop.gif"));
        }

        public String getText() {
            return "Apache Derby Stop";
        }

        public String getToolTipText() {
            return "Apache Derby Stop";
        }

        protected void doTask() {
            logger.info("Apache Derby shutdown");
            try {
                ApacheDerbyNetworkServer.getInstance().stopDerbyNetworkServer();
            }
            catch (Exception e) {
                e.printStackTrace();
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                shell.dispose();
            }
        }
    }

    private final class ActionSysInfoApacheDerby
    extends AbstractDatabaseAction {
        private ActionSysInfoApacheDerby() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderApacheDerby.this.bundle.getEntry("icons/derby_sysinfo.gif"));
        }

        public String getText() {
            return "Apache Derby Sys Info";
        }

        public String getToolTipText() {
            return "Apache Derby Sys Info";
        }

        protected void doTask() {
            logger.info("Apache Derby Sys Info");
            try {
                ApacheDerbyNetworkServer.getInstance().getSysInfoNetworkServer();
            }
            catch (Exception e) {
                e.printStackTrace();
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                shell.dispose();
            }
        }
    }

    private final class ActionStartEmbeddedApacheDerbyThread
    extends AbstractDatabaseAction {
        private ActionStartEmbeddedApacheDerbyThread() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderApacheDerby.this.bundle.getEntry("icons/derby_start.gif"));
        }

        public String getText() {
            return "Embedded Apache Derby Start";
        }

        public String getToolTipText() {
            return "Embedded Apache Derby Start";
        }

        protected void doTask() {
            logger.info("Embedded Apache Derby Start task");
            try {
                ApacheDerbyEmbeddedDerby.getInstance().startEmbeddedDerby();
            }
            catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openInformation((Shell)shell, (String)"Apache Derby Status", (String)e.getMessage());
                shell.dispose();
            }
        }
    }

    private final class ActionStopEmbeddedApacheDerbyThread
    extends AbstractDatabaseAction {
        private ActionStopEmbeddedApacheDerbyThread() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderApacheDerby.this.bundle.getEntry("icons/derby_stop.gif"));
        }

        public String getText() {
            return "Embedded Apache Derby Stop";
        }

        public String getToolTipText() {
            return "Embedded Apache Derby Stop";
        }

        protected void doTask() {
            logger.info("Embedded Apache Derby shutdown");
            try {
                ApacheDerbyEmbeddedDerby.getInstance().stopEmbeddedDerby();
            }
            catch (Exception e) {
                e.printStackTrace();
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                shell.dispose();
            }
        }
    }
}

