/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.macaddress.preference;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import netjfwatcher.macaddress.plugin.NetWatcherRCPMacAddressPlugin;
import netjfwatcher.macaddress.preference.MacAddressInfo;
import org.osgi.framework.Bundle;

public class MacAddressConfigFileParse {
    private static Logger logger = null;
    private Map macInfoHashMap;

    public MacAddressConfigFileParse() throws Exception {
        logger = Logger.getLogger(this.getClass().getName());
        this.macInfoHashMap = Collections.synchronizedMap(new LinkedHashMap());
        URL url = this.getDocument("resources/mac_addresses.txt");
        if (url != null) {
            this.parse(url);
        }
    }

    private URL getDocument(String filePath) {
        URL url = null;
        Bundle bundle = NetWatcherRCPMacAddressPlugin.getInstance().getBundle();
        url = bundle.getEntry(filePath);
        if (url == null) {
            logger.severe("Not found file url : " + filePath);
            return null;
        }
        return url;
    }

    public void parse(URL url) {
        logger = Logger.getLogger(this.getClass().getName());
        logger.info("file : " + url.getFile());
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return;
        }
        BufferedReader buffReader = null;
        try {
            try {
                String str;
                InputStreamReader ti = new InputStreamReader(is);
                buffReader = new BufferedReader(ti);
                while ((str = buffReader.readLine()) != null) {
                    Pattern pattern = Pattern.compile("[ \t]");
                    String[] item = pattern.split(str, 2);
                    if (item.length < 2) continue;
                    MacAddressInfo macInfo = new MacAddressInfo();
                    macInfo.setOui(item[0]);
                    String vedorInfo = item[1].replaceAll("\t", " ");
                    macInfo.setVendorInfo(vedorInfo);
                    macInfo.setVendorInfoUpperCase(vedorInfo.toUpperCase());
                    this.macInfoHashMap.put(item[0].toUpperCase(), macInfo);
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (buffReader != null) {
                try {
                    buffReader.close();
                }
                catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }

    public Map getMacInfoHashMap() {
        return this.macInfoHashMap;
    }
}

