/*
 * Created on 2004/08/09
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.upload.model;

import java.util.ArrayList;
import java.util.logging.Logger;


/**
 * m[hꊇo^󋵂L[ƂĕێVOgNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeRegisterQueue {
    // m[ho^ʂi[郊Xg
    private static ArrayList nodeList = new ArrayList();

    // MO
    private static Logger logger = null;

    // m[hꊇo^ɂăm[ho^𕶎zƂĊi[郊Xg
    private ArrayList nodeInfoList = null;

    // m[hꊇo^ɂăm[hN𕶎zƂĊi[郊Xg
    private ArrayList linkList = null;

    // ꊇo^m[h
    private int nodeRegisterTotal = 0;

    // m[ho^
    private int nodeRegisterOK = 0;

    // m[ho^s
    private int nodeRegisterAbort = 0;

    // RXgN^privateɂĕspӂɒڃRXgN^Ăяoh~
    private NodeRegisterQueue() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hꊇo^L[܂B
     *
     */
    public void resetQueue() {
        nodeRegisterTotal = 0;
        nodeRegisterOK = 0;
        nodeRegisterAbort = 0;
        nodeList.clear();
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static NodeRegisterQueue getInstance() {
        return SingletonXMLSocketConnectInstance.INSTANCE;
    }

    /**
     * m[hꊇo^ł̓o^m[hZbg܂B
     *
     * @param nodeTotal o^m[h
     */
    public void setTotalNode(int nodeTotal) {
        nodeRegisterTotal = nodeTotal;
    }

    /**
     * m[ho^JEgAbv܂B
     *
     */
    public void countNodeRegisterOK() {
        nodeRegisterOK++;
    }

    /**
     * m[ho^sJEgAbv܂B
     *
     */
    public void countNodeRegisterAbort() {
        nodeRegisterAbort++;
    }

    /**
     * SڑNCAg̃CxgʒmpIuWFNg̃CxgXgɐVȃCxgo^܂B
     *
     *
     * @param obj CxgXgɒǉCxgiIuWFNgj
     */
    public void push(Object obj) {
        nodeList.add(obj);
    }

    /**
     * m[hꊇo^󋵏L[o܂B<BR>
     * L[ɉꍇɂnullԂ܂B
     *
     * @return socketinfo m[hꊇo^
     */
    public NodeRegisterStatusInfo pop() {
        if (nodeList.size() > 0) {
            NodeRegisterStatusInfo socketinfo =
                (NodeRegisterStatusInfo) nodeList.get(0);
            nodeList.remove(0);

            return socketinfo;
        } else {
            return null;
        }
    }

    /**
     * m[ho^sԂ܂B
     *
     * @return nodeRegisterAbort m[ho^s
     */
    public int getNodeRegisterAbort() {
        return nodeRegisterAbort;
    }

    /**
     * m[ho^Ԃ܂B
     *
     * @return nodeRegisterOK m[ho^
     */
    public int getNodeRegisterOK() {
        return nodeRegisterOK;
    }

    /**
     * m[ho^Ԃ܂B
     *
     * @return nodeRegisterTotal m[ho^
     */
    public int getNodeRegisterTotal() {
        return nodeRegisterTotal;
    }

    /**
     * m[hꊇo^ł̃N񃊃XgԂ܂
     *
     * @return linkList N񃊃Xg
     */
    public ArrayList getLinkList() {
        return linkList;
    }

    /**
     * m[hꊇo^ł̃m[hĎ񃊃XgԂ܂B
     *
     * @return nodeInfoList m[hĎ
     */
    public ArrayList getNodeInfoList() {
        return nodeInfoList;
    }

    /**
     * m[hN񃊃XgZbg܂B
     *
     * @param list N񃊃Xg
     */
    public void setLinkList(ArrayList list) {
        linkList = list;
    }

    /**
     * m[hĎ񃊃XgZbg܂B
     *
     * @param list m[hĎ񃊃Xg
     */
    public void setNodeInfoList(ArrayList list) {
        nodeInfoList = list;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonXMLSocketConnectInstance {
        static final NodeRegisterQueue INSTANCE = new NodeRegisterQueue();
    }
}
