/*
 * Created on 2004/04/22
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.upload;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.upload.model.NodeRegisterUploadModel;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;


/**
 * uEUm[hꊇo^s߂̃ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class UploadAction extends Action {
    private static final String DEST_DIR = "./";
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        InputStream stream = null;
        OutputStream bos = null;
        FormFile uploadFormFile = null;

        String fileName = null;
        String size = null;

        try {
            // Abv[ht@C̎擾
            uploadFormFile =
                (FormFile) PropertyUtils.getProperty(form, "uploadFile");

            // t@C̎擾
            fileName = uploadFormFile.getFileName();

            // t@CTCY̎擾
            size = (uploadFormFile.getFileSize() + " bytes");

            logger.info("File name : " + fileName);
            logger.info("File size : " + size);

            stream = uploadFormFile.getInputStream();

            NodeRegisterUploadModel upload = new NodeRegisterUploadModel();
            upload.upload(uploadFormFile);
        } catch (FileNotFoundException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } finally {
            if (bos != null) {
                bos.close();
            }

            if (stream != null) {
                stream.close();
            }
        }

        request.setAttribute("fileName", fileName);
        request.setAttribute("size", size);
        request.setAttribute("dest", DEST_DIR);

        /*
         * Flash XMLSocketłlocalhostւ̐ڑłIPAhXł͂ȂlocalhostɂȂ
         * ڑłȂ
         */
        InetAddress localAddress = InetAddress.getLocalHost();
        String servername = localAddress.getHostAddress();
        logger.info(
            "Request Remote IP=" + request.getRemoteAddr() + " Local Address="
            + localAddress.getHostAddress());

        if (request.getRemoteAddr().equals("127.0.0.1")) {
            request.setAttribute(Preference.SERVER_NAME, "localhost");
        } else {
            request.setAttribute(Preference.SERVER_NAME, servername);
        }

        String clientXmlSocketPort =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getClientXmlSocketPort();

        request.setAttribute(
            Preference.CLIENT_XML_SOCKET_PORT, clientXmlSocketPort);

        // ꎞt@C̍폜
        uploadFormFile.destroy();

        return mapping.findForward(Preference.SUCCESS);
    }
}
