/*
 * Created on 2003/08/17
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.statisticsmib.action;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;
import netjfwatcher.statisticsmib.model.StatisticsSetModel;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * SNMPvMIB̎ݒsANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class StatisticsSetAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not engine address : " + engineAddress);
        }

        String ipAddress = request.getParameter(Preference.IPADDRESS);
        String community = request.getParameter(Preference.SNMP_READ_COMMUNITY);
        String oid = request.getParameter(Preference.SNMP_OID);
        String period = request.getParameter(Preference.SNMP_STATISTICS_PERIOD);
        String threshold =
            request.getParameter(Preference.SNMP_STATISTICS_THRESHOLD);
        String thresholdtype =
            request.getParameter(Preference.SNMP_STATISTICS_THRESHOLD_TYPE);

        StatisticsSetModel statisset = new StatisticsSetModel();
        String serverAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (serverAddress == null) {
            serverAddress = "localhost";
        }

        statisset.setStatisticsMibInfo(
            serverAddress, ipAddress, community, oid, period, threshold,
            thresholdtype);

        ArrayList list =
            statisset.getStatisticsMibInfoList(serverAddress, ipAddress);

        request.setAttribute(Preference.SNMP_STATISTICS_MIBSET_LIST, list);
        request.setAttribute(
            Preference.SNMP_STATISTICS_TARGET_IPADDRESS, ipAddress);
        request.setAttribute(Preference.SNMP_READ_COMMUNITY, community);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String frameNameforServername = servernamework2.replace('-', '_');
        String convIPAddress = ipAddress.replace('.', '_');

        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(
            Preference.FRAME_NAME_AT_SERVER_NAME, frameNameforServername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
