/*
 * Created on 2004/04/08
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodeview.snmpsystem.model;

import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionSystemMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.SystemMib;


/**
 * wm[hSNMP System MIBGW擾NXłB
 * System MIB͈ȉ̒ʂłB
 * EsysDescr;
 * EsysUpTime;
 * EsysContact;
 * EsysName;
 * EsysLocation;
 *
 * @author Yoshimasa Matsumoto
 *@@version 1.0
 */
public class NodeSNMPSystemModel {
    /* MO */
    private static Logger logger;

    /**
     * wm[hSnmp System MIBGW擾NXCX^X𐶐܂B
     *
     */
    public NodeSNMPSystemModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * GWSystem MIB擾܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hIPAhX
     * @return@systemMibInfo System MIB
     * @throws EngineConnectException GWƂ̐ڑňُ킪
     * @throws IOException GWƂ̐ڑňُ킪
     */
    public SystemMib getSystemMib(String engineAddress, String ipaddress)
        throws EngineConnectException, IOException {
        SystemMib systemMibInfo = null;
        ConnectionSystemMibGet statisticsMibGet =
            new ConnectionSystemMibGet(engineAddress);

        systemMibInfo = statisticsMibGet.getSystemMib(ipaddress);

        if (systemMibInfo == null) {
            logger.warning(
                "System MIB Null of Engine IP=" + engineAddress + " Node IP="
                + ipaddress);
            systemMibInfo = new SystemMib();
        }

        return systemMibInfo;
    }
}
