/*
 * Created on 2003/07/17
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.noderegister.model;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;
import netjfwatcher.engine.socket.ConnectionNodeControl;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.command.control.CommandMappingTableResource;


/**
 * m[ho^s\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeRegisterModel {
    /* MO */
    private static Logger logger = null;

    /**
     * m[ho^s\bhNXCX^X𐶐܂B
     *
     */
    public NodeRegisterModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ꊇm[ho^s܂B
     * f[^x[XɃm[ho^߂̃rWlXEWbNĂяo܂B
     *
     * @param nodeInformation m[hĎ
     * @throws@NodeRegistException m[ho^Ɏsꍇ
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void registerUploadNode(NodeInformation nodeInformation)
        throws NodeRegistException, EngineConnectException, IOException {
        String nodeIPAaddress = nodeInformation.getIpaddress();
        String engineAddress = nodeInformation.getEngineAddress();

        logger.info("Bundle register node : " + nodeIPAaddress);
        logger.info("Bundle register engine : " + engineAddress);

        /*
         * m[hIP Address̑Ó`FbN
         */
        String ipaddress = null;
        String nodeName = null;

        try {
            InetAddress host = InetAddress.getByName(nodeIPAaddress);
            ipaddress = host.getHostAddress();
            nodeName = host.getHostName();
        } catch (UnknownHostException e) {
            /* m[hIP Addressُ */
            logger.warning(
                "UnknownHostException : " + " IP Address = " + nodeIPAaddress
                + " " + e.getMessage());
            throw new NodeRegistException(
                "UnknownHostException : " + " IP Address = " + nodeIPAaddress
                + " " + e.getMessage());
        }

        if (
            (nodeInformation.getNodename() == null)
                || nodeInformation.getNodename().equals("")) {
            nodeInformation.setNodename(nodeName);
        }

        int httpPeriod = 0;

        try {
            httpPeriod = Integer.parseInt(nodeInformation.getHttpPeriod());
        } catch (NumberFormatException e) {
            logger.warning(
                "NumberFormatException " + e.getMessage() + " Http period = "
                + nodeInformation.getHttpPeriod());
            nodeInformation.setHttpPeriod("0");

            /*
            throw new NodeRegistException(
            "NumberFormatException " + e.getMessage() + " Http period = "
            + nodeInformation.getHttpPeriod());
            */
        }

        if (httpPeriod > 0) {
            try {
                URL accessURL = new URL(nodeInformation.getHttpUrl());

                if (
                    (accessURL.getHost() == null)
                        || accessURL.getHost().equals("")
                        || (accessURL.getProtocol() == null)
                        || accessURL.getProtocol().equals("")) {
                    logger.warning(
                        "Illegal URL " + "   host=" + accessURL.getHost()
                        + "  protocol=" + accessURL.getProtocol());
                    throw new NodeRegistException(
                        "Illegal URL " + "   host=" + accessURL.getHost()
                        + "  protocol=" + accessURL.getProtocol());
                }
            } catch (MalformedURLException e) {
                logger.warning(
                    e.getMessage() + " : " + nodeInformation.getHttpUrl());
                throw new NodeRegistException(
                    e.getMessage() + " : " + nodeInformation.getHttpUrl());
            }
        }

        if ((engineAddress == null) || engineAddress.equals("")) {
            ArrayList list =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();
            engineAddress =
                ((EngineResourceInfo) list.get(0)).getEngineIPaddress();
        }

        // GWɃm[hǉʒm
        ConnectionNodeControl threadstop =
            new ConnectionNodeControl(engineAddress);
        String responseCode =
            threadstop.requestThread(
                ipaddress, CommandMappingTableResource.THREAD_START_COMMAND_ID,
                nodeInformation);

        logger.info(responseCode);

        /* m[ho^ʂ`FbNAُ펞ɂException throw */
        if (!responseCode.equals(CommandMappingTableResource.ACK_RESPONSE)) {
            throw new NodeRegistException(
                responseCode + " at Engine address " + engineAddress);
        }
    }

    /**
     * m[ho^GWɒʒmAo^ʂmF܂B
     * o^sɂNodeRegistExceptionX[܂B
     *
     * @param nodeInfo m[hĎ
     * @throws NodeRegistException m[ho^sꍇ
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void registerNode(NodeInformation nodeInfo)
        throws NodeRegistException, EngineConnectException, IOException {
        String ipaddress = null;
        String nodeName = null;
        String nodeIPAaddress = nodeInfo.getIpaddress();
        String engineAddress = nodeInfo.getEngineAddress();

        try {
            InetAddress host = InetAddress.getByName(nodeIPAaddress);
            ipaddress = host.getHostAddress();
            nodeName = host.getHostName();
        } catch (UnknownHostException e) {
            /* m[hIP Addressُ */
            logger.warning(
                "UnknownHostException : " + " IP Address = " + nodeIPAaddress
                + " " + e.getMessage());
            throw new NodeRegistException(
                "UnknownHostException : " + " IP Address = " + nodeIPAaddress
                + " " + e.getMessage());
        }

        if (
            (nodeInfo.getNodename() == null)
                || nodeInfo.getNodename().equals("")) {
            nodeInfo.setNodename(nodeName);
        }

        int httpPeriod = 0;

        try {
            httpPeriod = Integer.parseInt(nodeInfo.getHttpPeriod());
        } catch (NumberFormatException e) {
            logger.warning(
                "NumberFormatException " + e.getMessage() + " Http period = "
                + nodeInfo.getHttpPeriod());
            throw new NodeRegistException(
                "NumberFormatException " + e.getMessage() + " Http period = "
                + nodeInfo.getHttpPeriod());
        }

        if (httpPeriod > 0) {
            try {
                URL accessURL = new URL(nodeInfo.getHttpUrl());

                if (
                    (accessURL.getHost() == null)
                        || accessURL.getHost().equals("")
                        || (accessURL.getProtocol() == null)
                        || accessURL.getProtocol().equals("")) {
                    logger.warning(
                        "Illegal URL " + "   host=" + accessURL.getHost()
                        + "  protocol=" + accessURL.getProtocol());
                    throw new NodeRegistException(
                        "Illegal URL " + "   host=" + accessURL.getHost()
                        + "  protocol=" + accessURL.getProtocol());
                }
            } catch (MalformedURLException e) {
                logger.warning(e.getMessage() + " : " + nodeInfo.getHttpUrl());
                throw new NodeRegistException(
                    e.getMessage() + " : " + nodeInfo.getHttpUrl());
            }
        }

        ConnectionNodeControl threadstop =
            new ConnectionNodeControl(engineAddress);
        String responseCode =
            threadstop.requestThread(
                ipaddress, CommandMappingTableResource.THREAD_START_COMMAND_ID,
                nodeInfo);

        logger.info(responseCode);

        if (!responseCode.equals(CommandMappingTableResource.ACK_RESPONSE)) {
            throw new NodeRegistException(
                responseCode + " at Engine address : " + engineAddress);
        }
    }

    /**
     * w̃GWAhXɓo^Ăm[hXgƂĎ擾ĕԂ܂B
     *
     * @param engineAddress GWAhX
     * @return nodeList o^m[h񃊃Xg
     * @throws EngineConnectException GWƂ̐ڑňُoꍇ
     * @throws IOException GWƂ̐ڑňُoꍇ
     */
    public ArrayList getList(final String engineAddress)
        throws EngineConnectException, IOException {
        ArrayList nodeList = null;

        ConnectionNodeInformation nodeInfoList =
            new ConnectionNodeInformation(engineAddress);

        nodeList = nodeInfoList.getNodeInformationList(null, null);

        return nodeList;
    }

    /**
     * w̃GWAhXAm[hAhX̏GW擾āAԂ܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hIPAhX
     * @return nodeInfo m[hĎ
     * @throws EngineConnectException GWƂ̐ڑňُoꍇ
     * @throws IOException GWƂ̐ڑňُoꍇ
     */
    public NodeInformation getIPTarget(
        final String engineAddress, final String ipaddress)
        throws EngineConnectException, IOException {
        NodeInformation nodeInfo = null;

        ConnectionNodeInformation nodeInfoList =
            new ConnectionNodeInformation(engineAddress);

        nodeInfo = nodeInfoList.getNodeInformation(ipaddress);

        return nodeInfo;
    }
}
