/*
 * Created on 2004/04/14
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemap.flashaction;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import netjfwatcher.maintenance.model.FlashResourceInformationModel;
import netjfwatcher.nodemanager.list.model.NodeListViewModel;
import netjfwatcher.nodemap.model.NodeMapLinkModel;
import netjfwatcher.nodemap.model.NodeMapModel;
import netjfwatcher.preference.Preference;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;


/**
 * NCAg̃m[hMap̃[h܂ANCAg̃m[hMap̊i[
 * sANVłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapAction extends HttpServlet {

    private static Logger logger = null;

    /* Postp[^i[z */
    private String postNodeAddress;
    private String postNodeX;
    private String postNodeY;
    private String postNodeName;
    private String postNodeGroup;
    private String postNodeEngine;
    private String postNodeKind;
    private String postLinkStart;
    private String postLinkEnd;

    /* PingĎ Postp[^i[z */
    private String postNodePingPeriod;
    private String postNodePingThreshhold;

    /* SnmpĎ Postp[^i[z */
    private String postNodeSnmpVersion;
    private String postNodeSnmpLevel;
    private String postNodeSnmpPeriod;
    private String postNodeSnmpTimeout;
    private String postNodeSnmpCommunity;
    private String postNodeSnmpRWCommunity;

    /* HttpĎ Postp[^i[z */
    private String postNodeHttpPeriod;
    private String postNodeHttptimeout;
    private String postNodeHttpPort;
    private String postNodeHttpUrl;

    /* SmtpĎ Postp[^i[z */
    private String postNodeSmtpPeriod;
    private String postNodeSmtpTimeout;
    private String postNodeSmtpPort;
    private String postNodeSmtpSendAddress;
    private String postNodeSmtpCheckPopHost;
    private String postNodeSmtpCheckPopUser;
    private String postNodeSmtpCheckPopPassword;
    private String postNodeSmtpCheckPopPort;
    private String postNodeSmtpCheckPopTimeout;

    /* Pop3Ď Postp[^i[z */
    private String postNodePopPeriod;
    private String postNodePopTimeout;
    private String postNodePopPort;
    private String postNodePopUser;
    private String postNodePopPassword;

    /* m[hĎPostp[^[,]ŕvfi[z */
    private String[] nodeAddress;
    private String[] nodeX;
    private String[] nodeY;
    private String[] nodeName;
    private String[] nodeGroup;
    private String[] nodeEngine;
    private String[] nodeKindIcon;
    private String[] nodeKind;

    /* Linki[z */
    private String[] linkStart;
    private String[] linkEnd;

    /* PingĎi[z */
    private String[] nodePingPeriod;
    private String[] nodePingThreshhold;

    /* SnmpĎi[z */
    private String[] nodeSnmpVersion;
    private String[] nodeSnmpLevel;
    private String[] nodeSnmpPeriod;
    private String[] nodeSnmpTimeout;
    private String[] nodeSnmpCommunity;
    private String[] nodeSnmpRWCommunity;

    /* HttpĎi[z */
    private String[] nodeHttpPeriod;
    private String[] nodeHttptimeout;
    private String[] nodeHttpPort;
    private String[] nodeHttpUrl;

    /* SmtpĎi[z */
    private String[] nodeSmtpPeriod;
    private String[] nodeSmtpTimeout;
    private String[] nodeSmtpPort;
    private String[] nodeSmtpSendAddress;
    private String[] nodeSmtpCheckPopHost;
    private String[] nodeSmtpCheckPopUser;
    private String[] nodeSmtpCheckPopPassword;
    private String[] nodeSmtpCheckPopPort;
    private String[] nodeSmtpCheckPopTimeout;

    /* Pop3Ďi[z */
    private String[] nodePopPeriod;
    private String[] nodePopTimeout;
    private String[] nodePopPort;
    private String[] nodePopUser;
    private String[] nodePopPassword;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        String mode = request.getParameter("mode");

        /*
         * Node Map Load܂́Asave[h
         */
        try {
            if (mode.equals("load")) {
                this.loadMap(request, response);
            } else {
                this.saveMap(request, response);
            }
        } catch (EngineConnectException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadMap(
        HttpServletRequest request, HttpServletResponse response)
        throws EngineConnectException, IOException {
        /* Response Contet set */
        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        /* EngineAhXp[^o */
        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "all";
        }

        /*
         * m[hList擾Am[h̃m[hĎ𐶐
         */
        NodeInformation nodeInfo = null;
        NodeListViewModel nodeListViewModel = new NodeListViewModel();
        ArrayList nodeInfoList = null;

        nodeInfoList = nodeListViewModel.getList(engineAddress, null, null);

        int arraysize = nodeInfoList.size();
        int datacnt;

        String[] returnNodeAddress = new String[arraysize];
        String[] returnNodeName = new String[arraysize];
        String[] returnNodeGroup = new String[arraysize];
        String[] returnNodeEngine = new String[arraysize];
        String[] returnNodeX = new String[arraysize];
        String[] returnNodeY = new String[arraysize];
        String[] returnNodeKind = new String[arraysize];
        String[] returnNodeKindIcon = new String[arraysize];

        String[] returnPingPeriod = new String[arraysize];
        String[] returnPingThreshhold = new String[arraysize];
        String[] returnSnmpVersion = new String[arraysize];
        String[] returnSnmpLevel = new String[arraysize];
        String[] returnSnmpPeriod = new String[arraysize];
        String[] returnSnmpTimeout = new String[arraysize];
        String[] returnSnmpROCommunity = new String[arraysize];
        String[] returnSnmpRWCommunity = new String[arraysize];
        String[] returnHttpPeriod = new String[arraysize];
        String[] returnHttpPort = new String[arraysize];
        String[] returnHttpUrl = new String[arraysize];
        String[] returnHttpTimeout = new String[arraysize];
        String[] returnSmtpPeriod = new String[arraysize];
        String[] returnSmtpTimeout = new String[arraysize];
        String[] returnSmtpPort = new String[arraysize];
        String[] returnSmtpAddress = new String[arraysize];
        String[] returnSmtpCheckPop3Host = new String[arraysize];
        String[] returnSmtpCheckPop3User = new String[arraysize];
        String[] returnSmtpCheckPop3Password = new String[arraysize];
        String[] returnSmtpCheckPop3Port = new String[arraysize];
        String[] returnSmtpCheckPop3Timeout = new String[arraysize];
        String[] returnPopPeriod = new String[arraysize];
        String[] returnPopPort = new String[arraysize];
        String[] returnPopTimeout = new String[arraysize];
        String[] returnPopUser = new String[arraysize];
        String[] returnPopPassword = new String[arraysize];

        /*
         * Ďm[h̃m[hĎZbg
         */
        for (datacnt = 0; datacnt < arraysize; datacnt++) {
            nodeInfo = (NodeInformation) nodeInfoList.get(datacnt);
            returnNodeAddress[datacnt] = nodeInfo.getIpaddress();
            returnNodeName[datacnt] = nodeInfo.getNodename();
            returnNodeGroup[datacnt] = nodeInfo.getGroup();
            returnNodeEngine[datacnt] = nodeInfo.getEngineAddress();
            returnNodeX[datacnt] = nodeInfo.getNodeX();
            returnNodeY[datacnt] = nodeInfo.getNodeY();

            /* m[hIcon */
            returnNodeKind[datacnt] = nodeInfo.getNodeKind();
            returnNodeKindIcon[datacnt] =
                this.getNodeKindIcon(nodeInfo.getNodeKind());

            /* PingĎ */
            returnPingPeriod[datacnt] = nodeInfo.getPingPeriod();
            returnPingThreshhold[datacnt] = nodeInfo.getPingThreshold();

            /* SnmpĎ */
            returnSnmpVersion[datacnt] = nodeInfo.getSnmpVersion();
            returnSnmpPeriod[datacnt] = nodeInfo.getSnmpPeriod();
            returnSnmpTimeout[datacnt] = nodeInfo.getSnmpTimeout();
            returnSnmpLevel[datacnt] = nodeInfo.getSnmpLevel();
            returnSnmpROCommunity[datacnt] = nodeInfo.getRoCommunity();
            returnSnmpRWCommunity[datacnt] = nodeInfo.getRwCommunity();

            /* HttpT[oĎ */
            returnHttpPeriod[datacnt] = nodeInfo.getHttpPeriod();
            returnHttpPort[datacnt] = nodeInfo.getHttpPort();
            returnHttpTimeout[datacnt] = nodeInfo.getHttpTimeout();
            returnHttpUrl[datacnt] = nodeInfo.getHttpUrl();

            /* SmtpT[oĎ */
            returnSmtpPeriod[datacnt] = nodeInfo.getSmtpPeriod();
            returnSmtpTimeout[datacnt] = nodeInfo.getSmtpTimeout();
            returnSmtpPort[datacnt] = nodeInfo.getSmtpPort();
            returnSmtpAddress[datacnt] = nodeInfo.getSmtpSendAddress();
            returnSmtpCheckPop3Host[datacnt] = nodeInfo.getSmtpCheckHost();
            returnSmtpCheckPop3User[datacnt] = nodeInfo.getSmtpCheckUser();
            returnSmtpCheckPop3Password[datacnt] =
                nodeInfo.getSmtpCheckPassword();
            returnSmtpCheckPop3Port[datacnt] = nodeInfo.getSmtpCheckPort();
            returnSmtpCheckPop3Timeout[datacnt] =
                nodeInfo.getSmtpCheckTimeout();

            /* Pop3T[oĎ */
            returnPopPeriod[datacnt] = nodeInfo.getPopPeriod();
            returnPopTimeout[datacnt] = nodeInfo.getPopTimeout();
            returnPopPort[datacnt] = nodeInfo.getPopPort();
            returnPopUser[datacnt] = nodeInfo.getPopUser();
            returnPopPassword[datacnt] = nodeInfo.getPopPassword();
        }

        out.print("dataCNT" + "=" + datacnt);

        /* Flash ClientɃm[hĎno */
        for (int j = 0; j < datacnt; j++) {
            out.print("&NodeAddress" + j + "=" + returnNodeAddress[j]);
            out.print("&NodeName" + j + "=" + returnNodeName[j]);
            out.print("&NodeGroup" + j + "=" + returnNodeGroup[j]);
            out.print("&NodeEngine" + j + "=" + returnNodeEngine[j]);
            out.print("&NodeX" + j + "=" + returnNodeX[j]);
            out.print("&NodeY" + j + "=" + returnNodeY[j]);
            out.print("&NodeKind" + j + "=" + returnNodeKind[j]);
            out.print("&NodeKindIcon" + j + "=" + returnNodeKindIcon[j]);

            /* PingĎ */
            out.print("&PingPeriod" + j + "=" + returnPingPeriod[j]);
            out.print("&PingThreshhold" + j + "=" + returnPingThreshhold[j]);

            /* SnmpĎ */
            out.print("&SnmpVersion" + j + "=" + returnSnmpVersion[j]);
            out.print("&SnmpLevel" + j + "=" + returnSnmpLevel[j]);
            out.print("&SnmpPeriod" + j + "=" + returnSnmpPeriod[j]);
            out.print("&SnmpTimeout" + j + "=" + returnSnmpTimeout[j]);
            out.print("&SnmpCommunity" + j + "=" + returnSnmpROCommunity[j]);
            out.print(
                "&SnmpRWCommunity" + j + "=" + returnSnmpRWCommunity[j]);

            /* HttpĎ */
            out.print("&HttpPeriod" + j + "=" + returnHttpPeriod[j]);
            out.print("&HttpPort" + j + "=" + returnHttpPort[j]);
            out.print("&HttpTimeout" + j + "=" + returnHttpTimeout[j]);
            out.print("&HttpUrl" + j + "=" + returnHttpUrl[j]);

            /* SmtpĎ */
            out.print("&SmtpPeriod" + j + "=" + returnSmtpPeriod[j]);
            out.print("&SmtpTimeout" + j + "=" + returnSmtpTimeout[j]);
            out.print("&SmtpPort" + j + "=" + returnSmtpPort[j]);
            out.print("&SmtpSendAddress" + j + "=" + returnSmtpAddress[j]);
            out.print(
                "&SmtpCheckPop3Host" + j + "=" + returnSmtpCheckPop3Host[j]);
            out.print(
                "&SmtpCheckPop3User" + j + "=" + returnSmtpCheckPop3User[j]);
            out.print(
                "&SmtpCheckPop3Password" + j + "="
                + returnSmtpCheckPop3Password[j]);
            out.print(
                "&SmtpCheckPop3Port" + j + "=" + returnSmtpCheckPop3Port[j]);
            out.print(
                "&SmtpCheckPop3Timeout" + j + "="
                + returnSmtpCheckPop3Timeout[j]);

            /* Pop3Ď */
            out.print("&popPeriod" + j + "=" + returnPopPeriod[j]);
            out.print("&popTimeout" + j + "=" + returnPopTimeout[j]);
            out.print("&popPort" + j + "=" + returnPopPort[j]);
            out.print("&popUser" + j + "=" + returnPopUser[j]);
            out.print("&popPassword" + j + "=" + returnPopPassword[j]);
        }

        /*
         * m[hMap LinkGW擾
         */
        NodeMapLinkModel nodemaplinkmodel = new NodeMapLinkModel();

        NodeMapLinkInformation nodeMapLinkInfo = null;

        nodeMapLinkInfo =
            nodemaplinkmodel.getNodeMapLinkInfo(engineAddress, null, null);

        int mapLinkCount = nodeMapLinkInfo.getNode0address().size();
        String[] lineStart = new String[mapLinkCount];
        String[] lineEnd = new String[mapLinkCount];

        for (int i = 0; i < mapLinkCount; i++) {
            lineStart[i] = (String) (nodeMapLinkInfo.getNode0address().get(i));
            lineEnd[i] = (String) (nodeMapLinkInfo.getNode1address().get(i));
        }

        /*
         * m[hMap LinkFlash Clientɑo
         */
        out.print("&linecnt" + "=" + lineStart.length);

        for (int j = 0; j < mapLinkCount; j++) {
            out.print("&lineStart" + j + "=" + lineStart[j]);
            out.print("&lineEnd" + j + "=" + lineEnd[j]);
        }

        // GWAhXXg\[X擾AFlash Clientɑo
        ArrayList engineList =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getEngineInfoList();
        String[] engineAddressArray = new String[engineList.size()];
        out.print("&engineAddressListCnt" + "=" + engineList.size());

        for (int i = 0; i < engineList.size(); i++) {
            engineAddressArray[i] =
                ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
            out.print("&engineAddressList" + i + "=" + engineAddressArray[i]);
        }
    }

    private void saveMap(
        HttpServletRequest request, HttpServletResponse response)
        throws EngineConnectException, IOException {
        getPostParameter(request);

        checkPostParameter();

        NodeMapModel nodeMapModel = new NodeMapModel();
        NodeMapLinkModel nodeMapLink = new NodeMapLinkModel();
        ArrayList nodeList = new ArrayList();

        for (int i = 0; i < nodeAddress.length; i++) {
            /*
             * m[hClient FlashŎIɕtĂꍇɂ́A
             * m[hNAăm[ho^ł̃zXgtB
             * ́AFlash Client̃m[hnull̏ꍇɃp[^
             * oɎs邽߂ɂ̖h~̂߁AFlash Clientŕt
             */
            if (nodeName[i].equals("Default Node Name")) {
                nodeName[i] = "";
            }

            if (!nodeAddress[i].equals("")) {
                NodeInformation nodeInformation = new NodeInformation();
                nodeInformation.setEngineAddress(nodeEngine[i]);
                nodeInformation.setNodename(nodeName[i]);
                nodeInformation.setIpaddress(nodeAddress[i]);
                nodeInformation.setGroup(nodeGroup[i]);
                nodeInformation.setNodeX(nodeX[i]);
                nodeInformation.setNodeY(nodeY[i]);
                nodeInformation.setNodeKind(nodeKind[i]);
                nodeInformation.setPingPeriod(nodePingPeriod[i]);
                nodeInformation.setPingThreshold(nodePingThreshhold[i]);
                nodeInformation.setSnmpVersion(nodeSnmpVersion[i]);
                nodeInformation.setSnmpPeriod(nodeSnmpPeriod[i]);
                nodeInformation.setSnmpLevel(nodeSnmpLevel[i]);
                nodeInformation.setRoCommunity(nodeSnmpCommunity[i]);
                nodeInformation.setRwCommunity(nodeSnmpRWCommunity[i]);
                nodeInformation.setHttpPeriod(nodeHttpPeriod[i]);
                nodeInformation.setHttpUrl(nodeHttpUrl[i]);
                nodeInformation.setHttpTimeout(nodeHttptimeout[i]);
                nodeInformation.setPopPeriod(nodePopPeriod[i]);
                nodeInformation.setPopUser(nodePopUser[i]);
                nodeInformation.setPopPassword(nodePopPassword[i]);
                nodeInformation.setPopPort(nodePopPort[i]);
                nodeInformation.setPopTimeout(nodePopTimeout[i]);
                nodeInformation.setSmtpPeriod(nodeSmtpPeriod[i]);
                nodeInformation.setSmtpPort(nodeSmtpPort[i]);
                nodeInformation.setSmtpTimeout(nodeSmtpTimeout[i]);
                nodeInformation.setSmtpSendAddress(nodeSmtpSendAddress[i]);
                nodeInformation.setSmtpCheckHost(nodeSmtpCheckPopHost[i]);
                nodeInformation.setSmtpCheckUser(nodeSmtpCheckPopUser[i]);
                nodeInformation.setSmtpCheckPassword(
                    nodeSmtpCheckPopPassword[i]);
                nodeInformation.setSmtpCheckPort(nodeSmtpCheckPopPort[i]);
                nodeInformation.setSmtpCheckTimeout(nodeSmtpCheckPopTimeout[i]);

                // nodeMapModel.updateNodeMap(nodeInformation);
                // NodeInformation mapNodeInfo =
                //    nodeMapModel.checkNodeMap(nodeInformation);
                nodeList.add(nodeInformation);
            }
        }

        try {
            nodeMapModel.updateNodeMap(nodeList);
        } catch (EngineConnectException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }

        /*
         * T[oɊi[Ăm[hŃNCAg̃m[hƈvȂ̂́A
         * 폜
         */
        ArrayList deleteList = nodeMapModel.getNodeInfoList("all", null, null);

        for (int i = 0; i < deleteList.size(); i++) {
            boolean isFound = false;
            NodeInformation checkNodeInfoInEngine =
                (NodeInformation) deleteList.get(i);

            for (int j = 0; j < nodeAddress.length; j++) {
                if (checkNodeInfoInEngine.getIpaddress().equals(nodeAddress[j])) {
                    isFound = true;

                    break;
                }
            }

            if (!isFound) {
                // Node Delete for Node Not Found
                logger.info("Delete : " + checkNodeInfoInEngine.getIpaddress());
                nodeMapModel.deleteNode(
                    checkNodeInfoInEngine.getEngineAddress(),
                    checkNodeInfoInEngine.getIpaddress());
            }
        }

        nodeMapLink.updateMapLink("all", linkStart, linkEnd);

        /*
         * m[hmapXVX|XClientɑM
         */
        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();
        out.print("Result" + "=" + "OK");
    }

    /*
     * m[hʏ񂩂m[hIcon擾܂B
     *
     * @param nodeKind m[h
     * @return String m[hIcon摜t@CpX
     */
    private String getNodeKindIcon(String nodeKind) {
        boolean isFound = false;
        FlashResourceInformationModel resource =
            new FlashResourceInformationModel();
        ArrayList iconLabelList = resource.getIconLabelList();
        ArrayList iconDatalList = resource.getIconDataList();
        int i = 0;

        for (i = 0; i < iconLabelList.size(); i++) {
            if (nodeKind.equals((String) iconLabelList.get(i))) {
                isFound = true;

                break;
            }
        }

        if (isFound) {
            return (String) iconDatalList.get(i);
        } else {
            return (String) iconDatalList.get(0);
        }
    }

    /*
     * m[hMap Savẽ|Xgp[^𒊏o܂B
     *
     * @param request HttpServletRequest
     */
    private void getPostParameter(HttpServletRequest request) {
        /* m[hĎp[^擾 */
        postNodeAddress = request.getParameter("nodeAddress");
        postNodeX = request.getParameter("nodeX");
        postNodeY = request.getParameter("nodeY");
        postNodeName = request.getParameter("nodeName");
        postNodeGroup = request.getParameter("nodeGroup");
        postNodeEngine = request.getParameter("nodeEngine");
        postNodeKind = request.getParameter("nodeKind");
        postLinkStart = request.getParameter("linkStart");
        postLinkEnd = request.getParameter("linkEnd");

        /* PingĎ */
        postNodePingPeriod = request.getParameter("nodePingPeriod");
        postNodePingThreshhold = request.getParameter("nodePingThreshhold");

        /* SnmpĎ */
        postNodeSnmpVersion = request.getParameter("nodeSnmpVersion");
        postNodeSnmpLevel = request.getParameter("nodeSnmpLevel");
        postNodeSnmpPeriod = request.getParameter("nodeSnmpPeriod");
        postNodeSnmpTimeout = request.getParameter("nodeSnmpTimeout");
        postNodeSnmpCommunity = request.getParameter("nodeSnmpCommunity");
        postNodeSnmpRWCommunity = request.getParameter("nodeSnmpRWCommunity");

        /* HttpĎ */
        postNodeHttpPeriod = request.getParameter("nodeHttpPeriod");
        postNodeHttptimeout = request.getParameter("nodeHttptimeout");
        postNodeHttpPort = request.getParameter("nodeHttpPort");
        postNodeHttpUrl = request.getParameter("nodeHttpUrl");

        /* SmtpĎ */
        postNodeSmtpPeriod = request.getParameter("nodeSmtpPeriod");
        postNodeSmtpTimeout = request.getParameter("nodeSmtpTimeout");
        postNodeSmtpPort = request.getParameter("nodeSmtpPort");
        postNodeSmtpSendAddress = request.getParameter("nodeSmtpSendAddress");
        postNodeSmtpCheckPopHost = request.getParameter("nodeSmtpCheckPopHost");
        postNodeSmtpCheckPopUser = request.getParameter("nodeSmtpCheckPopUser");
        postNodeSmtpCheckPopPassword =
            request.getParameter("nodeSmtpCheckPopPassword");
        postNodeSmtpCheckPopPort = request.getParameter("nodeSmtpCheckPopPort");
        postNodeSmtpCheckPopTimeout =
            request.getParameter("nodeSmtpCheckPopTimeout");

        /* Pop3Ď */
        postNodePopPeriod = request.getParameter("nodePopPeriod");
        postNodePopTimeout = request.getParameter("nodePopTimeout");
        postNodePopPort = request.getParameter("nodePopPort");
        postNodePopUser = request.getParameter("nodePopUser");
        postNodePopPassword = request.getParameter("nodePopPassword");
    }

    /*
     * m[hMap Savẽ|Xgp[^̑Ó`FbN܂B
     *
     */
    private void checkPostParameter() {
        // 𕪊Pattern
        Pattern pattern = null;

        // tB[hɃtB[h؂ŕ
        try {
            pattern = Pattern.compile(",");
        } catch (PatternSyntaxException e) {
            logger.severe("Error compiling expression : " + e.getMessage());

            return;
        }

        nodeAddress = pattern.split(postNodeAddress);
        nodeX = pattern.split(postNodeX);

        if (nodeX.length == 0) {
            nodeX = new String[nodeAddress.length];
        }

        nodeY = pattern.split(postNodeY);

        if (nodeY.length == 0) {
            nodeY = new String[nodeAddress.length];
        }

        nodeName = pattern.split(postNodeName);

        if (nodeName.length == 0) {
            nodeName = new String[nodeAddress.length];
        }

        String[] test = postNodeGroup.split(",");
        nodeGroup = pattern.split(postNodeGroup);

        if (nodeGroup.length == 0) {
            nodeGroup = new String[nodeAddress.length];
        }

        nodeEngine = pattern.split(postNodeEngine);

        /*
         * m[hʏ񂩂IconZbg
         */
        nodeKindIcon = pattern.split(postNodeKind);
        nodeKind = new String[nodeKindIcon.length];

        for (int i = 0; i < nodeKind.length; i++) {
            FlashResourceInformationModel resource =
                new FlashResourceInformationModel();
            ArrayList nodeIconDataList = resource.getIconDataList();
            ArrayList nodeIconLabelList = resource.getIconLabelList();

            for (int j = 0; j < nodeIconDataList.size(); j++) {
                if (nodeKindIcon[i].equals((String) nodeIconDataList.get(j))) {
                    nodeKind[i] = (String) nodeIconLabelList.get(j);

                    break;
                }
            }

            if (nodeKind[i] == null) {
                nodeKind[i] = "unkonown";
            }
        }

        /* Link */
        linkStart = pattern.split(postLinkStart);
        linkEnd = pattern.split(postLinkEnd);

        /* PingĎ */
        nodePingPeriod = pattern.split(postNodePingPeriod);

        if (nodePingPeriod.length == 0) {
            nodePingPeriod = new String[nodeAddress.length];
        }

        nodePingThreshhold = pattern.split(postNodePingThreshhold);

        if (nodePingThreshhold.length == 0) {
            nodePingThreshhold = new String[nodeAddress.length];
        }

        /* SnmpĎ */
        nodeSnmpVersion = pattern.split(postNodeSnmpVersion);

        if (nodeSnmpVersion.length == 0) {
            nodeSnmpVersion = new String[nodeAddress.length];
        }

        nodeSnmpLevel = pattern.split(postNodeSnmpLevel);

        if (nodeSnmpLevel.length == 0) {
            nodeSnmpLevel = new String[nodeAddress.length];
        }

        nodeSnmpPeriod = pattern.split(postNodeSnmpPeriod);

        if (nodeSnmpPeriod.length == 0) {
            nodeSnmpPeriod = new String[nodeAddress.length];
        }

        nodeSnmpTimeout = pattern.split(postNodeSnmpTimeout);

        if (nodeSnmpTimeout.length == 0) {
            nodeSnmpTimeout = new String[nodeAddress.length];
        }

        nodeSnmpCommunity = pattern.split(postNodeSnmpCommunity);

        if (nodeSnmpCommunity.length == 0) {
            nodeSnmpCommunity = new String[nodeAddress.length];
        }

        nodeSnmpRWCommunity = pattern.split(postNodeSnmpRWCommunity);

        if (nodeSnmpRWCommunity.length == 0) {
            nodeSnmpRWCommunity = new String[nodeAddress.length];
        }

        /* HttpĎ */
        nodeHttpPeriod = pattern.split(postNodeHttpPeriod);

        if (nodeHttpPeriod.length == 0) {
            nodeHttpPeriod = new String[nodeAddress.length];
        }

        nodeHttptimeout = pattern.split(postNodeHttptimeout);

        if (nodeHttptimeout.length == 0) {
            nodeHttptimeout = new String[nodeAddress.length];
        }

        nodeHttpPort = pattern.split(postNodeHttpPort);

        if (nodeHttpPort.length == 0) {
            nodeHttpPort = new String[nodeAddress.length];
        }

        nodeHttpUrl = pattern.split(postNodeHttpUrl);

        if (nodeHttpUrl.length == 0) {
            nodeHttpUrl = new String[nodeAddress.length];
        }

        /* SmtpĎ */
        nodeSmtpPeriod = pattern.split(postNodeSmtpPeriod);

        if (nodeSmtpPeriod.length == 0) {
            nodeSmtpPeriod = new String[nodeAddress.length];
        }

        nodeSmtpTimeout = pattern.split(postNodeSmtpTimeout);

        if (nodeSmtpTimeout.length == 0) {
            nodeSmtpTimeout = new String[nodeAddress.length];
        }

        nodeSmtpPort = pattern.split(postNodeSmtpPort);

        if (nodeSmtpPort.length == 0) {
            nodeSmtpPort = new String[nodeAddress.length];
        }

        nodeSmtpSendAddress = pattern.split(postNodeSmtpSendAddress);

        if (nodeSmtpSendAddress.length == 0) {
            nodeSmtpSendAddress = new String[nodeAddress.length];
        }

        nodeSmtpCheckPopHost = pattern.split(postNodeSmtpCheckPopHost);

        if (nodeSmtpCheckPopHost.length == 0) {
            nodeSmtpCheckPopHost = new String[nodeAddress.length];
        }

        nodeSmtpCheckPopUser = pattern.split(postNodeSmtpCheckPopUser);

        if (nodeSmtpCheckPopUser.length == 0) {
            nodeSmtpCheckPopUser = new String[nodeAddress.length];
        }

        nodeSmtpCheckPopPassword = pattern.split(postNodeSmtpCheckPopPassword);

        if (nodeSmtpCheckPopPassword.length == 0) {
            nodeSmtpCheckPopPassword = new String[nodeAddress.length];
        }

        nodeSmtpCheckPopPort = pattern.split(postNodeSmtpCheckPopPort);

        if (nodeSmtpCheckPopPort.length == 0) {
            nodeSmtpCheckPopPort = new String[nodeAddress.length];
        }

        nodeSmtpCheckPopTimeout = pattern.split(postNodeSmtpCheckPopTimeout);

        if (nodeSmtpCheckPopTimeout.length == 0) {
            nodeSmtpCheckPopTimeout = new String[nodeAddress.length];
        }

        /* Pop3Ď */
        nodePopPeriod = pattern.split(postNodePopPeriod);

        if (nodePopPeriod.length == 0) {
            nodePopPeriod = new String[nodeAddress.length];
        }

        nodePopTimeout = pattern.split(postNodePopTimeout);

        if (nodePopTimeout.length == 0) {
            nodePopTimeout = new String[nodeAddress.length];
        }

        nodePopPort = pattern.split(postNodePopPort);

        if (nodePopPort.length == 0) {
            nodePopPort = new String[nodeAddress.length];
        }

        nodePopUser = pattern.split(postNodePopUser);

        if (nodePopUser.length == 0) {
            nodePopUser = new String[nodeAddress.length];
        }

        nodePopPassword = pattern.split(postNodePopPassword);

        if (nodePopPassword.length == 0) {
            nodePopPassword = new String[nodeAddress.length];
        }
    }
}
