/*
 * Created on 2003/08/14
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.start;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * ʃm[h}l[WpWindowI[vJSPNANVNXłB
 * WindowI[vɃt[\ANVVɋN܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeManagerStart extends Action {

    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);

        // request.setAttribute("engineAddress", engineAddress);

        /* ʗpm[h}l[WƂāA[hZbg */
        HttpSession session = request.getSession();
        session.setAttribute(Preference.AUTH_MODE, Preference.AUTH_MODE_NOAUTH);

        return mapping.findForward(Preference.SUCCESS);
    }
}
