/*
 * Created on 2003/08/11
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.list.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;


/**
 * m[hĎ񃊃Xg擾NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeListViewModel {
    private static Logger logger = null;

    public NodeListViewModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public ArrayList getList(
        String engineAddress, String sortColumn, String sortDirection)
        throws EngineConnectException, IOException {
        int connectOKEngineNo = 0;

        /* EngineƐڑm[h擾邽߂̃CX^X */
        ConnectionNodeInformation nodeInfoConnection = null;

        /* ڑOK Enginẽm[hĎi[郊Xg */
        ArrayList nodeInfoList = null;

        logger.info("Connect engineAddress : " + engineAddress);

        if (engineAddress.equals("all")) {
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();

            /* ڑOK Enginẽm[hĎi[Xg */
            nodeInfoList = new ArrayList();

            /*
             * o^EngineSĂɏڑAڑOK Enginem[hĎ񃊃Xg
             * 擾
             */
            for (int i = 0; i < engineList.size(); i++) {
                String testEngineAddress =
                    ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
                logger.info("Check engine connect : " + testEngineAddress);

                ArrayList workNodeInfoList = null;

                try {
                    nodeInfoConnection =
                        new ConnectionNodeInformation(testEngineAddress);
                    workNodeInfoList =
                        nodeInfoConnection.getNodeInformationList(
                            sortColumn, sortDirection);
                    connectOKEngineNo++;

                    if (
                        (workNodeInfoList != null)
                            && (workNodeInfoList.size() > 0)) {
                        /*
                         * ڑOK Enginem[hĎ擾
                         */
                        for (int j = 0; j < workNodeInfoList.size(); j++) {
                            NodeInformation nodeInfo =
                                (NodeInformation) workNodeInfoList.get(j);
                            nodeInfoList.add(nodeInfo);
                        }
                    }
                } catch (EngineConnectException e) {
                    logger.warning(e.getMessage());
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                } catch (Exception e) {
                    logger.warning(e.getMessage());
                }
            }

            if (connectOKEngineNo < 1) {
                /*
                     * ڑOK EngineȂΈُƂA
                     * łΏpƂ
                     */
                if (engineList.size() > 0) {
                    String testEngineAddress =
                        ((EngineResourceInfo) engineList.get(0))
                        .getEngineIPaddress();
                    String testEnginePort =
                        ((EngineResourceInfo) engineList.get(0)).getEnginePort();
                    logger.warning(
                        "Engine connect abort Engine Address="
                        + testEngineAddress + ", Engine Port=" + testEnginePort);
                    throw new EngineConnectException(
                        "Engine connect abort Engine Address="
                        + testEngineAddress + ", Engine Port=" + testEnginePort);
                }
            }

            logger.info("engineList.size() : " + engineList.size());

            if (
                (engineList.size() > 1) && (sortColumn != null)
                    && (sortDirection != null)) {
                logger.info("sortColumn : " + sortColumn);
                logger.info("sortDirection : " + sortDirection);

                /*  */
                NodeListSort listSort = new NodeListSort();
                nodeInfoList =
                    listSort.sortObjectArray(
                        nodeInfoList, sortColumn, sortDirection);
            }
        } else {
            try {
                nodeInfoConnection =
                    new ConnectionNodeInformation(engineAddress);
                nodeInfoList =
                    nodeInfoConnection.getNodeInformationList(
                        sortColumn, sortDirection);
            } catch (EngineConnectException e) {
                logger.warning(
                    e.getMessage() + " abort engine : " + engineAddress);
                throw e;
            } catch (IOException e) {
                logger.warning(
                    e.getMessage() + " abort engine : " + engineAddress);
                throw e;
            }
        }

        return nodeInfoList;
    }
}
