/*
 * Created on 2004/04/07
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.list.model;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.NodeInformation;


/**
 * m[hĎXg\[g郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 *@@version 1.0
 */
public class NodeListSort {
    /** m[hĎe[u m[hJ */
    public static final String NODENAME = "nodename";

    /** m[hĎe[u m[hIPAhXJ */
    public static final String IPADDRESS = "ipaddress";

    /** m[hĎe[u m[hO[vJ */
    public static final String NODEGROUP = "nodegroup";

    /** m[hĎe[u m[hIcon XWJ */
    public static final String NODEX = "nodeX";

    /** m[hĎe[u m[hIcon YWJ */
    public static final String NODEY = "nodeY";

    /** m[hĎe[u m[hʃJ */
    public static final String NODEKIND = "nodeKind";

    /** m[hĎe[u PingĎJ */
    public static final String PING_PERIOD = "ping_period";

    /** m[hĎe[u PingĎ臒lJ */
    public static final String PING_THRESHOLD = "ping_threshold";

    /** m[hĎe[u SNMPĎo[WJ */
    public static final String SNMP_VERSION = "snmpVersion";

    /** m[hĎe[u SNMPĎJ */
    public static final String SNMP_PERIOD = "snmp_period";

    /** m[hĎe[u SNMPĎ^CAEglJ */
    public static final String SNMPTIMEOUT = "snmp_timeout";

    /** m[hĎe[u SNMPĎxJ */
    public static final String SNMP_LEVEL = "snmp_level";

    /** m[hĎe[u SNMP ReadR~jeBJ */
    public static final String SNMP_ROCOMMUNITY = "community";

    /** m[hĎe[u SNMP Read/WriteR~jeBJ */
    public static final String SNMP_RWCOMMUNITY = "RWCommunity";

    /** m[hĎe[u HTTPĎURLJ */
    public static final String HTTP_URL = "http_url";

    /** m[hĎe[u HTTPĎJ */
    public static final String HTTP_PERIOD = "http_period";

    /** m[hĎe[u HTTPĎ|[gJ */
    public static final String HTTP_PORT = "http_port";

    /** m[hĎe[u HTTPĎ^CAEglJ */
    public static final String HTTP_TIMEOUT = "http_timeout";

    /** m[hĎe[u Pop3ĎJ */
    public static final String POP3_PERIOD = "pop3_period";

    /** m[hĎe[u SMTPĎJ */
    public static final String SMTP_PERIOD = "smtp_period";

    /** m[hĎe[u SMTPĎ|[gJ */
    public static final String SMTP_PORT = "smtp_port";

    /** m[hĎe[u SMTPĎ^CAEglJ */
    public static final String SMTP_TIMEOUT = "smtp_timeout";

    /** m[hĎe[u GWAhXJ */
    public static final String ENGINE_ADDRESS = "engine_Address";

    /** m[hĎe[u ŐVĎJ */
    public static final String LAST_CHECK = "last_check";

    /** m[hĎe[u m[ho^J */
    public static final String REGISTER_DATE = "register_date";

    /** m[hĎe[u \[gLq */
    public static final String SORT_DIRECTION_ASC = "asc";

    /** m[hĎe[u ~\[gLq */
    public static final String SORT_DIRECTION_DESC = "desc";

    /* \[gΏۃJԍɏlݒ */
    private static String selectColumn = NODENAME;

    /*
     * ܂͍~̂ꂩŃ\[gstOŃ\[gs
     * gOɔ]
     * l͏
     */
    private static String isOrderDirection = SORT_DIRECTION_ASC;

    /* Logging */
    private static Logger logger;

    public NodeListSort() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * IuWFNgXg\[g܂B<BR>
     *
     * @param nodeInfoList \[gXg
     * @param _selectColumn \[gΏۃJ
     * @param _order \[g
     * @return nodeInfoList \[gʂ̃IuWFNgXg
     */
    public ArrayList sortObjectArray(
        ArrayList nodeInfoList, final String _selectColumn, final String _order) {
        selectColumn = _selectColumn;
        isOrderDirection = _order;

        // System.out.println("Sort mibinfoList.size() : " + nodeInfoList.size());
        nodeInfoList = sortObjectArray(nodeInfoList);

        /* \[gʂԂ */
        return nodeInfoList;
    }

    /**
     * ɐݒς݂̃\[gɏ]āAe[ǔ^Ƀ\[g
     * s܂B<BR>
     *
     * @param nodeInfoList \[gΏۂ̃IuWFNg̃Xg
     * @return nodeInfoList \[gs̃IuWFNg̃Xg
     */
    public ArrayList sortObjectArray(ArrayList nodeInfoList) {
        /* ̏ꍇ̃\[g */
        nodeInfoList = sortString(nodeInfoList);

        return nodeInfoList;
    }

    /**
     *@^̃\[gs܂B<BR>
     *
     * @param datainfos \[gΏۂDataInfoIuWFNg̔z
     * @return datainfos \[gsDataInfoIuWFNg̔z
     */
    private ArrayList sortString(ArrayList nodeInfoList) {

        for (int i = 0; i < (nodeInfoList.size() - 1); i++) {
            for (
                int checkPoint = nodeInfoList.size() - 1; checkPoint > i;
                    checkPoint--) {
                int resultCompareNumber = 0;
                NodeInformation currentNodeInfo =
                    (NodeInformation) nodeInfoList.get(checkPoint);
                NodeInformation nextNodeInfo =
                    (NodeInformation) nodeInfoList.get(checkPoint - 1);

                String currentinfo = "";
                String nextinfo = "";

                if (selectColumn.equals(NODEGROUP)) {
                    // logger.info("Sort Group : " + NODEGROUP);
                    currentinfo = currentNodeInfo.getGroup();
                    nextinfo = nextNodeInfo.getGroup();
                } else if (selectColumn.equals(NODENAME)) {
                    // logger.info("Sort NodeName : " + NODENAME);
                    currentinfo = currentNodeInfo.getNodename();
                    nextinfo = nextNodeInfo.getNodename();
                } else if (selectColumn.equals(IPADDRESS)) {
                    // logger.info("Sort IPAddrees : " + IPADDRESS);
                    currentinfo = currentNodeInfo.getIpaddress();
                    nextinfo = nextNodeInfo.getIpaddress();
                } else if (selectColumn.equals(ENGINE_ADDRESS)) {
                    // logger.info("Sort Engine address : " + ENGINE_ADDRESS);
                    currentinfo = currentNodeInfo.getEngineAddress();
                    nextinfo = nextNodeInfo.getEngineAddress();
                } else if (selectColumn.equals(REGISTER_DATE)) {
                    // logger.info("Sort Register date : " + REGISTER_DATE);
                    currentinfo = currentNodeInfo.getRegisterDate();
                    nextinfo = nextNodeInfo.getRegisterDate();
                } else if (selectColumn.equals(LAST_CHECK)) {
                    // logger.info("Sort Last check : " + LAST_CHECK);
                    currentinfo = currentNodeInfo.getLastCheck();
                    nextinfo = nextNodeInfo.getLastCheck();
                }

                resultCompareNumber = (currentinfo).compareTo(nextinfo);
                nodeInfoList =
                    swapRow(nodeInfoList, checkPoint, resultCompareNumber);
            }
        }

        return nodeInfoList;
    }

    private ArrayList swapRow(
        ArrayList nodeInfoList, final int rowPosition,
        final int resultCompareNumber) {
        if (isOrderDirection.equals(SORT_DIRECTION_ASC)) {
            if (resultCompareNumber < 0) {
                nodeInfoList = swap(nodeInfoList, rowPosition);
            } else if (resultCompareNumber == 0) {
                nodeInfoList = resortRow(nodeInfoList, rowPosition);
            }
        } else {
            if (resultCompareNumber > 0) {
                nodeInfoList = swap(nodeInfoList, rowPosition);
            } else if (resultCompareNumber == 0) {
                nodeInfoList = resortRow(nodeInfoList, rowPosition);
            }
        }

        return nodeInfoList;
    }

    private ArrayList resortRow(ArrayList nodeInfoList, int rowPosition) {
        NodeInformation nodeInfo =
            (NodeInformation) nodeInfoList.get(rowPosition);
        NodeInformation nextNodeInfo =
            (NodeInformation) nodeInfoList.get(rowPosition - 1);

        String currentinfo = "";
        String nextinfo = "";
        currentinfo = nodeInfo.getIpaddress();
        nextinfo = nextNodeInfo.getIpaddress();

        if (isOrderDirection.equals(SORT_DIRECTION_ASC)) {
            if ((currentinfo).compareTo(nextinfo) < 0) {
                nodeInfoList = swap(nodeInfoList, rowPosition);
            }
        } else {
            if ((currentinfo).compareTo(nextinfo) > 0) {
                nodeInfoList = swap(nodeInfoList, rowPosition);
            }
        }

        return nodeInfoList;
    }

    private ArrayList swap(ArrayList nodeInfoList, int rowPosition) {
        Object work = nodeInfoList.get(rowPosition);
        nodeInfoList.set(rowPosition, nodeInfoList.get(rowPosition - 1));
        nodeInfoList.set(rowPosition - 1, work);

        return nodeInfoList;
    }
}
