/*
 * Created on 2003/08/07
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.miboperation.model;

import java.io.IOException;

import netjfwatcher.engine.socket.ConnectionMibGet;
import netjfwatcher.engine.socket.ConnectionMibSet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.MibGetResponseList;


/**
 * GWMIB̎vs\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibGetModel {
    /**
     * MIB̎̂߂ɃGWƂ̒ʐMsAʂԂ܂B
     *
     * @param engineAddress GWAhX
     * @param targetIPAddress AgentAhX
     * @param version SNMPo[W
     * @param community SNMP ReadR~jeB
     * @param requestOid vOID
     * @return mibGetPesponseList MIB̎挋ʃXg
     * @throws EngineConnectException GWƂ̐ڑɈُ킪ꍇ
     * @throws IOException GWƂ̐ڑɈُ킪ꍇ
     */
    public MibGetResponseList getMib(
        String engineAddress, String targetIPAddress, String version,
        String community, String requestOid)
        throws EngineConnectException, IOException {
        ConnectionMibGet mibgetInstanc = new ConnectionMibGet(engineAddress);
        MibGetResponseList mibGetPesponseList =
            mibgetInstanc.mibGet(
                targetIPAddress, version, requestOid, community);

        return mibGetPesponseList;
    }

    /**
     * GWMIBZbgʒmAʂԂ܂B
     *
     * @param serverAddress GWAhX
     * @param targetIPAddress AgentAhX
     * @param version SNMPo[W
     * @param community SNMP writeR~jeB
     * @param requestMibOid OID
     * @param value SNMPݒl
     * @param valueType SNMP Object^Cv
     * @return mibGetPesponseList MIBZbgʃXg
     * @throws EngineConnectException GWƂ̐ڑɈُ킪ꍇ
     * @throws IOException GWƂ̐ڑɈُ킪ꍇ
     */
    public MibGetResponseList setMib(
        String serverAddress, String targetIPAddress, String version,
        String community, String requestMibOid, String value, String valueType)
        throws EngineConnectException, IOException {
        ConnectionMibSet mibgetInstanc = new ConnectionMibSet(serverAddress);
        MibGetResponseList mibGetPesponseList =
            mibgetInstanc.setMib(
                targetIPAddress, version, community, requestMibOid, value,
                valueType);

        return mibGetPesponseList;
    }
}
