/*
 * Created on 2004/07/14
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.miboperation;

import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.MibInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.noderegister.NodeAddViewAction;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.preference.Preference;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * MIB̎ɂAIy[VplJSPpɈȉ̏ԂANVNXłB
 * Em[hIPAhX
 * ECommunity
 * EOID
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibGetOperationFrameAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "localhost";
        }

        String ipaddress = request.getParameter(Preference.IPADDRESS);

        String community = NodeAddViewAction.INITIAL_NODE_SNMP_ROCOMMUNITY;
        String version = NodeAddViewAction.INITIAL_NODE_SNMP_VERSION;

        NodeInformation nodeInfo = null;

        if (!engineAddress.equals("all")) {
            // IPAhXɑΉCommunity擾
            NodeRegisterModel nodeinfomodel = new NodeRegisterModel();
            nodeInfo = nodeinfomodel.getIPTarget(engineAddress, ipaddress);
        }

        if (nodeInfo != null) {
            community = nodeInfo.getRoCommunity();
            version = nodeInfo.getSnmpVersion();
        }

        // JSPɑ΂āAm[hIPAhXACommunityԂ
        MibInfo mibInfo = new MibInfo();
        mibInfo.setIpaddress(ipaddress);
        mibInfo.setVersionString(version);
        mibInfo.setRoCommunity(community);
        request.setAttribute(Preference.SNMP_MIB_INFO, mibInfo);

        ArrayList engineInfoList = null;

        if (engineAddress.equals("all")) {
            engineInfoList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();
        } else {
            EngineResourceInfo engineInfo = new EngineResourceInfo();
            engineInfo.setEngineIPaddress(engineAddress);
            engineInfoList = new ArrayList();
            engineInfoList.add(engineInfo);
        }

        request.setAttribute(Preference.ENGINE_INFO_LIST, engineInfoList);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
