/*
 * Created on 2003/08/24
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionXMLSocketState;
import netjfwatcher.engine.socket.EngineConnectException;


/**
 * GWƒʐMXML Socketڑ󋵏擾܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class XMLSocketStateModel {
    /* MO */
    private static Logger logger = null;

    /**
     * GWƒʐMXML Socketڑ󋵏擾NX
     * CX^X𐶐܂B
     */
    public XMLSocketStateModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * GWƒʐMXML Socketڑ󋵏擾܂B
     *
     * @param engineAddress engineAddress GWAhX
     * @return connectStateList XML SocketڑԃXg
     */
    public ArrayList getList(String engineAddress) {
        ArrayList connectStateList = null;

        ConnectionXMLSocketState command =
            new ConnectionXMLSocketState(engineAddress);

        try {
            connectStateList = command.getXmlsocketConnectState();
        } catch (EngineConnectException e) {
            logger.warning("Abort connect engine : " + e.getMessage());
        } catch (IOException e) {
            logger.warning("Abort connect engine : " + e.getMessage());
        }

        return connectStateList;
    }
}
