/*
 * Created on 2004/05/28
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.flashaction;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.MailProperty;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.engine.socket.info.XMLSocketConnectState;
import netjfwatcher.maintenance.model.FlashResourceInformationModel;
import netjfwatcher.maintenance.model.ResourceManagementModel;
import netjfwatcher.maintenance.model.XMLSocketStateModel;
import netjfwatcher.preference.Preference;


/**
 * FlashɈȉ̃\[X𑗂T[ubgNXłB
 * EIconI
 * ENCAg Flash XML Socketڑ
 * ETEht@C
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class FlashResourceInformationAction extends HttpServlet {
    /** NCAgԂƂ̒ʐMɂSound֘AI[hLq */
    public static final String SOUND_SELECT = "Sound";

    /** NCAgԂƂ̒ʐMɂXML Socket֘AI[hLq */
    public static final String XML_SOCKET_CONNECT_STATE = "XML_Socket";

    /** NCAgԂƂ̒ʐMɂMail֘AI[hLq */
    public static final String MAIL_SELECT = "Mail";

    /** NCAgԂƂ̒ʐMɂIcon֘AI[hLq */
    public static final String ICON_SELECT = "Icon";

    /* MO */
    private static Logger logger = null;

    /* GWAhX */
    private String engineAddress = null;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());
        engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "all";
        }

        String mode = request.getParameter("mode");

        if (mode.equals(ICON_SELECT) || mode.equals(SOUND_SELECT)) {
            this.loadFlashInfo(response);
        } else if (mode.equals(XML_SOCKET_CONNECT_STATE)) {
            this.loadXMLConnectState(response);
        } else if (mode.equals(MAIL_SELECT)) {
            try {
                this.loadMail(request, response);
            } catch (EngineConnectException e) {
                logger.warning(
                    "EngineConnectException " + e.getMessage() + " Engine = "
                    + engineAddress);
                e.printStackTrace();
            }
        }
    }

    private void loadMail(
        HttpServletRequest request, HttpServletResponse response)
        throws EngineConnectException, IOException {
        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        ResourceManagementModel resourceModel = new ResourceManagementModel();
        ResourceInfo resourceInfo = resourceModel.getResource(engineAddress);
        MailProperty[] mailProp = resourceInfo.getMailPropertyList();

        String[] mailSMTPHost = new String[mailProp.length];
        String[] mailValid = new String[mailProp.length];
        String[] mailFrom = new String[mailProp.length];
        String[][] mailToList = new String[mailProp.length][];

        for (int i = 0; i < mailProp.length; i++) {
            // mailProp[i].getMail_SendFlag();
            mailSMTPHost[i] = mailProp[i].getSmtpHost();
            mailValid[i] = mailProp[i].getMailSendFlag();
            mailFrom[i] = mailProp[i].getFrom();
            mailToList[i] = mailProp[i].getTo();
        }

        out.print("MailCount=" + mailProp.length);
        // System.out.println("MailCount : " + mailProp.length);

        int mailCount;

        for (mailCount = 0; mailCount < mailProp.length; mailCount++) {
            out.print(
                "&MailSMTPHost" + mailCount + "=" + mailSMTPHost[mailCount]);
            out.print("&MailValid" + mailCount + "=" + mailValid[mailCount]);
            out.print("&MailFrom" + mailCount + "=" + mailFrom[mailCount]);

            out.print(
                "&MailToCount" + mailCount + "=" + mailToList[mailCount].length);

            /*
             System.out.println(
                     "&MailSMTPHost : " + mailCount + "=" + mailSMTPHost[mailCount]);
             System.out.println(
                     "&MailValid : " + mailCount + "=" + mailValid[mailCount]);
             System.out.println(
                     "&MailFrom : " + mailCount + "=" + mailFrom[mailCount]);
             System.out.println(
                "&MailToCount : " + mailCount + "="
                + mailToList[mailCount].length);
                        */
            for (int toCnt = 0; toCnt < mailToList[mailCount].length;
                    toCnt++) {
                out.print(
                    "&MailTo" + mailCount + toCnt + "="
                    + mailToList[mailCount][toCnt]);

                /*
                System.out.println(
                    "&MailTo : " + mailCount + toCnt + "="
                    + mailToList[mailCount][toCnt]);
                */
            }
        }
    }

    private void loadXMLConnectState(HttpServletResponse response)
        throws IOException, ServletException {
        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        XMLSocketStateModel socketstate = new XMLSocketStateModel();

        ArrayList xmlSocketConnectList = socketstate.getList(engineAddress);
        String[] remoteIPAddress = new String[xmlSocketConnectList.size()];
        String[] connectStartTime = new String[xmlSocketConnectList.size()];

        for (int i = 0; i < xmlSocketConnectList.size(); i++) {
            XMLSocketConnectState connectState =
                (XMLSocketConnectState) xmlSocketConnectList.get(i);
            remoteIPAddress[i] = connectState.getRemoteIP();
            connectStartTime[i] = connectState.getStartTime().toString();

            /*
            System.out.println(
                "Mainte check remote ip : " + connectState.getRemoteIP());
            System.out.println(
                "Mainte check start time : " + connectState.getStartTime());
            */
        }

        out.print("ConnectCount=" + xmlSocketConnectList.size());

        // System.out.println("ConnectCount : " + xmlSocketConnectList.size());
        int connectCount;

        for (
            connectCount = 0; connectCount < xmlSocketConnectList.size();
                connectCount++) {
            out.print(
                "&RemoteIPAddress" + connectCount + "="
                + remoteIPAddress[connectCount]);
            out.print(
                "&ConnectStartTime" + connectCount + "="
                + connectStartTime[connectCount]);

            /*
            System.out.println(
                "&RemoteIPAddress : " + connectCount + "="
                + remoteIPAddress[connectCount]);
            System.out.println(
                "&ConnectStartTime : " + connectCount + "="
                + connectStartTime[connectCount]);
            */
        }
    }

    private void loadFlashInfo(HttpServletResponse response)
        throws IOException, ServletException {
        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        FlashResourceInformationModel information =
            new FlashResourceInformationModel();
        ArrayList soundList = information.getSoundFileList();
        ArrayList iconLabelList = information.getIconLabelList();
        ArrayList iconDataList = information.getIconDataList();

        out.print("SoundCount=" + Integer.toString(soundList.size()));

        /*
        System.out.println(
            "SoundCount : " + Integer.toString(soundList.size()));
                */
        int soundFileCount;

        for (
            soundFileCount = 0; soundFileCount < soundList.size();
                soundFileCount++) {
            out.print(
                "&SoundFile" + soundFileCount + "="
                + soundList.get(soundFileCount));

            /*
            System.out.println(
                "&SoundFile : " + soundFileCount + "="
                + soundList.get(soundFileCount));
            */
        }

        out.print(
            "&IconLabelCount=" + Integer.toString(iconLabelList.size()));

        /*
        System.out.println(
            "&IconLabelCount : " + Integer.toString(iconLabelList.size()));
                */
        int iconLabelCount;

        for (
            iconLabelCount = 0; iconLabelCount < iconLabelList.size();
                iconLabelCount++) {
            out.print(
                "&IconLabel" + iconLabelCount + "="
                + iconLabelList.get(iconLabelCount));
            out.print(
                "&IconData" + iconLabelCount + "="
                + iconDataList.get(iconLabelCount));

            /*
            System.out.println(
                "&IconLabel : " + iconLabelCount + "="
                + iconLabelList.get(iconLabelCount));
            System.out.println(
                "&IconData : " + iconLabelCount + "="
                + iconDataList.get(iconLabelCount));
            */
        }
    }
}
