/*
 * Created on 2004/06/03
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.flashaction;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.preference.Preference;


/**
 * ێ烁eiXWindowł̃eXg@\ɂA[ʒm@\œo^ς݃m[h̋^A[
 * s߂̓o^m[hIsFlash swf̃T[ubgNXłB
 * Alarm_Test.swf烍[hNodeRegister.swfNAo^m[hIPAhX
 * m[hԂ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class FlashNodeListAction extends HttpServlet {
    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        this.loadNodeList(request, response);
    }

    private void loadNodeList(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException {
        String serverAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (serverAddress == null) {
            serverAddress = "localhost";
        }

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        NodeRegisterModel nodeListinfo = new NodeRegisterModel();
        ArrayList nodeList = null;

        try {
            nodeList = nodeListinfo.getList(serverAddress);
        } catch (EngineConnectException e) {
            e.printStackTrace();
        }

        String[] nodeIPAddress = new String[nodeList.size()];
        String[] nodeName = new String[nodeList.size()];

        for (int i = 0; i < nodeList.size(); i++) {
            NodeInformation nodeInfo = (NodeInformation) nodeList.get(i);
            nodeIPAddress[i] = nodeInfo.getIpaddress();
            nodeName[i] = nodeInfo.getNodename();
        }

        out.print("NodeCount=" + nodeList.size());

        int nodeCount;

        for (nodeCount = 0; nodeCount < nodeList.size(); nodeCount++) {
            out.print(
                "&NodeIPAddress" + nodeCount + "=" + nodeIPAddress[nodeCount]);
            out.print("&NodeName" + nodeCount + "=" + nodeName[nodeCount]);
        }
    }
}
