/*
 * Created on 2004/06/06
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.flashaction;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.DatabasePropertyInfo;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.maintenance.model.DatabaseTestModel;
import netjfwatcher.maintenance.model.ResourceManagementModel;
import netjfwatcher.preference.Preference;


/**
 * f[^x[X̉ғeXgsANVNXŁANCAg̗v
 * Ήȉ3@\񋟂T[ubgNXłB
 * Ef[^x[XvpeBNCAg֑M
 * Ef[^x[XvpeB̍XV
 * Ef[^x[X̉ғeXg
 *
 * @author Yoshimasa matsumoto
 * @version 1.0
 */
public class DatabaseTestControlAction extends HttpServlet {
    private static Logger logger = null;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
        }

        String mode = request.getParameter("mode");

        if (mode.equals("load")) {
            /*
             * f[^x[XeXĝ߂Ɍ̃f[^x[XvpeB
             * GW擾ăNCAg֑M
             */
            logger.info("Database prop load");

            try {
                this.loadResource(request, response);
            } catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        } else if (mode.equals("test")) {
            /*
             * f[^x[X̉ғeXgs
             */
            logger.info("Database test exec");

            try {
                this.testDatabase(request, response);
            } catch (EngineConnectException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        } else if (mode.equals("update")) {
            /*
             * f[^x[XvpeB̍XV
             */
            logger.info("Database prop update exec");
            this.updateResource(request, response);
        }
    }

    /*
     * f[^x[XvpeBNCAg֑M܂B
     *
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @throws IOException
     */
    private void loadResource(
        HttpServletRequest request, HttpServletResponse response)
        throws Exception {
        String engineAddress = request.getParameter("engineAddress");

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
        }

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        /* GW烊\[X擾 */
        ResourceManagementModel resourceModel = new ResourceManagementModel();
        ResourceInfo resourceInfo = resourceModel.getResource(engineAddress);

        /* \[X񂩂猻̃f[^x[XvpeB擾 */
        String databaseName = resourceInfo.getDatabaseName();
        String databaseDriver = resourceInfo.getDatabaseDriver();
        String databaseURL = resourceInfo.getDatabaseUrl();
        String databaseUser = resourceInfo.getDatabaseUser();
        String databasePassword = resourceInfo.getDatabasePassword();

        out.print("database_Name=" + databaseName);
        out.print("&database_Driver=" + databaseDriver);
        out.print("&database_URL=" + databaseURL);
        out.print("&database_User=" + databaseUser);
        out.print("&database_Password=" + databasePassword);

        /*
         * f[^x[XvpeB񃊃Xgf[^x[Xʖ̏擾
         * ANCAgɑM
         */
        DatabaseTestModel databasetest = new DatabaseTestModel();
        DatabasePropertyInfo[] databasepropInfo =
            databasetest.getDatabaseProp(engineAddress);
        out.print("&databaseKindCount=" + databasepropInfo.length);

        for (int i = 0; i < databasepropInfo.length; i++) {
            out.print(
                "&databaseName" + i + "="
                + databasepropInfo[i].getDatabaseName());
            out.print(
                "&databaseDriver" + i + "="
                + databasepropInfo[i].getDatabaseDriver());
            out.print(
                "&databaseUrl" + i + "=" + databasepropInfo[i].getDatabaseUrl());
            out.print(
                "&databaseUser" + i + "="
                + databasepropInfo[i].getDatabaseUser());
            out.print(
                "&databasePassword" + i + "="
                + databasepropInfo[i].getDatabasePassword());
        }
    }

    /*
     * NCAg̃f[^x[XvpeBɂăf[^x[X̉ғeXg
     * sAʂNCAgɑM܂B
     *
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @throws EngineConnectException
     * @throws IOException
     */
    private void testDatabase(
        HttpServletRequest request, HttpServletResponse response)
        throws EngineConnectException, IOException {
        String serverAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (serverAddress == null) {
            logger.warning("Not server Address");
        }

        String postDatabaseName = request.getParameter("DatabaseName");
        String postDatabaseDriver = request.getParameter("Database_Driver");
        String postDatabaseURL = request.getParameter("Database_URL");
        String postDatabaseUser = request.getParameter("Database_User");
        String postDatabasePassword = request.getParameter("Database_Password");

        String databaseName = postDatabaseName;
        String databaseDriver = postDatabaseDriver;
        String databaseURL = postDatabaseURL;
        String databaseUser = postDatabaseUser;
        String databasePassword = postDatabasePassword;

        // 𕪊Pattern
        Pattern pattern = null;

        // tB[hɃtB[h؂ŕ
        try {
            pattern = Pattern.compile(",");
        } catch (PatternSyntaxException e) {
            logger.severe("Error compiling expression : " + e.getMessage());

            return;
        }

        DatabaseTestModel test = new DatabaseTestModel();

        String[] result =
            test.checkDatabase(
                serverAddress, databaseName, databaseDriver, databaseURL,
                databaseUser, databasePassword);

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();
        out.print("testResultCount=" + result.length);
        logger.info("testResultCount=" + result.length);

        for (int i = 0; i < result.length; i++) {
            out.print("&testResult" + i + "=" + result[i]);
            logger.info("&testResult" + i + "=" + result[i]);
        }
    }

    /*
     * NCAg̃f[^x[XvpeBɂăf[^x[XvpeB
     * XV܂B
     *
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @throws IOException
     */
    private void updateResource(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException {
        String serverAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (serverAddress == null) {
            logger.warning("Not server Address");
        }

        String postDatabaseName = request.getParameter("DatabaseName");
        String postDatabaseDriver = request.getParameter("Database_Driver");
        String postDatabaseURL = request.getParameter("Database_URL");
        String postDatabaseUser = request.getParameter("Database_User");
        String postDatabasePassword = request.getParameter("Database_Password");

        String databaseName = postDatabaseName;
        String databaseDriver = postDatabaseDriver;
        String databaseURL = postDatabaseURL;
        String databaseUser = postDatabaseUser;
        String databasePassword = postDatabasePassword;

        // 𕪊Pattern
        Pattern pattern = null;

        // tB[hɃtB[h؂ŕ
        try {
            pattern = Pattern.compile(",");
        } catch (PatternSyntaxException e) {
            logger.severe("Error compiling expression : " + e.getMessage());

            return;
        }

        ResourceManagementModel nodeedit = new ResourceManagementModel();

        try {
            nodeedit.updateDatabasePropResource(
                serverAddress, databaseName, databaseDriver, databaseURL,
                databaseUser, databasePassword);
        } catch (Exception e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
    }
}
