/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.GarbageCollectionControl;
import netjfwatcher.engine.command.control.CommandMappingTableResource;


/**
 * GWGWJVM̃[Ԃ擾郁\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionGarbageCollection extends AbstractConnectionEngine {
    /** GarbageCollectionJnR}hR[h */
    public static final String SUB_COMMAND_ID_GARBAGECOLLECTION_START = "Start";

    /** GarbageCollection~R}hR[h */
    public static final String SUB_COMMAND_ID_GARBAGECOLLECTION_STOP = "Stop";

    /** GarbageCollection̎R}hR[h */
    public static final String SUB_COMMAND_ID_GARBAGECOLLECTION_GET = "Get";

    /** GarbageCollection`FbNR}hR[h */
    public static final String SUB_COMMAND_ID_GARBAGECOLLECTION_CHECK = "Check";

    /* MO */
    private static Logger logger = null;

    /* GarbageCollection */
    private GarbageCollectionControl controlInfo =
        new GarbageCollectionControl();

    /* GarbageCollection */
    private GarbageCollectionControl responseControlInfo;

    /**
     * GWJVM̃[Ԃ擾CX^X
     * ܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionGarbageCollection(final String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * GWJVM GarbageCollection thread̃X^[gws܂B
     *
     * @param interval GarbageCollection Thread
     * @return responseControlInfo GarbageCollection
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public GarbageCollectionControl startGarbageCollection(
        final String interval) throws EngineConnectException, IOException {
        CommandInfo commnadInfo = new CommandInfo();
        long threadInterval = 5;

        try {
            threadInterval = Long.parseLong(interval);
        } catch (NumberFormatException e) {
            logger.warning(
                "GarbageCollection thread interval NumberFormatException");
            e.printStackTrace();
        }

        controlInfo.setIntervalTime(threadInterval * 1000);
        controlInfo.setCommand(SUB_COMMAND_ID_GARBAGECOLLECTION_START);
        commnadInfo.setGarbageCollectionControlInfo(controlInfo);

        commnadInfo.setCode(
            CommandMappingTableResource.GARBAGECOLLECTION_COMMAND_ID);

        responseControlInfo =
            (GarbageCollectionControl) this.communicationToEngine(commnadInfo);

        return responseControlInfo;
    }

    /**
     * GarbageCollection~܂B
     *
     * @return responseControlInfo GarbageCollection
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public GarbageCollectionControl stopGarbageCollection()
        throws EngineConnectException, IOException {
        CommandInfo commnadInfo = new CommandInfo();

        controlInfo.setCommand(SUB_COMMAND_ID_GARBAGECOLLECTION_STOP);
        commnadInfo.setGarbageCollectionControlInfo(controlInfo);

        commnadInfo.setCode(
            CommandMappingTableResource.GARBAGECOLLECTION_COMMAND_ID);

        responseControlInfo =
            (GarbageCollectionControl) this.communicationToEngine(commnadInfo);

        return responseControlInfo;
    }

    /**
     * GarbageCollection擾܂B
     *
     * @param startTime Jn
     * @param endTime I
     * @return responseControlInfo@GarbageCollection
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public GarbageCollectionControl getGarbageCollectionInfo(
        final String startTime, final String endTime)
        throws EngineConnectException, IOException {
        CommandInfo commnadInfo = new CommandInfo();

        controlInfo.setCommand(SUB_COMMAND_ID_GARBAGECOLLECTION_GET);
        controlInfo.setStartTime(startTime);
        controlInfo.setEndTime(endTime);
        commnadInfo.setGarbageCollectionControlInfo(controlInfo);

        commnadInfo.setCode(
            CommandMappingTableResource.GARBAGECOLLECTION_COMMAND_ID);

        responseControlInfo =
            (GarbageCollectionControl) this.communicationToEngine(commnadInfo);

        return responseControlInfo;
    }
}
