/*
 * Created on 2004/08/08
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.upload.model;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import netjfwatcher.export.model.NodeInformationXMLTag;
import netjfwatcher.library.DataDisplay;

import org.apache.struts.upload.FormFile;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;


/**
 * m[hꊇo^s߂̃\bhNXłB
 *
 * NCAgAbv[hꂽXMLt@C͂ăm[ḧꊇo^s܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeRegisterUploadModel {
    /*
     * m[hĎzɊi[邽߂̔z̃|WV
     */

    /** m[hʒu */
    public static final int NODENAME_NUMBER = 0;

    /** m[hIPAhXʒu */
    public static final int IPADDRESS_NUMBER = 1;

    /** m[hO[vʒu */
    public static final int GROUP_NUMBER = 2;

    /** GWAhXʒu */
    public static final int ENGINE_ADDRESS_NUMBER = 3;

    /** m[hIcon XWʒu */
    public static final int NODE_X_NUMBER = 4;

    /** m[hIcon YWʒu */
    public static final int NODE_Y_NUMBER = 5;

    /** m[hʈʒu */
    public static final int NODEKIND_NUMBER = 6;

    /** PingĎʒu */
    public static final int PING_PERIOD_NUMBER = 7;

    /** PingĎ臒lʒu */
    public static final int PING_THRESHHOLD_NUMBER = 8;

    /** SNMPĎo[Wʒu */
    public static final int SNMP_VERSION_NUMBER = 9;

    /** SNMPĎxʒu */
    public static final int SNMP_LEVEL_NUMBER = 10;

    /** SNMPĎʒu */
    public static final int SNMP_PERIOD_NUMBER = 11;

    /** SNMP ReadR~jeBʒu */
    public static final int SNMP_ROCOMMUNITY_NUMBER = 12;

    /** SNMP Read/WriteR~jeBʒu */
    public static final int SNMP_RWCOMMUNITY_NUMBER = 13;

    /** SNMP^CAEglʒu */
    public static final int SNMP_TIMEOUT_NUMBER = 14;

    /** HTTPĎʒu */
    public static final int HTTP_PERIOD_NUMBER = 15;

    /** HTTPĎURLʒu */
    public static final int HTTP_URL_NUMBER = 16;

    /** HTTPĎ^CAEglʒu */
    public static final int HTTP_TIMEOUT_NUMBER = 17;

    /** Pop3Ďʒu */
    public static final int POP_PERIOD_NUMBER = 18;

    /** Pop3Ď[Uʒu */
    public static final int POP_USER_NUMBER = 19;

    /** Pop3ĎpX[hʒu */
    public static final int POP_PASSWORD_NUMBER = 20;

    /** Pop3Ď|[gʒu */
    public static final int POP_PORT_NUMBER = 21;

    /** Pop3Ď^CAEglʒu */
    public static final int POP_TIMEOUT_NUMBER = 22;

    /** SMTPĎʒu */
    public static final int SMTP_PERIOD_NUMBER = 23;

    /** SMTPĎ|[gʒu */
    public static final int SMTP_PORT_NUMBER = 24;

    /** SMTPĎ^CAEglʒu */
    public static final int SMTP_TIMEOUT_NUMBER = 25;

    /** SMTPĎMAhXʒu */
    public static final int SMTP_SEND_ADDRESS_NUMBER = 26;

    /** SMTPĎ`FbNPop3zXgʒu */
    public static final int SMTP_CHECK_POP_HOST_NUMBER = 27;

    /** SMTPĎ`FbNPop3[Uʒu */
    public static final int SMTP_CHECK_POP_USER_NUMBER = 28;

    /** SMTPĎ`FbNPop3zXgpX[hʒu */
    public static final int SMTP_CHECK_POP_PASSWORD_NUMBER = 29;

    /** SMTPĎ`FbNPop3zXg|[gʒu */
    public static final int SMTP_CHECK_POP_PORT_NUMBER = 30;

    /** SMTPĎ`FbNPop3zXg^CAEglʒu */
    public static final int SMTP_CHECK_POP_TINEOUT_NUMBER = 31;

    /** m[hĎ^OiXMLt@CGNX|[g/C|[gpjLqz */
    private static final String[] NODE_INFO_DESCRIBE_ARRAY =
    {
        NodeInformationXMLTag.NODENAME, NodeInformationXMLTag.IPADDRESS,
        NodeInformationXMLTag.GROUP, NodeInformationXMLTag.ENGINE_ADDRESS,
        NodeInformationXMLTag.NODE_X, NodeInformationXMLTag.NODE_Y,
        NodeInformationXMLTag.NODEKIND, NodeInformationXMLTag.PING_PERIOD,
        NodeInformationXMLTag.PING_THRESHHOLD,
        NodeInformationXMLTag.SNMP_VERSION, NodeInformationXMLTag.SNMP_LEVEL,
        NodeInformationXMLTag.SNMP_PERIOD,
        NodeInformationXMLTag.SNMP_ROCOMMUNITY,
        NodeInformationXMLTag.SNMP_RWCOMMUNITY,
        NodeInformationXMLTag.SNMP_TIMEOUT, NodeInformationXMLTag.HTTP_PERIOD,
        NodeInformationXMLTag.HTTP_URL, NodeInformationXMLTag.HTTP_TIMEOUT,
        NodeInformationXMLTag.POP3_PERIOD, NodeInformationXMLTag.POP3_USER,
        NodeInformationXMLTag.POP3_PASSWORD, NodeInformationXMLTag.POP3_PORT,
        NodeInformationXMLTag.POP3_TIMEOUT, NodeInformationXMLTag.SMTP_PERIOD,
        NodeInformationXMLTag.SMTP_PORT, NodeInformationXMLTag.SMTP_TIMEOUT,
        NodeInformationXMLTag.SMTP_SEND_ADDRESS,
        NodeInformationXMLTag.SMTP_CHECK_POP3_HOST,
        NodeInformationXMLTag.SMTP_CHECK_POP3_USER,
        NodeInformationXMLTag.SMTP_CHECK_POP3_PASSWORD,
        NodeInformationXMLTag.SMTP_CHECK_POP3_PORT,
        NodeInformationXMLTag.SMTP_CHECK_POP3_TIMEOUT
    };

    /** Uploadobt@TCY */
    public static final int BUFF_SIZE = 512 * 1000;

    /** o^m[hő吔 */
    public static final int NODE_MAX = 500;

    /** o^Nő吔 */
    public static final int NODE_LINK_MAX = 500;

    /* MO */
    private static Logger logger = null;

    /**
     * Abv[hꂽt@C񂩂m[ḧꊇo^s܂B
     *
     * @param file m[hꊇo^Abv[ht@C
     */
    public void upload(FormFile file) {
        logger = Logger.getLogger(this.getClass().getName());

        if (file.getFileSize() > BUFF_SIZE) {
            logger.warning("File size over !!: " + file.getFileSize());
        }

        InputStream stream = null;

        int bytesRead = 0;
        byte[] buffer = new byte[BUFF_SIZE];

        /* Abv[ht@Ce荞 */
        try {
            stream = file.getInputStream();

            while (true) {
                if ((bytesRead = stream.read(buffer, 0, BUFF_SIZE)) == -1) {
                    break;
                }
            }
        } catch (FileNotFoundException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            if (stream != null) {
                try {
                    stream.close();
                } catch (IOException e3) {
                    logger.warning(e3.getMessage());
                    e3.printStackTrace();
                }
            }
        }

        logger.info(
            "File content : "
            + DataDisplay.hexBytetoString(buffer, file.getFileSize()));

        InputStream in =
            new ByteArrayInputStream(buffer, 0, file.getFileSize());

        /* XMLt@C͗p */
        Document dom = null;
        DocumentBuilderFactory dbfactory = null;
        DocumentBuilder builder = null;

        /* XMLt@Ć@*/
        try {
            /* DOMp[Tpt@Ng̐ */
            dbfactory = DocumentBuilderFactory.newInstance();

            /* Ó؂s */
            dbfactory.setValidating(true);

            /* DOM DocumentCX^Xpt@Ng̐ */
            builder = dbfactory.newDocumentBuilder();

            /* G[nh̓o^ */
            builder.setErrorHandler(new DocumentParseErrorHandler());

            /* XMLt@C */
            dom = builder.parse(in);
        } catch (Exception e) {
            /* ȉ̗Ocatch
             * EDocumentBuilderŗO
             * iParserConfigurationExceptionj
             * EXMLt@C͂ō\̓G[iSAXExceptionj
             * EXMLt@C͂œo̓G[iIOExceptionj
             */
            logger.warning(e.getMessage());
        }

        if (dom != null) {
            Element root = dom.getDocumentElement();
            Node firstChildNode = root.getFirstChild();
            ArrayList nodeInfoList = null;
            ArrayList linkList = null;

            /* XMLt@C͂ăm[h擾
             */
            nodeInfoList = this.parseNode(firstChildNode);

            /*
             * XMLt@C͂ăN擾
             */
            linkList = this.parseLink(firstChildNode);

            /* m[hENi[pXbhNA󋵂NCAg֒ʒm */
            NodeRegisterQueue.getInstance().setNodeInfoList(nodeInfoList);
            NodeRegisterQueue.getInstance().setLinkList(linkList);

            ServerXMLSocketCommunicate.getInstance().startThread();
        }
    }

    /**
     * m[hXML͂āAm[h񃊃XgԂ܂B
     *
     * @param firstChildNode rootNode
     * @return m[hi[ArrayList
     */
    private ArrayList parseNode(final Node firstChildNode) {
        Node childNode = firstChildNode;

        // XMLNODE_INFO_ROOT_TAG = "Node"Fm[hĎ^O܂Ō
        while (childNode != null) {
            try {
                if (
                    (childNode != null)
                        && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                    if (
                        childNode.getNodeName().equals(
                                NodeInformationXMLTag.NODE_INFO_ROOT_TAG)) {
                        // XMLNODE_INFO_ROOT_TAG = "Node"Fm[hĎ^Obreak
                        childNode = childNode.getFirstChild();

                        break;
                    }
                }

                childNode = childNode.getNextSibling();
            } catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        ArrayList nodeList = new ArrayList();

        while (childNode != null) {
            try {
                /*
                System.out.println("getNodeName0 : " + childNode.getNodeName());
                System.out.println("getNodeType0 : " + childNode.getNodeType());
                System.out.println(
                    "getNodeValue0 : " + childNode.getNodeValue());
                                */
                /* X̃m[hĎ^ONODE_INFO_TAG = "Node_Property"o
                 * m[hĎ𒊏oĔzɊi[AzXgɒǉ
                 *
                 */
                if (
                    (childNode != null)
                        && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                    if (
                        childNode.getNodeName().equals(
                                NodeInformationXMLTag.NODE_INFO_TAG)) {
                        Node nodeInfoChildNodeLeaf = childNode.getFirstChild();

                        // Lȃm[hĎ񌟍tO
                        boolean hit = false;
                        String[] nodeInfo =
                            new String[NODE_INFO_DESCRIBE_ARRAY.length];

                        while (nodeInfoChildNodeLeaf != null) {
                            /*
                            System.out.println(
                            "getNodeName1 : "
                            + nodeInfoChildNodeLeaf.getNodeName());
                            System.out.println(
                            "getNodeType1 : "
                            + nodeInfoChildNodeLeaf.getNodeType());
                            System.out.println(
                            "getNodeValue1 : "
                            + nodeInfoChildNodeLeaf.getNodeValue());
                            */
                            if (
                                nodeInfoChildNodeLeaf.getNodeType() == Node.ELEMENT_NODE) {
                                // Node TypeElementł΁ANodeĎ񑮐ƈv邩`FbN
                                for (
                                    int i = 0;
                                        i < NODE_INFO_DESCRIBE_ARRAY.length;
                                        i++) {
                                    // NodeĎ񑮐ƈvAElement TypełΒlzɊi[
                                    if (
                                        nodeInfoChildNodeLeaf.getNodeName()
                                                                 .equals(
                                                NODE_INFO_DESCRIBE_ARRAY[i])) {
                                        Node firstNodeText = null;
                                        String leafItemValue = null;

                                        if (nodeInfoChildNodeLeaf != null) {
                                            firstNodeText =
                                                nodeInfoChildNodeLeaf
                                                .getFirstChild();

                                            if (firstNodeText != null) {
                                                leafItemValue =
                                                    firstNodeText.getNodeValue();
                                            }
                                        }

                                        // id=m[h̘AԁAi=m[hĎԍ
                                        nodeInfo[i] = leafItemValue;
                                        hit = true;

                                        break;
                                    }
                                }
                            }

                            nodeInfoChildNodeLeaf =
                                nodeInfoChildNodeLeaf.getNextSibling();
                        }

                        if (hit) {
                            nodeList.add(nodeInfo);
                        }
                    }

                    childNode = childNode.getNextSibling();
                }

                childNode = childNode.getNextSibling();
            } catch (DOMException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        // o^m[hIPAhXo

        /*
        for (int j = 0; j < nodeList.size(); j++) {
            for (int l = 0; l < NODE_INFO_DESCRIBE_ARRAY.length; l++) {
                System.out.println(
                    j + " : " + NODE_INFO_DESCRIBE_ARRAY[l] + " : "
                    + ((String[]) nodeList.get(j))[l]);
            }
        }
                */
        return nodeList;
    }

    /**
     * NXML͂ăXgƂĕԂ܂B
     *
     * @param firstChildNode rootNode
     * @return Ni[ArrayList
     */
    private ArrayList parseLink(final Node firstChildNode) {
        ArrayList linkList = new ArrayList();

        String[] nodeLinkInfo = null;
        Node childNode = firstChildNode;

        while (childNode != null) {
            /*
            System.out.println("getNodeName : " + childNode.getNodeName());
            System.out.println("getNodeType : " + childNode.getNodeType());
            System.out.println("getNodeValue : " + childNode.getNodeValue());
                    */
            if (
                (childNode != null)
                    && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                // m[hN^O
                if (
                    childNode.getNodeName().equals(
                            NodeInformationXMLTag.LIN_INFO_ROOT_TAG)) {
                    childNode = childNode.getFirstChild();

                    break;
                }
            }

            childNode = childNode.getNextSibling();
        }

        while (childNode != null) {
            /*
            System.out.println("getNodeName0 : " + childNode.getNodeName());
            System.out.println("getNodeType0 : " + childNode.getNodeType());
            System.out.println("getNodeValue0 : " + childNode.getNodeValue());
            */

            // Node Info TAG
            if (
                (childNode != null)
                    && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                if (
                    childNode.getNodeName().equals(
                            NodeInformationXMLTag.LIN_INFO_TAG)) {
                    Node nodeInfoChildNodeLeaf = childNode.getFirstChild();

                    boolean hit = false;
                    nodeLinkInfo = new String[2];

                    while (nodeInfoChildNodeLeaf != null) {
                        /*
                        System.out.println(
                            "getNodeName2 : "
                            + nodeInfoChildNodeLeaf.getNodeName());
                        System.out.println(
                            "getNodeType2 : "
                            + nodeInfoChildNodeLeaf.getNodeType());
                        System.out.println(
                            "getNodeValue2 : "
                            + nodeInfoChildNodeLeaf.getNodeValue());
                        */
                        if (
                            nodeInfoChildNodeLeaf.getNodeType() == Node.ELEMENT_NODE) {
                            // Node TypeElementł΁ANodeNLqƈv邩`FbN
                            if (
                                nodeInfoChildNodeLeaf.getNodeName().equals(
                                        NodeInformationXMLTag.LINK_X)) {
                                // NodeNLqƈvAElement TypełΒlzɊi[
                                Node firstNodeText =
                                    nodeInfoChildNodeLeaf.getFirstChild();
                                String leafItemValue =
                                    firstNodeText.getNodeValue();
                                nodeLinkInfo[0] = leafItemValue;
                                hit = true;

                                /* System.out.println(
                                    "Link Node X : " + leafItemValue);
                                */
                            }

                            if (
                                nodeInfoChildNodeLeaf.getNodeName().equals(
                                        NodeInformationXMLTag.LINK_Y)) {
                                // NodeNLqƈvAElement TypełΒlzɊi[
                                Node firstNodeText =
                                    nodeInfoChildNodeLeaf.getFirstChild();
                                String leafItemValue =
                                    firstNodeText.getNodeValue();
                                nodeLinkInfo[1] = leafItemValue;
                                hit = true;

                                /* System.out.println(
                                    "Link Node Y : " + leafItemValue);
                                 */
                            }
                        }

                        nodeInfoChildNodeLeaf =
                            nodeInfoChildNodeLeaf.getNextSibling();
                    }

                    if (hit) {
                        linkList.add(nodeLinkInfo);
                    }
                }

                childNode = childNode.getNextSibling();
            }

            childNode = childNode.getNextSibling();
        }

        // o^m[hIPAhXo

        /* for (int j = 0; j < linkList.size(); j++) {
            for (int l = 0; l < 2; l++) {
                System.out.println(
                    j + " : Link " + " : " + ((String[]) linkList.get(j))[l]);
            }
        } */
        return linkList;
    }
}
