/*
 * Created on 2004/07/17
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.statisticsmib.action;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.noderegister.model.NodeRegisterModel;
import netjfwatcher.preference.Preference;
import netjfwatcher.statisticsmib.model.StatisticsSetModel;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * SNMPvMIB̎ɂāAOID̈ȉ̏̕ҏW܂́A~sANVNXłB
 * E̎
 * EĎ^Cv
 * E臒l
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class StatisticsMibEditAction extends Action {
    private static Logger logger = null;

    public StatisticsMibEditAction() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not engine address : " + engineAddress);
        }

        String mode = request.getParameter(Preference.SNMP_STATISTICS_MODE);
        String ipaddress =
            request.getParameter(Preference.SNMP_STATISTICS_TARGET_IPADDRESS);
        String targetCommunity =
            request.getParameter(Preference.SNMP_READ_COMMUNITY);
        String readOid = request.getParameter(Preference.SNMP_STATISTICS_READ_OID);
        String readPeriod =
            request.getParameter(Preference.SNMP_STATISTICS_READ_PERIOD);
        String readThresholdtype =
            request.getParameter(Preference.SNMP_STATISTICS_READ_THRESHOLD_TYPE);
        String readThreshold =
            request.getParameter(Preference.SNMP_STATISTICS_READ_THRESHOLD);

        /*
         * wm[hIPAhXSNMP Community擾
         */
        NodeRegisterModel nodeinfo = new NodeRegisterModel();
        NodeInformation nodeInfo =
            nodeinfo.getIPTarget(engineAddress, ipaddress);
        String community = "";

        if (nodeInfo != null) {
            community = nodeInfo.getRoCommunity();
        }

        /*
         * vMIB̎̕ҏW܂́AZbg
         */
        StatisticsSetModel statisset = new StatisticsSetModel();

        if (mode.equals("Edit")) {
            /* ҏW */
            statisset.editStatisticsMibInfo(
                engineAddress, ipaddress, targetCommunity, readOid, readPeriod,
                readThreshold, readThresholdtype);
        } else if (mode.equals("Delete")) {
            /* 폜 */
            statisset.deleteStatisticsMibInfo(
                engineAddress, ipaddress, targetCommunity, readOid, readPeriod,
                readThreshold, readThresholdtype);
        }

        /* ҏWʂǂݍ݃NCAg֕Ԃ */
        ArrayList statisticsList = statisset.getStatisticsMibInfoList(engineAddress, ipaddress);

        request.setAttribute(
            Preference.SNMP_STATISTICS_MIBSET_LIST, statisticsList);
        request.setAttribute(
            Preference.SNMP_STATISTICS_TARGET_IPADDRESS, ipaddress);
        request.setAttribute(Preference.SNMP_READ_COMMUNITY, community);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String frameNameforServername = servernamework2.replace('-', '_');
        String convIPAddress = ipaddress.replace('.', '_');

        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(
            Preference.FRAME_NAME_AT_SERVER_NAME, frameNameforServername);

        return mapping.findForward(Preference.SUCCESS);
    }
}
