/*
 * Created on 2004/06/29
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodeview.gpaph;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[hView Window\ɂāAm[hIPAhXԂANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeViewStatisticsMibGraphPreAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String nodeIPAddress = request.getParameter(Preference.IPADDRESS);

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);
        String mode = request.getParameter(Preference.SNMP_STATISTICS_MODE);

        if (engineAddress == null) {
            engineAddress = "localhost";
            logger.warning("Not engine address : " + engineAddress);
        }

        request.setAttribute(Preference.NODE_IPADDRESS, nodeIPAddress);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        String convIPAddress = nodeIPAddress.replace('.', '_');

        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);

        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);
        request.setAttribute(Preference.SNMP_STATISTICS_MODE, mode);

        return mapping.findForward(Preference.SUCCESS);
    }
}
