/*
 * Created on 2004/05/13
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.noderegister;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.maintenance.model.FlashResourceInformationModel;
import netjfwatcher.preference.Preference;
import netjfwatcher.resourceconfig.EngineResourceConfig;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[hǉpJSP(t[)ɊĎ̃ftHglԂ܂B
 *
 * @author Yoshimasa MatsumotoS
 * @version 1.0
 */
public class NodeAddViewAction extends Action {
    /**
     * ftHgm[hO[v
     */
    public static final String INITIAL_NODE_GROUP = "Default Group";

    /** ftHgPingĎ */
    public static final String INITIAL_NODE_PING_PERIOD = "0";

    /** ftHgPingĎ臒l */
    public static final String INITIAL_NODE_PING_THRESHOLD = "4000";

    /** ftHgSNMPĎ */
    public static final String INITIAL_NODE_SNMP_PERIOD = "0";

    /** ftHgHTTPĎ */
    public static final String INITIAL_NODE_HTTP_PERIOD = "0";

    /** ftHgSMTPĎ */
    public static final String INITIAL_NODE_SMTP_PERIOD = "0";

    /** ftHgPop3Ď */
    public static final String INITIAL_NODE_POP_PERIOD = "0";

    /** ftHgSNMPĎo[W */
    public static final String INITIAL_NODE_SNMP_VERSION = "SNMPV1";

    /** ftHgSNMP ReadR~jeB */
    public static final String INITIAL_NODE_SNMP_ROCOMMUNITY = "public";

    /** ftHgSNMP WriteR~jeB */
    public static final String INITIAL_NODE_SNMP_RWCOMMUNITY = "private";

    /** ftHgHTTPĎURL */
    public static final String INITIAL_NODE_HTTP_URL = "http://";

    /** ftHgHTTPĎ^CAEgl */
    public static final String INITIAL_NODE_HTTP_TIMEOUT = "180000";

    /** ftHgPop3Ď|[g */
    public static final String INITIAL_NODE_POP_PORT = "110";

    /** ftHgPop3Ď^CAEgl */
    public static final String INITIAL_NODE_POP_TIMEOUT = "120000";

    /** ftHgSMTPĎ|[g */
    public static final String INITIAL_NODE_SMTP_PORT = "25";

    /** ftHgSMTPĎ^CAEgl */
    public static final String INITIAL_NODE_SMTP_TIMEOUT = "120000";
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        /*
         * m[ho^̃ftHgf[^Zbg
         */
        NodeInformation nodeInformation = new NodeInformation();
        nodeInformation.setGroup(INITIAL_NODE_GROUP);
        nodeInformation.setPingPeriod(INITIAL_NODE_PING_PERIOD);
        nodeInformation.setPingThreshold(INITIAL_NODE_PING_THRESHOLD);
        nodeInformation.setSnmpVersion(INITIAL_NODE_SNMP_VERSION);
        nodeInformation.setSnmpLevel("0");
        nodeInformation.setSnmpPeriod(INITIAL_NODE_SNMP_PERIOD);
        nodeInformation.setRoCommunity(INITIAL_NODE_SNMP_ROCOMMUNITY);
        nodeInformation.setRwCommunity(INITIAL_NODE_SNMP_RWCOMMUNITY);
        nodeInformation.setHttpPeriod(INITIAL_NODE_HTTP_PERIOD);
        nodeInformation.setHttpUrl(INITIAL_NODE_HTTP_URL);
        nodeInformation.setHttpTimeout(INITIAL_NODE_HTTP_TIMEOUT);
        nodeInformation.setPopPeriod(INITIAL_NODE_POP_PERIOD);
        nodeInformation.setPopPort(INITIAL_NODE_POP_PORT);
        nodeInformation.setPopTimeout(INITIAL_NODE_POP_TIMEOUT);
        nodeInformation.setSmtpPeriod(INITIAL_NODE_SMTP_PERIOD);
        nodeInformation.setSmtpPort(INITIAL_NODE_SMTP_PORT);
        nodeInformation.setSmtpTimeout(INITIAL_NODE_SMTP_TIMEOUT);
        nodeInformation.setSmtpCheckPort(INITIAL_NODE_POP_PORT);
        nodeInformation.setSmtpCheckTimeout(INITIAL_NODE_POP_TIMEOUT);

        request.setAttribute(Preference.NODE_REGISTER_INFO, nodeInformation);

        /* m[hComb BoxpXg쐬 */
        FlashResourceInformationModel flashdata =
            new FlashResourceInformationModel();
        ArrayList workNodeKindList = flashdata.getIconLabelList();
        ArrayList nodeKindList = new ArrayList();
        NodeInformation nodeKind = null;

        for (int i = 0; workNodeKindList.size() > i; i++) {
            nodeKind = new NodeInformation();
            nodeKind.setNodeKind((String) workNodeKindList.get(i));
            nodeKindList.add(nodeKind);
        }

        /* uEU WindowpT[oZbg */
        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        /* reuestp[^Zbg */
        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.NODE_KIND_LIST, nodeKindList);

        ArrayList engineInfoList =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getEngineInfoList();
        request.setAttribute(Preference.ENGINE_INFO_LIST, engineInfoList);

        return mapping.findForward(Preference.SUCCESS);
    }
}
