/*
 * Created on 2004/11/04
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemap;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[hMap\t[ZbgANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeManagerMapFrame extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "localhost";
            logger.warning("Not engine address : " + engineAddress);
        }

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String frameNameforServername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);
        request.setAttribute(
            Preference.FRAME_NAME_AT_SERVER_NAME, frameNameforServername);

        return mapping.findForward(Preference.SUCCESS);
    }
}
