/*
 * Created on 2004/04/09
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.list;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.alarm.view.model.AlarmViewModel;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.nodemanager.list.model.NodeListSort;
import netjfwatcher.nodemanager.list.model.NodeListViewModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * Ďm[hXg\[gANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeInfoListViewSortAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "all";
        }

        String sortColumn = request.getParameter(Preference.SORT_COLUMN);
        String sortDirection = request.getParameter(Preference.SORT_DIRECTION);

        NodeListViewModel nodeListModel = new NodeListViewModel();

        ArrayList nodeList =
            nodeListModel.getList(engineAddress, sortColumn, sortDirection);

        ArrayList alarmList = null;
        AlarmInformation alarmInfo = null;

        for (int i = 0; i < nodeList.size(); ++i) {
            NodeInformation nodeInfo = (NodeInformation) nodeList.get(i);

            // logger.info("Node IP Address : " + nodeInfo.getConvIPAddress());
            AlarmViewModel alarmviewmodel =
                new AlarmViewModel(
                    nodeInfo.getIpaddress(), Preference.ALARM_TABLE_ID,
                    Preference.SORT_DIR_DESC);

            /* wm[h̍ŐVAlarm擾 */
            alarmList = alarmviewmodel.getAlarmList(engineAddress, 1, 0, 0);

            if (alarmList.size() > 0) {
                alarmInfo = (AlarmInformation) alarmList.get(0);
            }
        }

        /*
         * Client̃m[hList\[g𔽓]āAClientɕԑ
         */
        if (
            (sortDirection == null)
                || sortDirection.equals(NodeListSort.SORT_DIRECTION_ASC)) {
            sortDirection = NodeListSort.SORT_DIRECTION_DESC;
        } else {
            sortDirection = NodeListSort.SORT_DIRECTION_ASC;
        }

        request.setAttribute(Preference.SORT_DIRECTION, sortDirection);
        request.setAttribute(Preference.NODE_REGISTER_LIST, nodeList);
        request.setAttribute(
            Preference.NODE_REGISTER_COUNT, Integer.toString(nodeList.size()));

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);

        return mapping.findForward(Preference.SUCCESS);
    }
}
