/*
 * Created on 2004/05/14
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.model;

import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionDatabasePropertyGet;
import netjfwatcher.engine.socket.ConnectionDatabaseTest;
import netjfwatcher.engine.socket.ConnectionResourceGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.DatabasePropertyInfo;
import netjfwatcher.engine.socket.info.ResourceInfo;


/**
 *
 * EGWƂ̒ʐMŃ\[X擾
 * Ef[^x[XɉғĂ邩̃`FbN
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DatabaseTestModel {
    /* MO */
    private static Logger logger;

    /**
     *
     *
     */
    public DatabaseTestModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * f[^x[XvpeB擾܂B
     *
     * @param engineAddress GWAhX
     * @return databasePropInfo f[^x[XvpeB
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public DatabasePropertyInfo[] getDatabaseProp(String engineAddress)
        throws EngineConnectException, IOException {
        ConnectionDatabasePropertyGet databaseProp =
            new ConnectionDatabasePropertyGet(engineAddress);
        DatabasePropertyInfo[] databasePropInfo = databaseProp.getResource();

        for (int i = 0; i < databasePropInfo.length; i++) {
            System.out.println(
                "Database Name : " + databasePropInfo[i].getDatabaseName());
            System.out.println(
                "Database Driver : " + databasePropInfo[i].getDatabaseDriver());
            System.out.println(
                "Database Url : " + databasePropInfo[i].getDatabaseUrl());
            System.out.println(
                "Database User : " + databasePropInfo[i].getDatabaseUser());
            System.out.println(
                "Database Password : "
                + databasePropInfo[i].getDatabasePassword());
        }

        return databasePropInfo;
    }

    /**
     * f[^x[XғeXgGWɒʒm܂B
     *
     * @param engineAddress GWAhX
     * @param databaseName f[^x[X
     * @param databaseDriver f[^x[XhCo
     * @param databaseUrl f[^x[XURL
     * @param databaseUser f[^x[X[U
     * @param databasePassword f[^x[XpX[h
     * @return@result f[^x[XғeXg
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public String[] checkDatabase(
        String engineAddress, String databaseName, String databaseDriver,
        String databaseUrl, String databaseUser, String databasePassword)
        throws EngineConnectException, IOException {
        ConnectionDatabaseTest databaseTest =
            new ConnectionDatabaseTest(engineAddress);

        String[] result =
            databaseTest.checkDatabase(
                databaseName, databaseDriver, databaseUrl, databaseUser,
                databasePassword);

        return result;
    }

    /**
     * GWƂ̒ʐMŃ\[XMĂԂ܂B
     *
     * @param engineAddress GWAhX
     * @return resourceInfo \[X
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public ResourceInfo getResource(String engineAddress)
        throws EngineConnectException, IOException {
        ConnectionResourceGet resourceGet =
            new ConnectionResourceGet(engineAddress);
        ResourceInfo resourceInfo = resourceGet.getResource();

        return resourceInfo;
    }
}
