/*
 * Created on 2004/06/03
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.flashaction;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.MailProperty;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.maintenance.model.ResourceManagementModel;


/**
 * Flash̃\[X擾yэXVsT[ubgNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ResourceManagementControlAction extends HttpServlet {
    /* MO */
    private static Logger logger = null;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());


        String mode = request.getParameter("mode");

        if (mode.equals("load")) {
            try {
                this.loadResource(request, response);
            } catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        } else {
            try {
                this.updateResource(request, response);
            } catch (EngineConnectException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /*
     * \[X[hăNCAg(Flash)ɕԂ܂B
     *
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @throws IOException
     */
    private void loadResource(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, Exception {
        String engineAddress = request.getParameter("engineAddress");

        /* if (engineAddress == null) {
            logger.warning("Not server Address");
        } */

        // logger.info("Engine address : " + engineAddress);
        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        /* w̃GWAhX̃\[X擾 */
        ResourceManagementModel resourceModel = new ResourceManagementModel();
        ResourceInfo resourceInfo = resourceModel.getResource(engineAddress);

        /* \[X̃f[^x[XZbg */
        String databaseName = resourceInfo.getDatabaseName();
        String databaseDriver = resourceInfo.getDatabaseDriver();
        String databaseURL = resourceInfo.getDatabaseUrl();
        String databaseUser = resourceInfo.getDatabaseUser();
        String databasePassword = resourceInfo.getDatabasePassword();

        /* \[XPingĎZbg */
        String pingTimeout = resourceInfo.getPingTimeout();
        String pingRetry = resourceInfo.getPingRetry();

        /* \[XSnmpZbg */
        int snmpPort = resourceInfo.getSnmpPort();
        int snmpTrapPort = resourceInfo.getSnmpTrapPort();
        String snmpTimeout = resourceInfo.getSnmpV1Timeout();
        String snmpRetry = resourceInfo.getSnmpV1Retry();
        String snmp2Timeout = resourceInfo.getSnmpV2Timeout();
        String snmp2Retry = resourceInfo.getSnmpV2Retry();
        String snmp3Timeout = resourceInfo.getSnmpV3Timeout();
        String snmp3Retry = resourceInfo.getSnmpV3Retry();

        /* \[XXML Socket֘AZbg */
        String alertSound = resourceInfo.getAlertSound();
        String refreshTime = resourceInfo.getRefreshTime();
        String xmlSocketConnectAllowHost = resourceInfo.getXmlsocketAllowHost();
        String xmlPort = resourceInfo.getXmlSocketPort();
        String xmlMaxConnect = resourceInfo.getXmlSocketMaxConnect();
        String mailGuardTime = resourceInfo.getMailGuardTime();

        /* \[X̃A[/vێZbg */
        String alarmMaxLine = resourceInfo.getAlarmMax();
        String alarmHoldPeriod = resourceInfo.getAlarmHoldPeriodDay();
        String statisticsMaxLine = resourceInfo.getStatisticsMax();
        String statisticsHoldPeriod = resourceInfo.getStatisticsHoldPeriodDay();

        // SNMPV3 \
        Iterator it = null;
        Map list = resourceInfo.getSnmpV3ConfigMapList();

        String[] targetAddress = new String[list.size()];
        String[] userName = new String[list.size()];
        String[] authPriv = new String[list.size()];
        String[] authProtocol = new String[list.size()];
        String[] authPassPhrase = new String[list.size()];
        String[] privProtocol = new String[list.size()];
        String[] privPassPhrase = new String[list.size()];
        String[] contextName = new String[list.size()];
        String[] engineID = new String[list.size()];
        String[] engineBoots = new String[list.size()];
        String[] engineTime = new String[list.size()];

        int count = 0;

        /* SNMPV3 G[WFgǗXg擾 */
        for (it = list.keySet().iterator(); it.hasNext();) {
            String key = (String) it.next();
            SnmpV3ManagerConfigInfo info =
                (SnmpV3ManagerConfigInfo) list.get(key);

            if (info == null) {
                continue;
            }

            SnmpV3ManagerUserConfigInfo snmpV3UserInfo =
                (SnmpV3ManagerUserConfigInfo) info.getUserList().get(0);

            targetAddress[count] = info.getIpAddress();
            contextName[count] = info.getContextName();

            if (
                (info.getSnmpEngineID() != null)
                    && !info.getSnmpEngineID().equals("")) {
                engineID[count] = info.getSnmpEngineID();
            } else {
                engineID[count] = "--";
            }

            if (
                (info.getSnmpEngineBoots() != null)
                    && !info.getSnmpEngineBoots().equals("")) {
                engineBoots[count] = info.getSnmpEngineBoots();
            } else {
                engineBoots[count] = "--";
            }

            if (
                (info.getSnmpEngineTime() != null)
                    && !info.getSnmpEngineTime().equals("")) {
                long agentStartTime = Long.parseLong(info.getSnmpEngineTime());
                Date agentDate = null;
                agentDate = Calendar.getInstance().getTime();
                agentDate.setTime(agentStartTime);

                DateFormat dateformat =
                    new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

                // dateformat = DateFormat.getDateTimeInstance();
                engineTime[count] = dateformat.format(agentDate);
            } else {
                engineTime[count] = "--";
            }

            userName[count] = snmpV3UserInfo.getUsername();
            authPriv[count] = snmpV3UserInfo.getAuthPriv();
            authProtocol[count] = snmpV3UserInfo.getAuthProtocol();
            authPassPhrase[count] = snmpV3UserInfo.getAuthPassPhrase();
            privProtocol[count] = snmpV3UserInfo.getPrivProtocol();
            privPassPhrase[count] = snmpV3UserInfo.getPrivPassPhrase();

            count++;
        }

        /* \[XNCAg֑M */
        out.print("database_Name=" + databaseName);
        out.print("&database_Driver=" + databaseDriver);
        out.print("&database_URL=" + databaseURL);
        out.print("&database_User=" + databaseUser);
        out.print("&database_Password=" + databasePassword);
        out.print("&ping_Timeout=" + pingTimeout);
        out.print("&ping_Retry=" + pingRetry);

        out.print("&snmp_Port=" + snmpPort);
        out.print("&snmp_TrapPort=" + snmpTrapPort);

        out.print("&snmp_Timeout=" + snmpTimeout);
        out.print("&snmp_Retry=" + snmpRetry);
        out.print("&snmp2_Timeout=" + snmp2Timeout);
        out.print("&snmp2_Retry=" + snmp2Retry);
        out.print("&snmp3_Timeout=" + snmp3Timeout);
        out.print("&snmp3_Retry=" + snmp3Retry);
        out.print("&alert_Sound=" + alertSound);
        out.print("&refresh_time=" + refreshTime);
        out.print("&xmlSocketConnectAllowHost=" + xmlSocketConnectAllowHost);
        out.print("&xml_Port=" + xmlPort);
        out.print("&xml_MaxConnect=" + xmlMaxConnect);
        out.print("&mail_guard_time=" + mailGuardTime);
        out.print("&alarm_Max_Line=" + alarmMaxLine);
        out.print("&alarm_Hold_Period=" + alarmHoldPeriod);
        out.print("&statistics_Max_Line=" + statisticsMaxLine);
        out.print("&statistics_Hold_Period=" + statisticsHoldPeriod);

        out.print("&snmpV3Counter=" + list.size());

        for (int i = 0; list.size() > i; i++) {
            out.print("&targetAddress" + i + "=" + targetAddress[i]);
            out.print("&userName" + i + "=" + userName[i]);
            out.print("&authPriv" + i + "=" + authPriv[i]);
            out.print("&authProtocol" + i + "=" + authProtocol[i]);
            out.print("&authPassPhrase" + i + "=" + authPassPhrase[i]);
            out.print("&privProtocol" + i + "=" + privProtocol[i]);
            out.print("&privPassPhrase" + i + "=" + privPassPhrase[i]);
            out.print("&contextName" + i + "=" + contextName[i]);
            out.print("&engineID" + i + "=" + engineID[i]);
            out.print("&engineBoots" + i + "=" + engineBoots[i]);
            out.print("&engineTime" + i + "=" + engineTime[i]);
        }
    }

    /*
     * \[XXV܂B
     *
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @throws IOException
     */
    private void updateResource(
        HttpServletRequest request, HttpServletResponse response)
        throws EngineConnectException, IOException {
        String engineAddress = request.getParameter("engineAddress");

        if (engineAddress == null) {
            logger.warning("Not server Address");
        }

        logger.info("Engine address : " + engineAddress);

        /* NCAg̃f[^x[X֘A𒊏o */
        String postDatabaseName = request.getParameter("DatabaseName");
        String postDatabaseDriver = request.getParameter("Database_Driver");
        String postDatabaseURL = request.getParameter("Database_URL");
        String postDatabaseUser = request.getParameter("Database_User");
        String postDatabasePassword = request.getParameter("Database_Password");
        String postPingTimeout = request.getParameter("ping_Timeout");
        String postPingRetry = request.getParameter("ping_Retry");

        /* NCAgSnmp֘A𒊏o */
        String postSnmpPort = request.getParameter("snmp_Port");
        String postSnmpTrapPort = request.getParameter("snmp_TrapPort");
        String postSnmpTimeout = request.getParameter("snmp_Timeout");
        String postSnmpRetry = request.getParameter("snmp_Retry");
        String snmp2Timeout = request.getParameter("snmp2_Timeout");
        String snmp2Retry = request.getParameter("snmp2_Retry");
        String snmp3Timeout = request.getParameter("snmp3_Timeout");
        String snmp3Retry = request.getParameter("snmp3_Retry");

        /* NCAgSnmpV3G[WFgǗ𒊏o */
        String snmpV3AgentItemLength =
            request.getParameter("snmpV3AgentItemLength");
        String postSnmpV3Address = request.getParameter("snmpV3AgentAddress");
        String postSnmpV3AddressIndex =
            request.getParameter("snmpV3AgentAddressIndex");
        String postSnmpV3UserName = request.getParameter("snmpV3AgentUserName");
        String postSnmpV3AuthPriv = request.getParameter("snmpV3AgentAuthPriv");
        String postSnmpV3AuthProtocol =
            request.getParameter("snmpV3AgentAuthProtocol");
        String postSnmpV3AuthPassPhrase =
            request.getParameter("snmpV3AgentAuthPassPhrase");
        String postSnmpV3PrivProtocol =
            request.getParameter("snmpV3AgentPrivProtocol");
        String postSnmpV3PrivPassPhrase =
            request.getParameter("snmpV3AgentPrivPassPhrase");
        String postSnmpV3AgentContextName =
            request.getParameter("snmpV3AgentContextName");

        /* NCAgXML Socket֘A𒊏o */
        String postAlertSound = request.getParameter("alert_Sound");
        String postRefreshTime = request.getParameter("refresh_time");

        String postSmtpHost = request.getParameter("smtp_Host");
        String postSmtpValid = request.getParameter("smtp_Valid");
        String postMailFrom = request.getParameter("MailFrom");
        String postMailToCount = request.getParameter("mail_ToCount");
        String postMailTo = request.getParameter("MailTo");

        String postXmlAllowHost = request.getParameter("xml_allowHost");
        String postXmlPort = request.getParameter("xml_Port");
        String postXmlMaxConnect = request.getParameter("xml_MaxConnect");
        String postMailGuardTime = request.getParameter("mail_guard_time");

        /* NCAg̃A[/vێ֘A𒊏o */
        String postAlarmMaxLine = request.getParameter("alarm_MaxLine");
        String postAlarmHoldPeriod = request.getParameter("alarm_Holdperiod");
        String postStatisticsMaxLine =
            request.getParameter("statistics_MaxLine");
        String postStatisticsHoldPeriod =
            request.getParameter("statistics_Holdperiod");

        String databaseName = postDatabaseName;
        String databaseDriver = postDatabaseDriver;
        String databaseURL = postDatabaseURL;
        String databaseUser = postDatabaseUser;
        String databasePassword = postDatabasePassword;
        String pingTimeout = postPingTimeout;
        String pingRetry = postPingRetry;
        String snmpTimeout = postSnmpTimeout;
        String snmpRetry = postSnmpRetry;
        String alertSound = postAlertSound;
        String refreshTime = postRefreshTime;

        String xmlAllowHost = postXmlAllowHost;
        String xmlPort = postXmlPort;
        String xmlMaxConnect = postXmlMaxConnect;
        String mailGuardTime = postMailGuardTime;
        String alarmMaxLine = postAlarmMaxLine;
        String alarmHoldPeriod = postAlarmHoldPeriod;
        String statisticsMaxLine = postStatisticsMaxLine;
        String statisticsHoldPeriod = postStatisticsHoldPeriod;

        String[] snmpV3Address;
        String[] snmpV3AddressIndex;
        String[] snmpV3UserName;
        String[] snmpV3AuthPriv;
        String[] snmpV3AuthProtocol;
        String[] snmpV3AuthPassPhrase;
        String[] snmpV3PrivProtocol;
        String[] snmpV3PrivPassPhrase;
        String[] snmpV3ContextName;

        String[] smtpHost;
        String[] smtpValid;
        String[] mailFrom;
        String[] mailToCount;
        String[] mailTo;

        // 𕪊Pattern
        Pattern pattern = null;

        // tB[hɃtB[h؂ŕ
        try {
            pattern = Pattern.compile(",");
        } catch (PatternSyntaxException e) {
            logger.warning("Error compiling expression : " + e.getMessage());

            return;
        }

        /*
         * Postf[^spiltŐݒ肳ĂȂf[^܂߂z̒ɂ邽Client Falsh
         * z񒷂擾Aspilt limitƂ
         */
        int limit = Integer.parseInt(snmpV3AgentItemLength);
        snmpV3Address = pattern.split(postSnmpV3Address);
        snmpV3AddressIndex = pattern.split(postSnmpV3AddressIndex);
        snmpV3UserName = pattern.split(postSnmpV3UserName, limit);
        snmpV3AuthPriv = pattern.split(postSnmpV3AuthPriv, limit);
        snmpV3AuthProtocol = pattern.split(postSnmpV3AuthProtocol, limit);
        snmpV3AuthPassPhrase = pattern.split(postSnmpV3AuthPassPhrase, limit);
        snmpV3PrivProtocol = pattern.split(postSnmpV3PrivProtocol, limit);
        snmpV3PrivPassPhrase = pattern.split(postSnmpV3PrivPassPhrase, limit);
        snmpV3ContextName = pattern.split(postSnmpV3AgentContextName, limit);

        ArrayList snmpV3ResourceList = new ArrayList();

        for (int i = 0; snmpV3AddressIndex.length > i; i++) {
            /*
             * NCAgSNMPV3̂L݂̏̂i[
             * snmpV3AddressIndex̔zɊi[ꂽIndexԍL
             */
            int validIndex = Integer.parseInt(snmpV3AddressIndex[i]);

            SnmpV3ManagerConfigInfo snmpV3ManagerInfo =
                new SnmpV3ManagerConfigInfo();
            SnmpV3ManagerUserConfigInfo userInfo =
                new SnmpV3ManagerUserConfigInfo();

            /* for (int j = 0; snmpV3UserName.length > j; j++) {
                if (snmpV3UserName[j] == null) {
                    System.out.print("snmpV3UserName[validIndex] null " + j);
                }

                System.out.println("snmpV3UserName j :" + j);
                System.out.println("snmpV3UserName[j] :" + snmpV3UserName[j]);
                System.out.println(
                    "snmpV3PrivProtocol.length :" + snmpV3PrivProtocol.length);

                try {
                    System.out.println(
                        "snmpV3PrivProtocol[j] :" + snmpV3PrivProtocol[j]);
                } catch (RuntimeException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            } */

            userInfo.setUsername(snmpV3UserName[validIndex]);
            userInfo.setAuthPriv(snmpV3AuthPriv[validIndex]);
            userInfo.setAuthProtocol(snmpV3AuthProtocol[validIndex]);
            userInfo.setAuthPassPhrase(snmpV3AuthPassPhrase[validIndex]);
            userInfo.setPrivProtocol(snmpV3PrivProtocol[validIndex]);
            userInfo.setPrivPassPhrase(snmpV3PrivPassPhrase[validIndex]);
            snmpV3ManagerInfo.addUserList(userInfo);
            snmpV3ManagerInfo.setIpAddress(snmpV3Address[i]);
            snmpV3ManagerInfo.setContextName(snmpV3ContextName[validIndex]);
            snmpV3ResourceList.add(snmpV3ManagerInfo);
        }

        smtpHost = pattern.split(postSmtpHost);
        smtpValid = pattern.split(postSmtpValid);
        mailFrom = pattern.split(postMailFrom);
        mailToCount = pattern.split(postMailToCount);
        mailTo = pattern.split(postMailTo);

        MailProperty[] mailProp = new MailProperty[smtpHost.length];

        int mailToOffset = 0;

        for (int i = 0; i < smtpHost.length; i++) {
            if (i != 0) {
                mailToOffset = Integer.parseInt(mailToCount[i - 1]);
            }

            mailProp[i] = new MailProperty();

            mailProp[i].setSmtpHost(smtpHost[i]);
            mailProp[i].setMailSendFlag(smtpValid[i]);
            mailProp[i].setFrom(mailFrom[i]);

            int toCount = Integer.parseInt(mailToCount[i]);
            String[] toList = new String[toCount];

            for (int j = 0; j < toCount; j++) {
                toList[j] = mailTo[mailToOffset + j];
            }

            mailProp[i].setTo(toList);
        }

        /*
         * \[Xi[CX^X𐶐AeZbg
         */
        ResourceInfo resourceInfo = new ResourceInfo();

        // f[^x[X
        resourceInfo.setDatabaseName(databaseName);
        resourceInfo.setDatabaseDriver(databaseDriver);
        resourceInfo.setDatabaseUrl(databaseURL);
        resourceInfo.setDatabaseUser(databaseUser);
        resourceInfo.setDatabasePassword(databasePassword);

        // SNMP
        resourceInfo.setSnmpPort(Integer.parseInt(postSnmpPort));
        resourceInfo.setSnmpTrapPort(Integer.parseInt(postSnmpTrapPort));

        resourceInfo.setSnmpV1Timeout(snmpTimeout);
        resourceInfo.setSnmpV2Timeout(snmp2Timeout);
        resourceInfo.setSnmpV3Timeout(snmp3Timeout);
        resourceInfo.setSnmpV1Retry(snmpRetry);
        resourceInfo.setSnmpV2Retry(snmp2Retry);
        resourceInfo.setSnmpV3Retry(snmp3Retry);
        resourceInfo.setSnmpV3ConfigList(snmpV3ResourceList);

        // Ping
        resourceInfo.setPingTimeout(pingTimeout);
        resourceInfo.setPingRetry(pingRetry);

        // Xml Socket
        resourceInfo.setAlertSound(alertSound);
        resourceInfo.setRefreshTime(refreshTime);
        resourceInfo.setXmlsocketAllowHost(xmlAllowHost);
        resourceInfo.setXmlSocketPort(xmlPort);
        resourceInfo.setXmlSocketMaxConnect(xmlMaxConnect);
        resourceInfo.setMailGuardTime(mailGuardTime);
        resourceInfo.setAlarmMax(alarmMaxLine);
        resourceInfo.setAlarmHoldPeriodDay(alarmHoldPeriod);
        resourceInfo.setStatisticsMax(statisticsMaxLine);
        resourceInfo.setStatisticsHoldPeriodDay(statisticsHoldPeriod);

        // Alert Mail
        resourceInfo.setMailPropertyList(mailProp);

        // GWւ̃\[XXVCX^X
        ResourceManagementModel nodeedit = new ResourceManagementModel();

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        try {
            nodeedit.updateResource(engineAddress, resourceInfo);
            out.print("result=" + "Save Complte");
        } catch (EngineConnectException e1) {
            logger.warning(e1.getMessage());
            out.print("result=" + e1.getMessage());
            e1.printStackTrace();
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            out.print("result=" + e1.getMessage());
            e1.printStackTrace();
        } catch (Exception e1) {
            logger.warning(e1.getMessage());
            out.print("result=" + e1.getMessage());
            e1.printStackTrace();
        }
    }
}
