/*
 * Created on 2004/06/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.flashaction;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.maintenance.model.MailSendTestModel;


/**
 * MailMeXgsʂԂT[ubgNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MailSendTestAction extends HttpServlet {
    private static Logger logger = null;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter("engineAddress");

        if (engineAddress == null) {
            logger.warning("Not server Address");
        }

        String smtpHost = request.getParameter("SMTPHost");
        String mailTo = request.getParameter("MailTo");
        String mailFrom = request.getParameter("MailFrom");
        String mailSubject = request.getParameter("MailSubject");
        String mailMessageBody = request.getParameter("MailBody");

        String result = "";
        MailSendTestModel mailSendtestModel = new MailSendTestModel();

        try {
            result =
                mailSendtestModel.executeMailSend(
                    engineAddress, smtpHost, mailFrom, mailTo, mailSubject,
                    mailMessageBody);
        } catch (EngineConnectException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        out.print("testResult" + "=" + result);

        // System.out.println("testResult" + "=" + result);
    }
}
