/*
 * Created on 2003/07/28
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.graph.model;

import java.io.IOException;

import netjfwatcher.engine.socket.ConnectionStatisticsMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;


/**
 * vMIBf[^GW̎悷NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class StatisticsMibGraphModel {
    /**
     * vMIB̎f[^̎wOIDCX^XɂāAwEԓ̃f[^
     * GW擾ĕԂ܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hAhX
     * @param oid@OID
     * @param instance OIDCX^X
     * @param startTime f[^擾Jn
     * @param endTime f[^擾I
     * @return mibProperty
     * @throws EngineConnectException GWƂ̐ڑɈُ킪ꍇ
     * @throws IOException GWƂ̐ڑɈُ킪ꍇ
     */
    public StatisticsMibProperty getList(
        String engineAddress, String ipaddress, String oid, String instance,
        String startTime, String endTime)
        throws EngineConnectException, IOException {
        /* GWƒʐM邽߂ɁAvMIBOIDCX^XAWԂȂǂ̐CX^XZbg */
        StatisticsMibControl statisticsMibControl = new StatisticsMibControl();
        statisticsMibControl.setSubCommand(
            StatisticsMibControl.STATISTICS_DATA_GET);
        statisticsMibControl.setIpaddress(ipaddress);
        statisticsMibControl.setOid(oid);
        statisticsMibControl.setOidInstance(instance);
        statisticsMibControl.setPeriodStartDate(startTime);
        statisticsMibControl.setPeriodEndDate(endTime);

        /* GWƒʐMAf[^擾 */
        ConnectionStatisticsMibGet statisticsMibGet =
            new ConnectionStatisticsMibGet(engineAddress);
        StatisticsMibProperty mibProperty =
            statisticsMibGet.getStatisticsMib(statisticsMibControl);

        return mibProperty;
    }
}
