/*
 * Created on 2003/08/19
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.graph.model;

import java.io.IOException;
import java.util.ArrayList;

import netjfwatcher.engine.socket.ConnectionStatisticsMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;


/**
 *@vMIB̎ɂāAOIDC^tF[Xn̏ꍇifDesc擾
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeStatisticsMibGetStateModel {
    /**
     *
     *
     * @param engineAddress GWAddress
     * @param ipaddress m[hIP Address
     * @return
     * @throws EngineConnectException GWƂ̐ڑɈُ킪ꍇ
     * @throws IOException GWƂ̐ڑɈُ킪ꍇ
     */
    public StatisticsMibProperty getIfDescList(
        String engineAddress, String ipaddress)
        throws EngineConnectException, IOException {
        /*
         * vMIB̎ɂāAOIDC^tF[Xn̏ꍇifDesc擾
         * 邽߂̃CX^XZbg
         */
        StatisticsMibControl control = new StatisticsMibControl();
        control.setSubCommand(StatisticsMibControl.IF_DESCRIPTOR_GET);
        control.setIpaddress(ipaddress);

        /*  */
        ConnectionStatisticsMibGet statisticsMibGet =
            new ConnectionStatisticsMibGet(engineAddress);
        StatisticsMibProperty mibproperty =
            statisticsMibGet.getStatisticsMib(control);
        ArrayList list = mibproperty.getMibIfDescriptorList();

        return mibproperty;
    }
}
