/*
 * Created on 2003/08/19
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.graph.action;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.graph.model.NodeStatisticsMibGetStateModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * vMIBOt\ɂāAvMIBOIDCX^X\邽߂
 * ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeStatisticsMibGetStateAction extends Action {
    /** ifInOctets 1.3.6.1.2.1.2.2.1.10 if:MINebg OID */
    public static final String IF_IN_OCTETS_OID = "1.3.6.1.2.1.2.2.1.10";

    /** ifOutOctets 1.3.6.1.2.1.2.2.1.16 if:MINebg OID */
    public static final String IF_OUT_OCTETS_OID = "1.3.6.1.2.1.2.2.1.16";

    /** laLoad OID */
    public static final String LA_LOAD_OID = "1.3.6.1.4.1.2021.10.1.3";

    /** laLoad (ߋ1Ԃ̕ϕ) OID */
    public static final String LA_LOAD_1_OID = "1.3.6.1.4.1.2021.10.1.3.1";

    /** laLoad (ߋ5Ԃ̕ϕ) OID */
    public static final String LA_LOAD_5_OID = "1.3.6.1.4.1.2021.10.1.3.2";

    /** laLoad (ߋ15Ԃ̕ϕ) OID */
    public static final String LA_LOAD_15_OID = "1.3.6.1.4.1.2021.10.1.3.3";

    /** laLoadInt (percent) OID */
    public static final String LA_LOAD_INT_OID = "1.3.6.1.4.1.2021.10.1.5";

    /** laLoadFloat (percent) OID */
    public static final String LA_LOAD_FLOAT_OID = "1.3.6.1.4.1.2021.10.1.6";

    /** dskTotal (fBXNe(kbyte)) OID */
    public static final String DSK_TOTAL_OID = "1.3.6.1.4.1.2021.9.1.6";

    /** dskAvail (fBXN󂫗e(kbyte)) OID */
    public static final String DSK_AVAIL_OID = "1.3.6.1.4.1.2021.9.1.7";

    /** dskUsed (fBXNgp(kbyte)) OID */
    public static final String DSK_USED_OID = "1.3.6.1.4.1.2021.9.1.8";

    /** dskPercent (fBXNe(percent)) OID */
    public static final String DSK_PERCENT_OID = "1.3.6.1.4.1.2021.9.1.9";

    /** dskPercentNode (percent) OID */
    public static final String DSK_PERCENT_NODE_OID = "1.3.6.1.4.1.2021.9.1.10";

    /** [h F S̎擝vSNMP MIBw */
    public static final String ALL = "all";

    /** [h F v̎SNMP MIB ifInOctetsw */
    public static final String IF_IN_OCTETS = "ifInOctets";

    /** [h F v̎SNMP MIB ifInOctetsw */
    public static final String IF_OUT_OCTETS = "ifOutOctets";

    /** [h F v̎SNMP MIB net-snmpw */
    public static final String NET_SNMP = "net-snmp";
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);
        String nodeIPAddress = request.getParameter(Preference.IPADDRESS);
        String mode = request.getParameter("mode");

        NodeStatisticsMibGetStateModel nodeStatisticsMibStateModel =
            new NodeStatisticsMibGetStateModel();

        /* OIDCX^X擾 */
        StatisticsMibProperty mibproperty =
            nodeStatisticsMibStateModel.getIfDescList(
                engineAddress, nodeIPAddress);

        ArrayList mibList = null;
        HashMap mibInstanceMap = mibproperty.getStatisticsMibInstanceMap();

        if (mode.equals(ALL)) {
            /* [h F S̎擝vSNMP MIBw */
            mibList = mibproperty.getMibIfDescriptorList();
        } else if (mode.equals(IF_IN_OCTETS)) {
            /* [h F v̎SNMP MIB ifInOctetsw */
            mibList = new ArrayList();

            if (mibInstanceMap.containsKey(IF_IN_OCTETS_OID)) {
                ArrayList ifList =
                    (ArrayList) mibInstanceMap.get(IF_IN_OCTETS_OID);

                for (int i = 0; i < ifList.size(); i++) {
                    mibList.add(ifList.get(i));
                }
            }
        } else if (mode.equals(IF_OUT_OCTETS)) {
            /* [h F v̎SNMP MIB ifInOctetsw */
            mibList = new ArrayList();

            if (mibInstanceMap.containsKey(IF_OUT_OCTETS_OID)) {
                ArrayList ifList =
                    (ArrayList) mibInstanceMap.get(IF_OUT_OCTETS_OID);

                for (int i = 0; i < ifList.size(); i++) {
                    mibList.add(ifList.get(i));
                }
            }
        } else if (mode.equals(NET_SNMP)) {
            /* [h F v̎SNMP MIB net-snmpw */
            mibList = new ArrayList();

            if (mibInstanceMap.containsKey(LA_LOAD_OID)) {
                ArrayList ifList = (ArrayList) mibInstanceMap.get(LA_LOAD_OID);

                for (int i = 0; i < ifList.size(); i++) {
                    mibList.add(ifList.get(i));
                }
            }

            if (mibInstanceMap.containsKey(DSK_TOTAL_OID)) {
                ArrayList ifList =
                    (ArrayList) mibInstanceMap.get(DSK_TOTAL_OID);

                for (int i = 0; i < ifList.size(); i++) {
                    mibList.add(ifList.get(i));
                }
            }

            if (mibInstanceMap.containsKey(DSK_AVAIL_OID)) {
                ArrayList ifList =
                    (ArrayList) mibInstanceMap.get(DSK_AVAIL_OID);

                for (int i = 0; i < ifList.size(); i++) {
                    mibList.add(ifList.get(i));
                }
            }

            if (mibInstanceMap.containsKey(DSK_USED_OID)) {
                ArrayList ifList = (ArrayList) mibInstanceMap.get(DSK_USED_OID);

                for (int i = 0; i < ifList.size(); i++) {
                    mibList.add(ifList.get(i));
                }
            }

            if (mibInstanceMap.containsKey(LA_LOAD_INT_OID)) {
                ArrayList ifList =
                    (ArrayList) mibInstanceMap.get(LA_LOAD_INT_OID);

                for (int i = 0; i < ifList.size(); i++) {
                    mibList.add(ifList.get(i));
                }
            }

            if (mibInstanceMap.containsKey(LA_LOAD_FLOAT_OID)) {
                ArrayList ifList =
                    (ArrayList) mibInstanceMap.get(LA_LOAD_FLOAT_OID);

                for (int i = 0; i < ifList.size(); i++) {
                    mibList.add(ifList.get(i));
                }
            }

            if (mibInstanceMap.containsKey(DSK_PERCENT_OID)) {
                ArrayList ifList =
                    (ArrayList) mibInstanceMap.get(DSK_PERCENT_OID);

                for (int i = 0; i < ifList.size(); i++) {
                    mibList.add(ifList.get(i));
                }
            }

            if (mibInstanceMap.containsKey(DSK_PERCENT_NODE_OID)) {
                ArrayList ifList =
                    (ArrayList) mibInstanceMap.get(DSK_PERCENT_NODE_OID);

                for (int i = 0; i < ifList.size(); i++) {
                    mibList.add(ifList.get(i));
                }
            }
        } else {
            mibList = mibproperty.getMibIfDescriptorList();
        }

        request.setAttribute(Preference.SNMP_MIB_GET_STATE_LIST, mibList);

        request.setAttribute(Preference.NODE_IPADDRESS, nodeIPAddress);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');
        request.setAttribute(Preference.SERVER_NAME, servername);

        String convIPAddress = nodeIPAddress.replace('.', '_');
        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
