/*
 * Created on 2004/04/23
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.export.model;

import java.util.ArrayList;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;


/**
 * m[hĎyуm[hMapN񂩂XMLo͗pDocument𐶐郁\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeRegisterInfoExportModel {
    /* MO */
    private static Logger logger;

    /**
     *
     *
     */
    public NodeRegisterInfoExportModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hĎ񃊃Xgƃm[hMapN񂩂XML Document쐬܂B
     *
     * @param nodeInfoList m[hĎ񃊃Xg
     * @param nodeMapLinkInfo m[hMapN
     * @return dom Document
     */
    public Document createDocument(
        ArrayList nodeInfoList, NodeMapLinkInformation nodeMapLinkInfo) {
        Document dom = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;

        try {
            db = dbf.newDocumentBuilder();
        } catch (ParserConfigurationException e) {
            /* DocumentBuilderŗO */
            logger.warning("ParserConfigurationException " + e.getMessage());
            e.printStackTrace();
        }

        dom = db.newDocument();

        Element rootNode = dom.createElement(NodeInformationXMLTag.ROOT_TAG);
        dom.appendChild(rootNode);
        logger.info("nodeInfoList size() : " + nodeInfoList.size());

        /* m[hĎDocument */
        Element elNodeInfo =
            dom.createElement(NodeInformationXMLTag.NODE_INFO_ROOT_TAG);

        for (int i = 0; i < nodeInfoList.size(); i++) {
            NodeInformation nodeInfo = (NodeInformation) nodeInfoList.get(i);

            Element elNodeInfoSub =
                dom.createElement(NodeInformationXMLTag.NODE_INFO_TAG);

            // TAG̖O
            Element elNodeName =
                dom.createElement(NodeInformationXMLTag.NODENAME);
            Element elNodeAddress =
                dom.createElement(NodeInformationXMLTag.IPADDRESS);
            Element elNodeGroup =
                dom.createElement(NodeInformationXMLTag.GROUP);
            Element elNodeEngine =
                dom.createElement(NodeInformationXMLTag.ENGINE_ADDRESS);
            Element elNodeX = dom.createElement(NodeInformationXMLTag.NODE_X);
            Element elNodeY = dom.createElement(NodeInformationXMLTag.NODE_Y);
            Element elNodeKind =
                dom.createElement(NodeInformationXMLTag.NODEKIND);
            Element elPingPeriod =
                dom.createElement(NodeInformationXMLTag.PING_PERIOD);
            Element elPingThresh =
                dom.createElement(NodeInformationXMLTag.PING_THRESHHOLD);
            Element elSNMPVersion =
                dom.createElement(NodeInformationXMLTag.SNMP_VERSION);
            Element elSNMPLevel =
                dom.createElement(NodeInformationXMLTag.SNMP_LEVEL);
            Element elSNMPPeriod =
                dom.createElement(NodeInformationXMLTag.SNMP_PERIOD);
            Element elSNMPTimeout =
                dom.createElement(NodeInformationXMLTag.SNMP_TIMEOUT);
            Element elSNMPROCommunity =
                dom.createElement(NodeInformationXMLTag.SNMP_ROCOMMUNITY);
            Element elSNMPRWCommunity =
                dom.createElement(NodeInformationXMLTag.SNMP_RWCOMMUNITY);

            Element elHttpPeriod =
                dom.createElement(NodeInformationXMLTag.HTTP_PERIOD);
            Element elHttpUrl =
                dom.createElement(NodeInformationXMLTag.HTTP_URL);
            Element elHttpTimeout =
                dom.createElement(NodeInformationXMLTag.HTTP_TIMEOUT);

            /*  */
            Element elPop3Period =
                dom.createElement(NodeInformationXMLTag.POP3_PERIOD);
            Element elPop3User =
                dom.createElement(NodeInformationXMLTag.POP3_USER);
            Element elPop3Password =
                dom.createElement(NodeInformationXMLTag.POP3_PASSWORD);
            Element elPop3Port =
                dom.createElement(NodeInformationXMLTag.POP3_PORT);
            Element elPop3Timeout =
                dom.createElement(NodeInformationXMLTag.POP3_TIMEOUT);

            /*  */
            Element elSmtpPeriod =
                dom.createElement(NodeInformationXMLTag.SMTP_PERIOD);
            Element elSmtpPort =
                dom.createElement(NodeInformationXMLTag.SMTP_PORT);
            Element elSmtpTimeout =
                dom.createElement(NodeInformationXMLTag.SMTP_TIMEOUT);
            Element elSmtpSendAddress =
                dom.createElement(NodeInformationXMLTag.SMTP_SEND_ADDRESS);
            Element elSmtpCheckPop3Host =
                dom.createElement(NodeInformationXMLTag.SMTP_CHECK_POP3_HOST);
            Element elSmtpCheckPop3User =
                dom.createElement(NodeInformationXMLTag.SMTP_CHECK_POP3_USER);
            Element elSmtpCheckPop3Password =
                dom.createElement(
                    NodeInformationXMLTag.SMTP_CHECK_POP3_PASSWORD);
            Element elSmtpCheckPop3Port =
                dom.createElement(NodeInformationXMLTag.SMTP_CHECK_POP3_PORT);
            Element elSmtpCheckPop3Timeout =
                dom.createElement(
                    NodeInformationXMLTag.SMTP_CHECK_POP3_TIMEOUT);

            //
            if (nodeInfo.getNodename() == null) {
                nodeInfo.setNodename("");
            }

            Text textNodeNameValue = dom.createTextNode(nodeInfo.getNodename());

            if (nodeInfo.getIpaddress() == null) {
                nodeInfo.setIpaddress("");
            }

            Text textNodeAddressValue =
                dom.createTextNode(nodeInfo.getIpaddress());

            if (nodeInfo.getGroup() == null) {
                nodeInfo.setGroup("");
            }

            Text textNodeGroupValue = dom.createTextNode(nodeInfo.getGroup());

            if (nodeInfo.getGroup() == null) {
                nodeInfo.setGroup("");
            }

            Text textNodeEngineValue =
                dom.createTextNode(nodeInfo.getEngineAddress());

            if (nodeInfo.getEngineAddress() == null) {
                nodeInfo.setEngineAddress("");
            }

            Text textNodeXValue = dom.createTextNode(nodeInfo.getNodeX());

            if (nodeInfo.getNodeY() == null) {
                nodeInfo.setNodeY("");
            }

            Text textNodeYValue = dom.createTextNode(nodeInfo.getNodeY());

            if (nodeInfo.getNodeKind() == null) {
                nodeInfo.setNodeKind("");
            }

            Text textNodeKind = dom.createTextNode(nodeInfo.getNodeKind());

            if (nodeInfo.getPingPeriod() == null) {
                nodeInfo.setPingPeriod("");
            }

            Text textPingPeriodValue =
                dom.createTextNode(nodeInfo.getPingPeriod());

            if (nodeInfo.getPingPeriod() == null) {
                nodeInfo.setPingPeriod("");
            }

            Text textPingThreshValue =
                dom.createTextNode(nodeInfo.getPingThreshold());

            //
            if (nodeInfo.getSnmpVersion() == null) {
                nodeInfo.setSnmpVersion("");
            }

            Text textSNMPVersionValue =
                dom.createTextNode(nodeInfo.getSnmpVersion());

            //
            if (nodeInfo.getSnmpLevel() == null) {
                nodeInfo.setSnmpLevel("");
            }

            Text textSNMPLevelValue =
                dom.createTextNode(nodeInfo.getSnmpLevel());

            //
            if (nodeInfo.getSnmpPeriod() == null) {
                nodeInfo.setSnmpPeriod("");
            }

            Text textSNMPPeriodValue =
                dom.createTextNode(nodeInfo.getSnmpPeriod());

            //
            if (nodeInfo.getSnmpTimeout() == null) {
                nodeInfo.setSnmpTimeout("");
            }

            Text textSNMPTimeoutValue =
                dom.createTextNode(nodeInfo.getSnmpTimeout());

            //
            if (nodeInfo.getRoCommunity() == null) {
                nodeInfo.setRoCommunity("");
            }

            Text textSNMPROCommunityValue =
                dom.createTextNode(nodeInfo.getRoCommunity());

            if (nodeInfo.getRwCommunity() == null) {
                nodeInfo.setRwCommunity("");
            }

            Text textSNMPRWCommunityValue =
                dom.createTextNode(nodeInfo.getRwCommunity());

            /*  */
            Text textHttpPeriodValue =
                dom.createTextNode(nodeInfo.getHttpPeriod());
            Text textHttpUrlValue = dom.createTextNode(nodeInfo.getHttpUrl());
            Text textHttpTimeoutValue =
                dom.createTextNode(nodeInfo.getHttpTimeout());

            /*  */
            Text textPop3PeriodValue =
                dom.createTextNode(nodeInfo.getPopPeriod());
            Text textPop3PortValue = dom.createTextNode(nodeInfo.getPopPort());
            Text textPop3TimeoutValue =
                dom.createTextNode(nodeInfo.getPopTimeout());
            Text textPop3UserValue = dom.createTextNode(nodeInfo.getPopUser());
            Text textPop3PasswordValue =
                dom.createTextNode(nodeInfo.getPopPassword());

            /*  */
            Text textSmtpPeriodValue =
                dom.createTextNode(nodeInfo.getSmtpPeriod());
            Text textSmtpPortValue = dom.createTextNode(nodeInfo.getSmtpPort());
            Text textSmtpTimeoutValue =
                dom.createTextNode(nodeInfo.getSmtpTimeout());
            Text textSmtpSendAddressValue =
                dom.createTextNode(nodeInfo.getSmtpSendAddress());
            Text textSmtpCheckPop3HostValue =
                dom.createTextNode(nodeInfo.getSmtpCheckHost());
            Text textSmtpCheckPop3UserValue =
                dom.createTextNode(nodeInfo.getSmtpCheckUser());
            Text textSmtpCheckPop3PasswordValue =
                dom.createTextNode(nodeInfo.getSmtpCheckPassword());
            Text textSmtpCheckPop3PortValue =
                dom.createTextNode(nodeInfo.getSmtpCheckPort());
            Text textSmtpCheckPop3TimeoutValue =
                dom.createTextNode(nodeInfo.getSmtpCheckTimeout());

            /*  */
            elNodeName.appendChild(textNodeNameValue);
            elNodeAddress.appendChild(textNodeAddressValue);
            elNodeGroup.appendChild(textNodeGroupValue);
            elNodeEngine.appendChild(textNodeEngineValue);
            elNodeX.appendChild(textNodeXValue);
            elNodeY.appendChild(textNodeYValue);
            elNodeKind.appendChild(textNodeKind);

            /*  */
            elPingPeriod.appendChild(textPingPeriodValue);
            elPingThresh.appendChild(textPingThreshValue);

            /*  */
            elSNMPVersion.appendChild(textSNMPVersionValue);
            elSNMPLevel.appendChild(textSNMPLevelValue);
            elSNMPPeriod.appendChild(textSNMPPeriodValue);
            elSNMPTimeout.appendChild(textSNMPTimeoutValue);
            elSNMPROCommunity.appendChild(textSNMPROCommunityValue);
            elSNMPRWCommunity.appendChild(textSNMPRWCommunityValue);

            elHttpPeriod.appendChild(textHttpPeriodValue);
            elHttpUrl.appendChild(textHttpUrlValue);
            elHttpTimeout.appendChild(textHttpTimeoutValue);

            elPop3Period.appendChild(textPop3PeriodValue);
            elPop3User.appendChild(textPop3UserValue);
            elPop3Password.appendChild(textPop3PasswordValue);
            elPop3Port.appendChild(textPop3PortValue);
            elPop3Timeout.appendChild(textPop3TimeoutValue);

            elSmtpPeriod.appendChild(textSmtpPeriodValue);
            elSmtpPort.appendChild(textSmtpPortValue);
            elSmtpTimeout.appendChild(textSmtpTimeoutValue);
            elSmtpSendAddress.appendChild(textSmtpSendAddressValue);
            elSmtpCheckPop3Host.appendChild(textSmtpCheckPop3HostValue);
            elSmtpCheckPop3User.appendChild(textSmtpCheckPop3UserValue);
            elSmtpCheckPop3Password.appendChild(textSmtpCheckPop3PasswordValue);
            elSmtpCheckPop3Port.appendChild(textSmtpCheckPop3PortValue);
            elSmtpCheckPop3Timeout.appendChild(textSmtpCheckPop3TimeoutValue);

            /*  */
            elNodeInfoSub.appendChild(elNodeName);
            elNodeInfoSub.appendChild(elNodeAddress);
            elNodeInfoSub.appendChild(elNodeGroup);
            elNodeInfoSub.appendChild(elNodeEngine);
            elNodeInfoSub.appendChild(elNodeX);
            elNodeInfoSub.appendChild(elNodeY);
            elNodeInfoSub.appendChild(elNodeKind);

            /*  */
            elNodeInfoSub.appendChild(elPingPeriod);
            elNodeInfoSub.appendChild(elPingThresh);

            /*  */
            elNodeInfoSub.appendChild(elSNMPVersion);
            elNodeInfoSub.appendChild(elSNMPLevel);
            elNodeInfoSub.appendChild(elSNMPPeriod);
            elNodeInfoSub.appendChild(elSNMPTimeout);
            elNodeInfoSub.appendChild(elSNMPROCommunity);
            elNodeInfoSub.appendChild(elSNMPRWCommunity);

            /*  */
            elNodeInfoSub.appendChild(elHttpPeriod);
            elNodeInfoSub.appendChild(elHttpUrl);
            elNodeInfoSub.appendChild(elHttpTimeout);

            /*  */
            elNodeInfoSub.appendChild(elPop3Period);
            elNodeInfoSub.appendChild(elPop3User);
            elNodeInfoSub.appendChild(elPop3Password);
            elNodeInfoSub.appendChild(elPop3Port);
            elNodeInfoSub.appendChild(elPop3Timeout);

            /*  */
            elNodeInfoSub.appendChild(elSmtpPeriod);
            elNodeInfoSub.appendChild(elSmtpPort);
            elNodeInfoSub.appendChild(elSmtpTimeout);
            elNodeInfoSub.appendChild(elSmtpSendAddress);
            elNodeInfoSub.appendChild(elSmtpCheckPop3Host);
            elNodeInfoSub.appendChild(elSmtpCheckPop3User);
            elNodeInfoSub.appendChild(elSmtpCheckPop3Password);
            elNodeInfoSub.appendChild(elSmtpCheckPop3Port);
            elNodeInfoSub.appendChild(elSmtpCheckPop3Timeout);

            /*  */
            elNodeInfo.appendChild(elNodeInfoSub);
        }

        rootNode.appendChild(elNodeInfo);

        /* Link Document */
        Element elLinkInfo =
            dom.createElement(NodeInformationXMLTag.LIN_INFO_ROOT_TAG);

        if (
            (nodeMapLinkInfo.getNode0address() != null)
                && (nodeMapLinkInfo.getNode1address() != null)) {
            for (int j = 0; j < nodeMapLinkInfo.getNode0address().size();
                    j++) {
                // NodeMapLink nodemapLink = (NodeMapLink) linkList.get(j);
                String node0Address =
                    (String) nodeMapLinkInfo.getNode0address().get(j);
                String node1Address =
                    (String) nodeMapLinkInfo.getNode1address().get(j);


                Element elLinkInfosub =
                    dom.createElement(NodeInformationXMLTag.LIN_INFO_TAG);
                Element elNodeX =
                    dom.createElement(NodeInformationXMLTag.LINK_X);
                Element elNodeY =
                    dom.createElement(NodeInformationXMLTag.LINK_Y);

                //
                Text textNodeXValue = dom.createTextNode(node0Address);
                Text textNodeYValue = dom.createTextNode(node1Address);

                //
                elNodeX.appendChild(textNodeXValue);
                elNodeY.appendChild(textNodeYValue);

                //
                elLinkInfosub.appendChild(elNodeX);
                elLinkInfosub.appendChild(elNodeY);
                elLinkInfo.appendChild(elLinkInfosub);
            }
        }

        rootNode.appendChild(elLinkInfo);

        return dom;
    }
}
