/*
 * Created on 2004/05/21
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.export;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.nodemanager.list.model.NodeListViewModel;


/**
 * A[CSVo͂NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmInfoCSVExportAction extends HttpServlet {
    /* MO */
    private static Logger logger;

    public void doGet(HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter("engineAddress");

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
        }

        NodeListViewModel nodeListModel = new NodeListViewModel();

        ArrayList list = null;

        try {
            list = nodeListModel.getList(engineAddress, null, null);
        } catch (EngineConnectException e) {
            logger.warning(
                "EngineConnectException " + e.getMessage() + " Engine = "
                + engineAddress);
            e.printStackTrace();
        } catch (IOException e) {
            logger.warning(
                "IOException " + e.getMessage() + " Engine = " + engineAddress);
            e.printStackTrace();
        }

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();
    }
}
