/*
 * Created on 2004/12/16
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.InterfaceControl;
import netjfwatcher.engine.command.control.CommandMappingTableResource;


/**
 * C^tF[XMIB擾NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionInterfaceData extends AbstractConnectionEngine {
    /* MO */
    private static Logger logger;

    /**
     * GWC^tF[XMIBf[^擾̂߂̃CX^X
     * ܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionInterfaceData(final String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * GWC^tF[XMIBf[^擾܂B
     *
     * @param ipAddress m[hIPAhX
     * @param oid OID
     * @param mode [h
     * @return interfaceDataList Interface MIBf[^
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public ArrayList getInterfaceData(
        final String ipAddress, final String oid, final String mode)
        throws EngineConnectException, IOException {
        logger.info("IP=" + ipAddress + " OID=" + oid + " MODE=" + mode);

        ArrayList interfaceDataList = null;

        InterfaceControl interfaceCont = new InterfaceControl();
        interfaceCont.setOid(oid);

        /* ώZ܂͍[hZbg */
        interfaceCont.setMode(mode);

        /* R}hZbg */
        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode(
            CommandMappingTableResource.INTERFACE_DATA_GET_COMMAND_ID);
        commandInfo.setIpaddress(ipAddress);
        commandInfo.setInterfaceControl(interfaceCont);

        /* GWƒʐM */
        interfaceDataList = (ArrayList) this.communicationToEngine(commandInfo);

        return interfaceDataList;
    }
}
