/*
 * Created on 2004/12/17
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.command.control.CommandMappingTableResource;


/**
 * GWƃA[𑗎Ms\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionAlarmInformation extends AbstractConnectionEngine {
    /* MO */
    private static Logger logger;

    /**
     * GWƃA[𑗎Ms\bhNX
     * CX^X𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionAlarmInformation(final String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * A[񃊃Xg擾܂B
     *
     * @param limit 擾Xg̏l
     * @param ipAddress m[hIPAhX
     * @param sortColumn \[gJ
     * @param sortDirection \[g
     * @return responseList A[񃊃Xg
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public ArrayList getAlarmInformationList(
        final int limit, final String ipAddress, final String sortColumn,
        final String sortDirection) throws EngineConnectException, IOException {
        AlarmInformation alarmInfo = new AlarmInformation();
        alarmInfo.setSubCommand(AlarmInformation.ALARM_LIST_GET);
        alarmInfo.setSelectIPAddress(ipAddress);
        alarmInfo.setSortColumn(sortColumn);
        alarmInfo.setSortDirection(sortDirection);
        alarmInfo.setLimit(limit);

        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setAlarmInformation(alarmInfo);
        commnadInfo.setCode(
            CommandMappingTableResource.ALARM_INFORMATION_COMMAND_ID);

        ArrayList responseList = null;
        responseList = (ArrayList) this.communicationToEngine(commnadInfo);
        logger.info("IP Address=" + ipAddress);

        return responseList;
    }

    /**
     * A[IDmFς݂Ƃ܂B
     *
     * @param ipAddress m[hIPAhX
     * @param id A[ID
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void confirmAlarmId(final String ipAddress, final String id)
        throws EngineConnectException, IOException {
        AlarmInformation alarmInfo = new AlarmInformation();
        alarmInfo.setSubCommand(AlarmInformation.ALARM_ID_CONFIRM);
        alarmInfo.setSelectIPAddress(ipAddress);
        alarmInfo.setAlarmID(id);

        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setAlarmInformation(alarmInfo);
        commnadInfo.setCode(
            CommandMappingTableResource.ALARM_INFORMATION_COMMAND_ID);
        this.communicationToEngine(commnadInfo);
        logger.info("Alarm Confirm ID=" + id);
    }

    /**
     * wm[h̑SA[mFς݂Ƃ܂B
     *
     * @param ipAddress m[hIPAhX
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void confirmAllAlarmt(final String ipAddress)
        throws EngineConnectException, IOException {
        AlarmInformation alarmInfo = new AlarmInformation();
        alarmInfo.setSubCommand(AlarmInformation.ALARM_ADDRESS_CONFIRM);
        alarmInfo.setIpaddress(ipAddress);

        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setAlarmInformation(alarmInfo);
        commnadInfo.setCode(
            CommandMappingTableResource.ALARM_INFORMATION_COMMAND_ID);
        this.communicationToEngine(commnadInfo);
    }
}
