/*
 * Created on 2004/07/19
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;



/**
 * GWƐڑAf[^Ms\bh钊ۃNXłB
 * GWƂ̒ʐMsNXɌp܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractConnectionEngine {
    /* MO */
    private static Logger logger = null;

    /** GWIPAhX */
    protected String engineServerAddress;

    /** GWƂ̐ڑ|[gԍ */
    protected int enginePort;

    /** GWƂ̐ڑ^CAEgl */
    protected int socketTimeout;

    /**
     * w̃GWAhXɑΉPortԍ\[X擾āAGW
     * Ƃ̐ڑPortƂ܂B
     *
     * @param engineAddress GWAhX
     */
    public AbstractConnectionEngine(final String engineAddress) {
        logger = Logger.getLogger(this.getClass().getName());

        // GWAhXZbg
        engineServerAddress = engineAddress;

        String socketTimeoutString = "0";

        // w̃GWAhXɑΉPortԍ\[X擾
        ArrayList engineList =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getEngineInfoList();
        String enginePortString = "";
        boolean isMuchEngineAddress = false;

        for (int i = 0; i < engineList.size(); i++) {
            String checkAddress =
                ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();

            /*
             * ڑwGWAddressƃGWListAddressr
             */
            if (engineAddress.equals(checkAddress)) {
                /*
                 * ڑwGWAddressƃGWListAddress
                 * vꍇꍇListPortԍ擾
                 */
                enginePortString =
                    ((EngineResourceInfo) engineList.get(i)).getEnginePort();
                socketTimeoutString =
                    ((EngineResourceInfo) engineList.get(i)).getEngineTimeout();
                isMuchEngineAddress = true;

                break;
            }
        }

        if (!isMuchEngineAddress) {
            for (int i = 0; i < engineList.size(); i++) {
                String checkAddress =
                    ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();

                /*
                 * ڑwGWAddressƃGWListAddress
                 * vȂꍇɂ́AListAddressLoca Address
                 * `FbN
                 * (ListAddress127.0.0.1̏ꍇł́AwAddress
                 * Local Addressvꍇ)
                 */
                if (checkAddress.equals("127.0.0.1")) {
                    String checkLocalEngineAddress = "";

                    try {
                        checkLocalEngineAddress =
                            InetAddress.getLocalHost().getHostAddress();
                    } catch (UnknownHostException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }

                    if (engineAddress.equals(checkLocalEngineAddress)) {
                        /*
                         * wAddressListAddressvȂ
                         * wAddressLocalAddressvꍇ
                         */
                        enginePortString =
                            ((EngineResourceInfo) engineList.get(i))
                            .getEnginePort();
                        socketTimeoutString =
                            ((EngineResourceInfo) engineList.get(i))
                            .getEngineTimeout();
                        isMuchEngineAddress = true;

                        break;
                    }
                }
            }
        }

        if (isMuchEngineAddress) {
            try {
                enginePort = Integer.parseInt(enginePortString);
                socketTimeout = Integer.parseInt(socketTimeoutString);
            } catch (NumberFormatException e) {
                /* GWAhXGWXg猩ȂA|[gԍُȏꍇ */
                logger.warning("Engine port NumberFormatException");
                logger.warning("Engine address : " + engineAddress);
                logger.warning("Engine port : " + enginePortString);
                logger.warning("Engine timeout : " + socketTimeoutString);
                e.printStackTrace();
            }
        } else {
            logger.warning("Not found Engine address : " + engineAddress);
        }
    }

    /**
     * GWƐڑAw̃IuWFNgGWɑMA҂܂B
     * MAAckR[hGWɑM܂B
     *
     * @param commandInfo R}h
     * @return responseObject GW̉IuWFNg
     *
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public Object communicationToEngine(final CommandInfo commandInfo)
        throws EngineConnectException, IOException {
        Object responseObject = null;
        Socket socket = null;
        ObjectOutputStream oos = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;

        try {
            /* GWSocketڑ */
            InetAddress dstInetAddr =
                InetAddress.getByName(engineServerAddress);
            socket = new Socket(dstInetAddr, enginePort);
            socket.setSoTimeout(socketTimeout);

            OutputStream os = socket.getOutputStream();
            oos = new ObjectOutputStream(os);

            oos.writeObject(commandInfo);
            oos.flush();

            bis = new BufferedInputStream(socket.getInputStream());
            ois = new ObjectInputStream(bis);

            while (true) {
                try {
                    responseObject = ois.readObject();

                    break;
                } catch (EOFException ex) {
                    logger.warning(ex.getMessage());
                    ex.printStackTrace();

                    return null;
                }
            }

            // ACK Send
            CommandInfo ackCommnadInfo = new CommandInfo();
            ackCommnadInfo.setCode(CommandMappingTableResource.ACK_RESPONSE);
            oos.writeObject(ackCommnadInfo);
            oos.flush();
        } catch (UnknownHostException ex) {
            logger.warning("Client communication UnknownHostException");
            throw new EngineConnectException(
                ex.getMessage() + " Engine address = " + engineServerAddress
                + " port = " + enginePort);
        } catch (ConnectException e) {
            logger.warning("ConnectException : " + e.getMessage());
            throw new EngineConnectException(
                e.getMessage() + " Engine address = " + engineServerAddress
                + " port = " + enginePort);
        } catch (ClassNotFoundException ex) {
            logger.warning("Client communication ClassNotFoundException");
            throw new EngineConnectException(
                ex.getMessage() + " Engine address = " + engineServerAddress
                + " port = " + enginePort);
        } catch (IOException ex) {
            logger.warning("Client communication IOException");
            throw ex;
        } finally {
            if (oos != null) {
                try {
                    oos.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (bis != null) {
                try {
                    bis.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (socket != null) {
                try {
                    socket.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }

        return responseObject;
    }
}
