/*
 * Created on 2003/07/31
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.alarm.view.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionAlarmInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;


/**
 * A[擾NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmViewModel {
    /* MO */
    private static Logger logger;

    /* m[hIPAhX */
    private String ipaddress;

    /* e[u\[gJ */
    private String sortColumn;

    /* e[u\[g */
    private String sortDirection;

    public AlarmViewModel(
        String ipaddress, String sortColumn, String sortDirection) {
        logger = Logger.getLogger(this.getClass().getName());
        this.ipaddress = ipaddress;
        this.sortColumn = sortColumn;
        this.sortDirection = sortDirection;
    }

    public ArrayList getAlarmList(
        String engineAddress, int limit, int start, int end)
        throws EngineConnectException, IOException {
        ArrayList alarmList = null;
        boolean isEngineALarm = false;
        ConnectionAlarmInformation connection = null;

        logger.info("Connect engineAddress : " + engineAddress);

        if (engineAddress.equals("all")) {
            alarmList = new ArrayList();

            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();
            AlarmInformation engineAlarInfo = null;

            for (int i = 0; i < engineList.size(); i++) {
                String testEngineAddress =
                    ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
                logger.info("Check engine connect : " + testEngineAddress);

                ArrayList workAlarmList = null;

                try {
                    connection =
                        new ConnectionAlarmInformation(testEngineAddress);
                    workAlarmList =
                        connection.getAlarmInformationList(
                            limit, ipaddress, sortColumn, sortDirection);

                    if ((workAlarmList != null) && (workAlarmList.size() > 0)) {
                        int j = start;

                        for (; j < workAlarmList.size(); j++) {
                            if ((end != 0) && (j >= end)) {
                                break;
                            }

                            AlarmInformation alarInfo =
                                (AlarmInformation) workAlarmList.get(j);
                            alarmList.add(alarInfo);
                        }
                    }

                    if (
                        (engineList.size() > 1) && (sortColumn != null)
                            && (sortDirection != null)) {
                        AlarmListSort listSort = new AlarmListSort();
                        alarmList =
                            listSort.sortObjectArray(
                                alarmList, sortColumn, sortDirection);
                    }
                } catch (EngineConnectException e) {
                    logger.info("abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                    isEngineALarm = true;
                    engineAlarInfo =
                        createEngineAlarm(testEngineAddress, e.getMessage());
                } catch (IOException e) {
                    logger.info("abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                    isEngineALarm = true;
                    engineAlarInfo =
                        createEngineAlarm(testEngineAddress, e.getMessage());
                } catch (Exception e) {
                    isEngineALarm = true;
                    engineAlarInfo =
                        createEngineAlarm(testEngineAddress, e.getMessage());
                    e.printStackTrace();
                }
            }

            /* EngineڑُA[A[List̐擪ɃZbg */
            if (isEngineALarm) {
                alarmList.add(0, engineAlarInfo);
            }
        } else {
            alarmList = new ArrayList();
            connection = new ConnectionAlarmInformation(engineAddress);

            ArrayList workAlarmList =
                connection.getAlarmInformationList(
                    limit, ipaddress, sortColumn, sortDirection);

            if ((sortColumn != null) && (sortDirection != null)) {
                AlarmListSort listSort = new AlarmListSort();
                workAlarmList =
                    listSort.sortObjectArray(
                        workAlarmList, sortColumn, sortDirection);
            }

            if ((workAlarmList != null) && (workAlarmList.size() > 0)) {
                int j = start;

                for (; j < workAlarmList.size(); j++) {
                    if ((end != 0) && (j >= end)) {
                        break;
                    }

                    AlarmInformation alarInfo =
                        (AlarmInformation) workAlarmList.get(j);
                    alarmList.add(alarInfo);
                }

                return alarmList;
            }

            if (alarmList.size() == 0) {
                alarmList = workAlarmList;
            }
        }

        return alarmList;
    }

    /**
     * GWA[𐶐܂B
     *
     * @param engineAddress GWA[
     * @param alarmMessage A[bZ[W
     * @return alarmInfo A[CX^X
     */
    private AlarmInformation createEngineAlarm(
        String engineAddress, String alarmMessage) {
        AlarmInformation alarmInfo = new AlarmInformation();
        alarmInfo.setNodename("--");
        alarmInfo.setIpaddress("--");
        alarmInfo.setGroup("--");
        alarmInfo.setAlarmID("--");
        alarmInfo.setAlarmCode("--");
        alarmInfo.setAlarmDate("--");
        alarmInfo.setAlarmLevel("ERROR");
        alarmInfo.setAlarmConfirm("confirm");
        alarmInfo.setAlarmMessage(alarmMessage);

        return alarmInfo;
    }
}
