/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

import netjfwatcher.syslogng.plugin.NetJFWatcherRCPSyslogNGPlugin;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

/**
 * syslog-ngɊւ\`\[Xt@C̉͂sNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SyslogNGResourceFileParse {
	/** \[XXML l^O */
	public static final String XML_FILE_VALUE = "value";

	/** \[XXML conf ^O */
	public static final String CONF = "conf";

	/** \[XXML Engine ^O */
	public static final String ALLOW_HOST = "allow-host";

	/** \[XXML Engine Port ^O */
	public static final String TCP_PORT = "tcp-port";

	/** \[XXML Engine Port ^O */
	public static final String UDP_PORT = "udp-port";

	private SyslogNGConfInfo syslogNGConf;

	private String allowHost;

	private String tcpPort;

	private String udpPort;

	/* Logging */
	private static Logger logger = null;

	/**
	 * 
	 * wfBNgt@C͂ă\[Xێ܂B
	 * 
	 * @throws Exception
	 *             \[X͂Ɏsꍇ
	 */
	public SyslogNGResourceFileParse() throws Exception {
		logger = Logger.getLogger(this.getClass().getName());
		syslogNGConf = SyslogNGConfInfo.getInstance();
		logger.info("Resource File Parse : " + "resources/syslogng_conf.xml");

		Document doc = null;

		// jart@C邩fBNgwt@C擾邩
		doc = getDocument("resources/syslogng_conf.xml");
		/*
		 * doc = getResourceFileDocumentPath( "resources/syslogng_conf.xml");
		 */

		if (doc == null) {
			logger.severe("Resource File Doc null ");

			return;
		}

		// rootvfo
		Element root = doc.getRootElement();

		if (root.getChild(ALLOW_HOST) != null) {
			allowHost = (root.getChild(ALLOW_HOST))
					.getAttributeValue(XML_FILE_VALUE);
			syslogNGConf.setAllowHost(allowHost);
		}
		if (root.getChild(TCP_PORT) != null) {
			tcpPort = (root.getChild(TCP_PORT))
					.getAttributeValue(XML_FILE_VALUE);
			syslogNGConf.setTcpPort(tcpPort);
		}
		if (root.getChild(UDP_PORT) != null) {
			udpPort = (root.getChild(UDP_PORT))
					.getAttributeValue(XML_FILE_VALUE);
			syslogNGConf.setUdpPort(udpPort);

		}

		logger.info("allowHost " + allowHost);
		logger.info("tcpPort " + tcpPort);
		logger.info("udpPort " + udpPort);
	}

	/**
	 * wfBNgXMLt@C͂DocumentԂ܂B ijart@ČȂj
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	public Document getResourceFileDocumentPath(String file) {
		Document doc = null;

		File f = new File(file);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			logger.warning("Abort create File : " + f.getAbsolutePath());

			return null;
		}

		BufferedReader d = null;

		try {
			FileReader fi = new FileReader(file);
			d = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			logger.warning("FileNotFoundException : " + f.getPath() + " : "
					+ e1.getMessage());
			logger.warning("FileNotFoundException : " + f.getAbsolutePath()
					+ " : " + e1.getMessage());
			e1.printStackTrace();

			return null;
		}

		try {
			// FileInputStream stream = new FileInputStream(f);
			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(d);
		} catch (JDOMException e) {
			logger.warning("JDOMException : " + e.getMessage());
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.warning("NullPointerException : " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.warning("IOException : " + e.getMessage());
			e.printStackTrace();
		}

		return doc;
	}

	/**
	 * jart@CXMLt@CE͂DocumentԂ܂B
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	protected Document getDocument(String file) {
		Document doc = null;

		URL url = null;

		try {
			logger.severe("Parse start : " + file);

			/* 摜肷邽߂PluginResource bundle */
			Bundle bundle = NetJFWatcherRCPSyslogNGPlugin.getInstance()
					.getBundle();
			url = bundle.getEntry(file);

			// logger.info("getLocation : " + bundle.getLocation());
			// logger.info("getResourcen : " + bundle.getResource(file));

			if (url == null) {
				/* bZ[W\[Xt@CȂꍇMO̎ */
				logger.severe("Resource XML file url : " + url);

				return null;
			}

			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(url.openStream());
		} catch (JDOMException e) {
			logger.severe("Alert/Confirm Dialog Window Message XML file url : "
					+ url);
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.severe("Alert/Confirm Dialog Window Message XML file url : "
					+ url);
			e.printStackTrace();
		} catch (IOException e) {
			logger.severe("Alert/Confirm Dialog Window Message XML file url : "
					+ url);
			e.printStackTrace();
		}

		return doc;
	}

	public SyslogNGConfInfo getSyslogNGConf() {
		return syslogNGConf;
	}

}
