/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.receive;

import netjfwatcher.engine.command.control.AbstractConnectClientCheck;
import netjfwatcher.syslogng.resource.SyslogNGConfInfo;
import netjfwatcher.syslogng.resource.SyslogNGResourceConfig;

public abstract class AbstractSyslogNGServer extends AbstractConnectClientCheck {

	protected boolean isSetAlarm;

	protected String ignoreMessage;

	protected Thread syslogNGReceiveParseThread;

	// \[X
	protected SyslogNGConfInfo resourceInfo;

	// ڑ҂|[g
	protected int tcpPort;

	protected int udpPort;

	/* ڑzXg */
	protected String allowHost;

	public AbstractSyslogNGServer() {

		resourceInfo = SyslogNGResourceConfig.getInstance()
				.getResourceFileParse().getSyslogNGConf();
		tcpPort = Integer.parseInt(resourceInfo.getTcpPort());
		udpPort = Integer.parseInt(resourceInfo.getUdpPort());
		allowHost = resourceInfo.getAllowHost();
	}
	
	public Thread getSyslogNGReceiveParseThread() {
		return syslogNGReceiveParseThread;
	}
}
