/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.receive;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

/**
 * syslog-ngUDPŎMT[oNNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class SyslogNGUDPReceiveServer extends AbstractSyslogNGServer
		implements Runnable {
	// MO
	private static Logger logger = null;

	/* ServerSocket */
	private DatagramSocket syslogNGReceiveDatagramSocket;

	/*
	 * ClientƂ̐ڑSocketXg(Client̐ڑ҂I Socket closep)
	 */
	private List socketList = Collections.synchronizedList(new LinkedList());

	/**
	 * RXgN^privateɂĕspӂɒڃRXgN^ Ăяoh~
	 */
	private SyslogNGUDPReceiveServer() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static SyslogNGUDPReceiveServer getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * NCAgXML\Pbgڑ҂XML Socket\Pbg 𐶐A|[O[vɂăNCAg̐ڑ
	 * XbhJn܂B<BR>
	 * 
	 * @throws IOException
	 *             ServerSocketɎsꍇ
	 */
	public void startSyslogNGReceiveServer(boolean isSetAlarm,
			String ignoreMessage) throws IOException {
		this.isSetAlarm = isSetAlarm;
		this.ignoreMessage = ignoreMessage;

		syslogNGReceiveDatagramSocket = new DatagramSocket(udpPort);
		logger.info("Create server socket : "
				+ syslogNGReceiveDatagramSocket.getLocalPort());

		syslogNGReceiveParseThread = new Thread(SingletonResource.RESOURCE);
		syslogNGReceiveParseThread.setDaemon(true);
		syslogNGReceiveParseThread.start();
	}

	public void stopSyslogNGReceiveServer() {
		if (syslogNGReceiveParseThread == null) {
			return;
		}

		// interrupt receive thread so it will die a natural death
		syslogNGReceiveParseThread.interrupt();

		if (syslogNGReceiveDatagramSocket != null) {

			syslogNGReceiveDatagramSocket.close();

			/* Thread~܂Loop */
			while ((syslogNGReceiveParseThread != null)
					&& syslogNGReceiveParseThread.isAlive()) {
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}

			syslogNGReceiveDatagramSocket = null;
		}

		logger.info("Syslog-NG receive thread stop");
		syslogNGReceiveParseThread = null;
	}

	/**
	 * ServerSocket̃CX^X𐶐ANCAg̐ڑ ҂[vɓB<BR>
	 * NCAg̐ڑ󂯓ƁAT[oNCAg ւ̃CxgPUSHʒm̂̃Xbh𐶐܂B<BR>
	 * 
	 */
	public void run() {
		try {
			while (true) {

				byte receiveBuffer[] = new byte[AbstractSyslogNGReciveParse.RECEIVE_BUFF_SIZE];

				DatagramPacket receivePacket = new DatagramPacket(
						receiveBuffer,
						AbstractSyslogNGReciveParse.RECEIVE_BUFF_SIZE);

				syslogNGReceiveDatagramSocket.receive(receivePacket);

				int receiveLength = receivePacket.getLength();

				if (receiveLength <= 0) {
					continue;
				}

				String[] test = receivePacket.getSocketAddress().toString()
						.split(":");
				logger.info("Remote IP Address="
						+ receivePacket.getSocketAddress());
				String remoteIPAddress = test[0].substring(1, test[0].length());

				/*
				 * ڑClientł邩`FbN
				 */
				boolean isAllowClient = checkHost(allowHost, remoteIPAddress);

				if (!isAllowClient) {
					/* Client ڑ */

					syslogNGReceiveDatagramSocket.close();

				} else {

					byte[] receiveDataByte = receivePacket.getData();
					SyslogNGUDPReceiveParseThread parseThread = new SyslogNGUDPReceiveParseThread(
							isSetAlarm, ignoreMessage);
					parseThread.startSyslogNGParseThread(remoteIPAddress,
							udpPort, receivePacket, receiveDataByte,
							receiveLength);
				}
			} // Client̐ڑ҂[v
		} catch (IOException ex) {
			/*
			 * Clientڑ҂Shutdown(퓮)yыN ُȂǂُ̈̏ꍇ
			 * (Client̐ؒfɂExceptionThreadőΉ)
			 */
			if (syslogNGReceiveDatagramSocket.isClosed()) {
				logger.info("Server socket closed " + ex.getMessage());
			} else {
				logger.warning(ex.getMessage());
			}
		} finally {
			for (int i = 0; i < socketList.size(); i++) {
				Socket test = (Socket) socketList.get(i);

				try {
					logger.info("Closed socket = " + i);
					test.close();
				} catch (IOException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}

			socketList.clear();

			if (syslogNGReceiveDatagramSocket != null) {

				syslogNGReceiveDatagramSocket.close();

			}
		}
	}



	/**
	 * ServerSocketN[Y܂B
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (syslogNGReceiveDatagramSocket != null) {
			syslogNGReceiveDatagramSocket.close();
		}
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final SyslogNGUDPReceiveServer RESOURCE = new SyslogNGUDPReceiveServer();
	}
}
