/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.receive;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.logging.Logger;

public class SyslogNGTCPReceiveParseThread extends AbstractSyslogNGReciveParse
		implements Runnable {

	/* MO */
	private static Logger logger = null;

	/* ClientƂ̐ڑTHread */
	private Thread thisThread;

	/* XML Socket */
	private Socket syslogNGReceiveSocket;

	/* socket̓ǂݏoXg[ */
	private InputStream inputStream;

	protected SyslogNGTCPReceiveParseThread(boolean isSetAlarm,
			String ignoreMessage, final Socket socket) throws IOException {
		super();
		logger = Logger.getLogger(this.getClass().getName());
		setIgnoreMessage(ignoreMessage);
		this.isSetAlarm = isSetAlarm;
		syslogNGReceiveSocket = socket;
		inputStream = syslogNGReceiveSocket.getInputStream();

	}

	/**
	 * NCAgւ̃CxgPUSHʒmp̃XbhJn܂B<BR>
	 * iNCAg̐ڑ҂[vĂ΂܂j<BR>
	 * 
	 * @param remoteIP
	 *            NCAgIPAhX
	 */
	public void startSyslogNGParseThread(final String remoteIP, final int port) {
		this.remoteip = remoteIP;
		this.port = port;
		thisThread = Thread.currentThread();
		thisThread.setName(thisThread + " : " + remoteIP);

		thisThread = new Thread(this);
		thisThread.setName(thisThread + " : " + remoteIP);

		logger.info("syslog-NG parse thread start : " + thisThread
				+ " Remote IP=" + remoteIP + " Port="
				+ syslogNGReceiveSocket.getPort());

		thisThread.start();
	}

	public void run() {
		Thread curThread = Thread.currentThread();
		curThread.setName(curThread + " : " + remoteip);

		try {
			while (true) {
				this.parseReceiveData();
				Thread.sleep(SLEEP_TIME);
			}
		} catch (InterruptedException ex) {
			ex.printStackTrace();
			logger.warning("InterruptedException " + ex.getMessage());
		} catch (IOException ex) {
			logger.info("InterruptedException " + ex.getMessage());
		} catch (Exception ex) {
			ex.printStackTrace();
			logger.warning("Exception " + ex.getMessage());
		} finally {

			if (inputStream != null) {
				try {
					inputStream.close();
				} catch (IOException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}

				inputStream = null;
			}

			if (syslogNGReceiveSocket != null) {
				try {
					syslogNGReceiveSocket.close();
					syslogNGReceiveSocket = null;
				} catch (IOException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}
			}
		}
	}

	private void parseReceiveData() throws IOException {

		try {

			receiveDataByte = new byte[RECEIVE_BUFF_SIZE];

			receiveLength = inputStream.read(receiveDataByte);

			setSyslogNGReceiveData("tcp/" + port);

		} catch (IOException ex) {
			throw ex;
		}
	}

	/**
	 * SocketN[Y܂B
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (syslogNGReceiveSocket != null) {
			try {
				syslogNGReceiveSocket.close();
				syslogNGReceiveSocket = null;
			} catch (IOException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			}
		}
	}

}
