/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.actions;

import java.util.logging.Logger;

import netjfwatcher.syslogng.plugin.NetJFWatcherRCPSyslogNGPlugin;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.osgi.framework.Bundle;

/**
 * syslog-ngMɊւANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderSyslogReceiveTable {

	/* MO */
	private static Logger logger;

	/* syslog-ngMe[uView Display */
	private Display display;

	/* syslog-ngMe[u */
	private final Table syslogTable;

	private TableViewer viewer;

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherRCPSyslogNGPlugin.getInstance()
			.getBundle();

	/* syslog-ngMe[uNAANVNXCX^X𐶐 */
	private final IAction resetSyslogNGTable = new ActionRemoveSyslogTable();

	/**
	 * syslog-ngMe[uViewActionNXCX^X 𐶐܂B
	 * 
	 * @param display
	 *            syslog-ngMe[uView Display
	 * @param table
	 *            syslog-ngMe[u
	 */
	public ActionBuilderSyslogReceiveTable(final Display display,
			final Table table, final TableViewer viewer) {
		logger = Logger.getLogger(this.getClass().getName());
		this.display = display;
		this.syslogTable = table;
		this.viewer = viewer;

	}

	/**
	 * syslog-ngMZbgANVԂ܂B
	 * 
	 * @return resetTrapTable syslog-ngMZbgANV
	 */
	public IAction getActionResetSyslogTable() {
		return resetSyslogNGTable;
	}

	/**
	 * syslog-ngMɊւANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private abstract class AbstractSyslogAction extends Action {
		/**
		 * syslog-ngMANVThread
		 */
		public final void run() {
			doTask();
		}

		/**
		 * syslog-ngMANV^XN
		 * 
		 */
		protected abstract void doTask();
	}

	/**
	 * syslog-ngMe[uNAANV`NXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private final class ActionRemoveSyslogTable extends AbstractSyslogAction {
		/**
		 * syslog-ngMe[uNAImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/clear.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Clear syslog-ng Table";
		}

		/**
		 * ToolTipTexԂ܂B
		 * 
		 * @return ToolTipTex
		 */
		public String getToolTipText() {
			return "Clear syslog-ng Table";
		}

		/**
		 * syslog-ngMe[uNA܂B
		 * 
		 */
		protected void doTask() {
			syslogTable.removeAll(); // syslog-ngMe[uNA

			// syslog-ngMe[utbV
			viewer.refresh();
		}
	}
}
