/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.syslogng.receive.data;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import netjfwatcher.syslogng.receive.data.SyslogNGDataInfo;

public final class SyslogNGDataQueue {
    private static List syslogNGDataQueueList;
    private static final int QUEUE_LIMIT = 1000;
    private boolean isMonitor = true;

    private SyslogNGDataQueue() {
        syslogNGDataQueueList = Collections.synchronizedList(new LinkedList());
    }

    public synchronized void pushSyslogNGDataQueue(SyslogNGDataInfo obj) {
        if (this.isMonitor) {
            if (syslogNGDataQueueList.size() > 1000) {
                syslogNGDataQueueList.remove(0);
                syslogNGDataQueueList.add(obj);
            } else {
                syslogNGDataQueueList.add(obj);
            }
        }
    }

    public synchronized SyslogNGDataInfo popSyslogNGDataQueue() {
        SyslogNGDataInfo syslogNGData = null;
        if (syslogNGDataQueueList.size() > 0) {
            syslogNGData = (SyslogNGDataInfo)syslogNGDataQueueList.get(0);
            syslogNGDataQueueList.remove(0);
        }
        return syslogNGData;
    }

    public void setMonitor(boolean isMonitor) {
        syslogNGDataQueueList.clear();
        this.isMonitor = isMonitor;
    }

    public static SyslogNGDataQueue getInstance() {
        return SingletonResource.RESOURCE;
    }

    public static List getSyslogNGDataQueueList() {
        return syslogNGDataQueueList;
    }

    /* synthetic */ SyslogNGDataQueue(SyslogNGDataQueue syslogNGDataQueue) {
        this();
    }

    private static class SingletonResource {
        static final SyslogNGDataQueue RESOURCE = new SyslogNGDataQueue(null);

        private SingletonResource() {
        }
    }
}

