/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.syslogng.receive;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.syslogng.receive.data.SyslogNGDataInfo;
import netjfwatcher.syslogng.receive.data.SyslogNGDataQueue;

public abstract class AbstractSyslogNGReciveParse
extends DataStringDisplay {
    protected static final int SLEEP_TIME = 1000;
    protected static final int RECEIVE_BUFF_SIZE = 8192;
    protected boolean isSetAlarm;
    protected String ignoreMessage;
    protected DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected String remoteip;
    protected int port;
    protected int receiveLength;
    protected byte[] receiveDataByte;
    protected String[] ignoreMessageItem;

    protected void setIgnoreMessage(String ignoreMessage) {
        this.ignoreMessage = ignoreMessage;
        Pattern pattern = Pattern.compile(",");
        this.ignoreMessageItem = pattern.split(ignoreMessage);
    }

    protected void setSyslogNGReceiveData(String portInfo) {
        if (this.receiveLength <= 0) {
            return;
        }
        String message = AbstractSyslogNGReciveParse.bytetoChar((byte[])this.receiveDataByte, (int)this.receiveLength);
        Date date = Calendar.getInstance().getTime();
        Pattern pattern = Pattern.compile("[\n]");
        String[] messageItem = pattern.split(message);
        int i = 0;
        while (i < messageItem.length) {
            SyslogNGDataInfo syslogNGInfo = new SyslogNGDataInfo();
            syslogNGInfo.setReceiveDate(this.dateformat.format(date));
            syslogNGInfo.setReceiveHost(this.remoteip);
            syslogNGInfo.setPortInfo(portInfo);
            syslogNGInfo.setReceiveMessage(messageItem[i]);
            SyslogNGDataQueue.getInstance().pushSyslogNGDataQueue(syslogNGInfo);
            if (this.isSetAlarm && messageItem[i] != null && !messageItem[i].equals("") && this.ignoreMessageItem != null) {
                boolean isHitIgnoreMsg = false;
                int j = 0;
                while (j < this.ignoreMessageItem.length) {
                    if (this.ignoreMessageItem[j] != null && messageItem[i].indexOf(this.ignoreMessageItem[j]) >= 0) {
                        isHitIgnoreMsg = true;
                        break;
                    }
                    ++j;
                }
                if (!isHitIgnoreMsg) {
                    AlarmMessageMake alarmMessageMakeInstance = AlarmMessageMake.getInstance();
                    alarmMessageMakeInstance.setSyslogNG(this.remoteip, String.valueOf(portInfo) + " : " + messageItem[i]);
                }
            }
            ++i;
        }
    }
}

