#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define SIZE(x) (int)(sizeof(x) / sizeof(x[0]))

/*------------------------------------------------------------------------------*/

static const char *ro0 =
	"                        E  ECD  D                E      "
	"            RJ    TJ    OG}  ^b()|]|]            "
	"]  b      dEE          e  f   (  )            [  ]    {  "
	"}           q  r          u  v  imjn|    {|^_|F"
	"|  ^<    >  `EdB  {          Kbxrb"
	"bb    K^//    ~  b          ()b    <>    R"
	"  ȁځ  ɁP  ~F|->|<-bȁbɁ                  "
	"                            ߁߁(    )  i||    "
	"                            O/  /|  <>ɁR        "
	"                                    ^QbQ            "
	"<<>>/   ``dE                                  K`"
	"K^||bI|)s{a                  ()b                "
	"                                            ()bLb܁ځ܁ځ{"
	"u܂P /R                            ȂdR( ܂k )"
	"e߁ub  ||    |<  |_  mu||ub()eno  ܁Pb"
	"i /_VVm^_ɁbP                              "
	"  |  bEE|<    ||||    R  {|"
	"||A  vv^><m|                    ߂ǁRRMM"
	"]  񃉂  ̂JR  L  <     |+  j[  {  "
	"l     iX  t+  Ăy  i  T      [  [ ("
	"      i  b߂̂J)m悯    ĉ    n  "
	"  ^_    ͂܂    L7+݂()L{{    "
	"Bイm  IVHI̂ƃi/v`            "
	"                                C|tmmm  ~ۂs"
	"{    iJ  L  mtN  mNP  j ]R  i++T  JV  "
	"tlX  Z  Rm\  N^  i`  JmJmc  e  bR"
	"g  {m|Qts    mRn  n  kq  q  Pmt  t  ^_"
	"w  w  z  z  RtS߁ځRmR{    ۃRۃR߃R"
	"tmmmRtutLGAGtRmE  iNm        "
	"                        ȂdRbPځȂekV||n|b  |<  "
	"/ _um||ȃj߂b()ec>_ځPbɁb^_b{          "
	"                            |3B                                 "
	"                                                                "
	"                                                                "
	"                                                                "
	"                ȄCdRbPL  ekE  K  ܂||uI  |<  "
	"J|Pmu||b()e( ܁PbmO^_kۂb||ۄWY]  "
	"]||b-)  |O                                            "
	"                  ( ]s|      |u  {                  "
	"              s                                        "
	"                                                              "
	"        |                                  "
	"                                "
	"    ";

static const char *ro1 =
	"  \B ߎS          T      "
	"    Qؐhʓyly  ~ǏSH䎅{    I"
	"l~    剹v،l    C    |"
	"я        ܊      c  c  谎c  "
	"      M  #       L    |  mqv    ы"
	"    ダXdň  L  受|bHp  X  A    ]"
	"}    ~H  qʘ  H    풹K    谂dΚD  "
	"  L    ֏Vʊ  ܃剤  񃀌R  J]C  H"
	"  {CLicR  v    i  g  p  TMqŃqŉ  s"
	"i[  tMnڏZՑZ    c  ͙\"
	"~MǐS        ΋ΐk  泖LF    "
	"  ǒM    Vj  vđeSb    指"
	"tHyH    撹Rc            T  y"
	"Ăy  ňSM}  sgCq      \d͌"
	"gS珗  SѓlRc؉ؚFl  D  ؐщ"
	"              ʉ  L  D  J  䔰"
	"  I  Rbl𒎉L谐Hn/|։]p    S  "
	"  M񏬚햔y  D    OȝSl  Z  ʉΓc"
	"䔒      F    毙{͗[g  g  ݍ  "
	"ΐ|Ms\母嗢  \yj؎sb`  q  "
	"sL  o  eA  t  谐    p    Ԍ  e  "
	"  uR؋qřŌT      cj  HPQ    "
	"            ԊQ  \    v؎锒XT  "
	"Y    bؕS    |ă  H  Ck  "
	"r  谗͌    r    ~  s\슱        "
	"      j    谌  v    y      bM    "
	"      RHMĊ  谌cL          "
	"  Hq  ʊ  iڍRΏK  谌"
	"FŌŎ~  x    g  呴      RxzȐSR  "
	"ؙ{ڑؑ      泟tVl҉ї  "
	"H  vȊL  ȎԋRH{nZ\  `  x  "
	"x  ^  `  q}lr`  X`      vm  _  "
	"؋g  gΐ،߉  Ŋe  p  gd    NXCCؔT  "
	"y  C  RS؂T  y    vΉg|y  y  \"
	"b߃LyÙd      g  ߑ  䎦"
	"Nc    v    YZ  ́K\ی"
	"  v  ||j  }Sv  F  Z    v    ]́"
	"      틽HhnCŋ^  YĖ؁c  "
	"  Đ  俗͓yc\ʂsҌюl]  b  "
	"  l  俋  Sʌi L      vÓ"
	"gnnunڒU[  gH  H[  [  [  [  L  "
	"ћo  vԌ\\    vĐ؎i؋H  "
	"Ed  Nr  N  \g߃l  n    Y˝y\"
	"Y    OcevR  }  ㎩  谔T坼U\  v  c\ގ|"
	"  ĎԎT  yY    \|hԖŕv]    "
	"g泑Ԏ蔒s  CؐlPr_  ~gM    "
	"Cg            byMS  n    "
	"        쌢  ΌڎˌڌZbLԊ  "
	"  ŔnbYeʔʊt|    􉤌MO"
	"F  畽  mÏÎqZR  ԋ|ZPÝ،ß"
	"Z  SӚ  tÌ  gX𑫚Ì谌ٕœx  _    "
	"P܌牵]،  ӑΌጾǓьӉ  "
	"Z  K  YnH͌̓ʎqRcʐΌ"
	"yy@qqqy~sۃGȓyh讋|jr"
	"      G      X  i  VHVVVJVi"
	"cې΍XэčNHΈyT~󍂌M"
	"䊐esiHLLiB эFL΍L升烐Hŉѓ"
	"]l|͌֌  l  V  ԁÌZ  gʉюE"
	"э  Vv]ܐS  D    ~qŃw"
	"y\涍涍؍؍  Óq]SjC"
	"    RiG㳍؊VΏLߓy    "
	"  f    gh  ќcI  ؜~ʐ  ݉Ήуc"
	"ΙΗ[Ďc  ߜԜB Ր  y  ؍˔  Lˉ    "
	"  E  _  LVR  ΊHC      "
	"R    ̖؏\  qM  Ѝ  ݗ[  @  ؂џt"
	"Y  谔ʉ||ߘ  cێQ  U  ̝"
	"؜ΕĉFڜOZV^  vLшH  ԋҎaeYmCq"
	"i  CR  =]  䒆iC\ۏ䏗sꛙ  ЎmS"
	"cS|  mqҕq؎x  eq[+EEt  l~у􏬎"
	"x|pjiuLLՍ谐Hi~Ę"
	"    X~qyS      J  ʛΎ"
	"c  Slڎ  hV[HT}Ɠc|ԗRZJ{"
	"Kۖv  ѐSVo  ҊLv      ώvؔV    "
	"c  ^  gɏEԝ]l  lyyE˘j쏎  "
	"  C̙  ؎ىΎٍюىюڋՉE  f  |HS  "
	"  pL  e  яdd  S    Z  O  "
	"؋jJl  g    ސccHS  B  єTщΎ~"
	"l  HO  S      谌AԎ    яBؓыSC\"
	"d  {eD  ؙq\~><V]痢[ze    f  "
	"lZh  x  x  yRs{{    Rvw  C  n  "
	"  参  e{  y[  @  ԛ    ыŚ{lˋ"
	"ҏ    Ҏ        Ҋ͗]m\]  @S"
	"]        ҃`O  g  |嗧  "
	"  n    y؛Ə͜c    葖    "
	"i،؏і؏͖؏ŏ      ΋    ڐΏѐΏ"
	"lrћ  ď      sdߌr"
	"  ыd  vфۃi  k{      "
	"  ݐ  J  ؖ؏䑈    c  葮  "
	"  HЎ    e冎ƎƃNbp  HC㒇\  "
	"CCZ    n^  C  hғ  с`  ؗRbc"
	"l\  \  S  V  hcI  \JCmփC"
	"    mC  b  \    vni  cœѓᚘ"
	"ʐ  \    tΌڐęH    љ谋"
	"L  LR@Rĝ؋摖谋  ؜c؏  ŏ谋  "
	"o  K  {  cvD  s  ۗ͏      "
	"؍Ȗؐ~  MĐmߎl  ܌"
	"  ѐ  ьZ谖Џ̐{    ؋Ҍ  "
	"  |̎ӕvLyӐΕŎo    ><  t"
	"|ZJFpÒPCRY\Cj  Rml|PˉH"
	"F  ؑSؒO        O    D|O򎅜r"
	"[M  SLF    lrl|rga  "
	"^lPPPėЏ]yR  cѕD  D[D"
	"Α^lъĊyьˊ    P  ]  q    Ǝ捇"
	"  m        ]ЕSSR  \a  iؒUȓ"
	"Pʑq      ΕiNRؖڌSđ@  s  O"
	"q  iؑsߓyDV    qJna  ]  ]      L]  "
	"    L  ŎS  R  D  J  ZL"
	"lRÊO  iqqnU  ؐ    [c      L  "
	"    ؛M؍  nnPC{yyRЎ  "
	"S\Fٜvv      ߑL      ㍕"
	"CTli|ѐŊ咹    葁  ~        "
	"y泌V  Ꭸ    ьnŐmUK    谐Z"
	"ȋR  ؕw  ؑ谜O  VvyURUؓ  "
	"v  r  RD|P莨  UDi  |P"
	"ċғ৘  dtc͌  y|玨Sm  m谒  "
	"mrn}،cPTT|}{    юzrڃL\"
	"CR  SR  ڒU؎    ߌѐn؉J  "
	"    L  ꘫXk    АВ||ce  "
	"  \쌎  АcڒS䒎"
	"d  ŉG͕    VV񉤜cCL^      谖ؒ"
	";g    TT    ؕꍑJ؋Kc    ؐΏ\爒  ؏t"
	"M  y⏗RCЋ谒        L"
	"  D  ЛMp          VΒlђ"
	"M쌾鑫h    ё        "
	"|R    ܌U  U  ԎU  ȎMy^    "
	"o  ÊLԉ]^Ő]ta  oJbZ  y  ]  "
	"ґ  S  ؓyx  ᠓  Lҗ]    xΎΖz͛\"
	"zS  Z    mt      咷    R  t  "
	"          Mʙ    ΒΓo        "
	"  ē[  d      _  OB  G  o  "
	"n      d͙c  y        e    "
	"㉺  eS    fډљXn      ؖ  []"
	"i  RT      Ó  R        ԕ"
	"E_  ԑ厦NclP~          DU  n쎅T"
	"cc  Ԍv谏    qT  qC    H++    "
	"tm_  ppnSE      lS`c  "
	"߃SO  R  R  ĐA  Myѓy߃c_  qc"
	"_  ȒCi  b      b      bΔgn  b  "
	"dT    OI  LؕssMДږksԓьȈʌ^"
	"  ^  ^  L  `mL  TѕH  m  "
	"      P  ĔM    \    \    UVn੗F  "
	"    ΒJ          {Γccm_{    є"
	"镗Fi  F    唰㒹V          Lʖ"
	"Ж}ʉ  :e  }  Д)e  cq  Mt  La  ѕ"
	"ΕŕŐH    ΍ʎMʐΔ  c  ț  "
	"S˔    񕶏qK  xΔڕK    \  b    "
	"L  k]E  ʉp  ќe  c䛙ڗrv  ؓ~"
	"  Xd镔c    |SS      c  ؉b"
	"N  Hc\  ՜c[    [  [Z  涎ٛc  "
	"яc  c  Vѐ    pn  Ŗ"
	"󊢃nC  Vy  ciЛtz  v    ҕt  "
	"t  {gݕv  L  g  t      TC"
	"  \    H  ㌢ceГclcl畜  "
	"  䃀    C܋t          щΚS  ĕ"
	"ĈَJ厨    u    ǋЊ  ǜO  aH  "
	"y؁SL      ߐΖǖږΜG  G  G  "
	"    G  X  Ɨ͏ƃOv֋xɕᚘ  ~p\  "
	"ԕb  yT  O  䞃    ș؍Kv"
	"  RR      i        Ε  "
	"          毁    H  V    "
	"yЖ`SSS  ˕  SÕڎd  ^"
	"L    KŃRq      ؃g  ќc"
	"t  e  W    ԉH{  M薃ΖSї  "
	"؝x    ^  z  ؛LؐC  Vk    "
	"    s  CN            S    Rb"
	"~K~Kt    O  h  Ėю  ږ[  \IJ"
	"؋DǙkU[@M  qDNY"
	"؛厅  Sʔ      SqM  Sڎ㦖щ  "
	"M\ҍ؍H  H  ˑĐnL働SF]  n"
	"Z    뎨  \  V    et  y    谗K  "
	"    O  O  R    OԑO调CEJ  j  iL  R  "
	"S  EؗRE  T  U  Uc  lElJG  b    L"
	"魒^N}z  Tӌ  Z  \ŗf  ͏J  p      "
	"B    r  r  e  e  b㴉谐ؗe  T    "
	"  H  ~    J  J  HHْ            "
	"Jce  e  ъeサK    茞      bуj䛙"
	"؎q؉כ  lb谐y  j    ce"
	"  [    [  c[  ė琶b  C  gvTKgjt  "
	"  cR瘵  ēlS              U"
	"  i  ʗ  ѕđC  biԘӕđCđCC  "
	"    cđ卡        ͗    ߃l  ߊ"
	"J߉J  ߙʗљʗџe͗  ߛSđCA  Γ  "
	"  A      D  ΌˊLeeJH    YO"
	"ǌďY    J      yqꋗ    l"
	"    уsLĹ  ؙAݖU    "
	"    ^      ";

static const char *ro2 =
	"T  s  w胋          m_k          ɗ\"
	"  G][  Hz  {    񊎐l^^T  ʐlCgCJCC"
	"CnY              ~g            "
	"S  L  r  ؘ      le    T        "
	"      Z      wf          {    _    "
	"R\F  F          `  S              "
	"  K                jc@    _          "
	"  i              X  PYZ        J  O  T"
	"kك ]c  RccRf  ʙk\k  Pٖ      "
	"        Z        h  X  gؙ{C{c{kv"
	"n  `탊    ナ    󙃛          O"
	"        [  @  @@      h  h  ͏͋g"
	"v͛  ͏  Jΐ        c  M        mtܐnc"
	"ᙯ  qkbyM  Pki\OO\\  "
	"y|]  ^ŒJŊ  mPʜcʑʉę  ʎzʝƃ  Q  "
	"Z    Px    働҃E"
	"ڃi烍Zb{\zo"
	"t\ڑV  s"
	"        X  F      M          调::  "
	"  P  O    b    q  e        H    @  P    "
	"  `  h    G  L      V                "
	"  A      c  pz              i؍  J  "
	"@              d            G      Y        "
	"  RߚLᚘK蚘Ꚙ  ޚ"
	"yyyRyyғy~ysyØ  yyytyyyys"
	"yy㉺yypyyyyyԓyyyyDyy"
	"yGyΓyCPtyyyayyԓyyy  yy  "
	"i  }  b    A  i  n        s    D  q  "
	"v^      eї[ʑv    \T  l\"
	"s  U        ُ  C  䏗UꏗΗr"
	"OC        jp        я"
	"  M  i    Pxn          [        d    "
	"jj  @            Tqq    zq  ۛq"
	"  w  q    ~q~bC                      Q  "
	"  HcPو  L  L      ƐPr  㛗c  "
	"䛙  ěL      RiRRRy    RR"
	"RRRRRRRَR荇  R      RXRђ  RJ{  "
	"                R    Ìi  [    S  "
	"      a      o  `  @      ^  o        ^  "
	"      <<  H  @bЃЋЎzД    谋ЉВ"
	"ЖК  TГƋЕ++TTO  ʛr"
	"ucznᢛgḛ谛      "
	"MRi\O  O                |  z||  F  e    |"
	"|    _ʃm  gcC  eeeeeeeݜe{"
	"e  k    e  eceʜe        N      S  "
	"        SU          i  \uCSe  xS"
	"  ́    S    {      rS          "
	"        W      SG  b              "
	"  M      c  tSH              u  "
	"C    S    S    q    O  I    N  Q  a  a  "
	"]  K            [  f        [  i    d    "
	"n  {    K            i        g      "
	"                T              r"
	"谜    Y    ˍLLLLHL          "
	"\    l      s  c    \  z荇      q    "
	"t      ͗  e  g    H  \            "
	"Pxy          虯              F  "
	"      _  P  `  [ʊi      q      H  "
	"        Hco  z                  K  "
	"B      ~  ooL        o      A  A    "
	"  y    ^        P    Cc𝼕  "
	"]]Н  @ǎplrl΋Ғf  Os"
	"ѕ[ԕԃ`    Vؓi  "
	"K܈  W    C      R  "
	"p  R        U  i      Ǔ        A  L  "
	"`    d\oǑ      Jz  sTؖؓؗ"
	"ؓ؊،Ȗ؍H؜T؎Rؖ؉  ،ؗ\؏ؕؕ،˖؏"
	"؜OU؉؉  ؙؑ؋؊ؓؐ˖؎؏oؕؕtؗ"
	"؉Zؑ\؊؋؉HؑCؚ؍l؎؏[ؑؖؓ؊p؝ۖؒ"
	"؍؈؛؝ؓߖؚؒؕ؛tі}ؘCщؘ؎،N؋"
	"ؑ؎ٞR  ؍،؉؋  ؍؜؏@؈؏f؏؞R  "
	"ؒmؑ؏ؔOؕ{ؕؖؓT؎ؘӖؔT؊F،Ӗ؏H؎،_"
	"ؐ؎Җؐrؒ泗іؙؖ`ؕ؞j؎ؐ؎Mh  ؋S"
	"؍؍v؍؍؊؍ؓ؉Hؔʖٖؔ؉Ζؐؖ؝Ӗؗeؗ"
	"ؗ؊sy  ؜c،\  ؎Hpl؎a؏]ؙؐؐʖؑؐё"
	"ؖؖ؉iؘK؊؊і؊؍Ŗ؏؟}@ؓoؓꟖؔؒ"
	"،؈Ӗ،hؙؕ@ؚ焖؟@؊ϖؙ谖ؔJؕo֖ؖ؉ؕi"
	"؞ٖ؊y胖ؗ؉d؝  ؉J،ؗʜc؊ጇ󌇓  "
	"    PH@o谌t[eeece"
	"eteeeeeedeoeTeT{t  ttN["
	"іы    щјіSčHR  y    "
	"    ~  S  s                O    l    "
	"        c  R          s          "
	"{  @        G      ܟ      y  V"
	"Đ씟                  ͜  @    yX"
	"  y    y      c  R  UH        q  "
	"  u    `  qh    @MW    J    q    "
	"P  ד  YꋃӖ        ܗW      Q    "
	"    j  b      z~  ~  q        U    "
	"  d            iK    L                "
	"J  o  l    o  R    \  {                  "
	"  ]\    펅[ΉΏΙcΙc΋ΓΕΕΈx  "
	"ΏΊe  Κ΍ΗΚ􋐖      ΍c৉ΝΏd"
	"Α΍vΈѝ  Ζ  ΜTꟉΓ։ΔԉΘΉΚʉΐΒB"
	"泏K谉Ξىḉ茕  ܔbF    ੊=|    ૚М"
	"ДውїS  `    N      b  "
	"  e            Z                "
	"        \    J  b  l              "
	"      e      Y        @  RR  K  ݖ`  "
	"`    S  Ln  ʋ      焋ʉ        ZhZ"
	"\犢ԊъSpHЙꊢ    "
	"ÍX}pccccccvcccccߓccecc]"
	"cc  cc  c    vRޛÛ"
	"U~ΛSrݛuۛϛś"
	"ږ    `Msқqʛ͛ݛț"
	"ᢛaݛ^{谛  ϛN谛^    ᠓V᠟t"
	"qX唒𔒊͔比RR䍔瘰MM"
	"rMMMMMgMMMڙaڛڏ  ڌړ|"
	"ڍږvږږڒڈڙZڑڐڔږ  ڍKڎҖڐ    "
	"    ڊڋMڈ谖ڙ@ڌۖڌږؐǒi冖"
	"΍HΐؐΔΜAΊݐΌ\ΑΉԔgΐΕΗΜ_ΓΒΐr"
	"Λݐ毐΍΍ΑCΓWΔnΝӐΕiΐΐӐΐꟐΓoΉ΋`"
	"c΋^ΗѐΞَioᎦKT__򎦊"
	"ĎdL  b烈єщы  іѝۉящёђ"
	"ющ񎦉љfщPэшїeьbэ҉њэΉы}ыT|"
	"䌊c^ND  ʌȌľ"
	"\痧ї藧  Sᗧ՗Њ      b  "
	"          {        O{    S      C  "
	"            Y                    "
	"    c    Ì    i  t        I        "
	"  L          M          @      "
	"                  ď\ĔČˉčĕĎ"
	"ēĕSčX^ĕėėǕđď@ĉԕď_ĐrĉƕėpĖĔ  "
	"ĎݕĎG  ]䎅cLD䎅"
	"s  ^@g󎅛ݎGÎCE"
	"ˎюV쎅ʛnӎߎ"
	"iv  ЎvnɎc  JWǎ  c"
	"֎[KݎA_厅U꟎ԎK\  "
	"pĎĎohČŎ^̎niŎdƎ"
	"ŎʍHʚ  ʊL  ʓ܊谙c  cSs        "
	"        F    vnvrYr  NrrߗrNr  r  "
	"rrrr  rxHHHHrHHOHGHHꟉHԔ"
	"V|VјVіΉ]ΔbΘCΏΐJΎ~Kߎ㎨R  "
	"m莨O]    J  Lq䒷쌎HSy"
	"ތbDጎRi݌C"
	"ጎ錎Tڌ񌎕{󌎌v݌kM魌"
	"ӌ݌ጎ䌎vԌ\a"
	"匎@ČlḌb莺  `PlPOPt"
	"PjPZP谍㎁qMMMMRMtMqMՏMMM"
	"M`MM֏MDMḏMˊvLF  ++  S    t      "
	"      f    ~        t      K        "
	"    e      {  @                  "
	"              ]e    E  G          "
	"  f              g    䙖A    Ok  "
	"    dR        R      i    b    [    "
	"{  D    M    䞋  V  C  J  `        "
	"  h      Q  `        Hc  w      q  S  "
	"~  P    e\  jc      h  K    a    "
	"  ΐ̐      e  [|  t  y  D  ыp    "
	"    N  {    ㎵Ҏsgg  Rl"
	"LÒuÒRߒݒ񒎐㒎}𒎎钎V"
	"C[t]TՒ"
	"񒎓cݒDȒՒӒci璎G`q䒎"
	"u  Y~풎谒͒K"
	"iԒ噌cz  hǒt峎M  "
	"    Nnsss  s调lc  ߈  llpєC"
	"lllclUllll_߃l\l㉺lsߙg"
	"lNߗ  ݌TlՔ߃lڃlЃlȃlRlGlۈ    lJl"
	"lՃl\  ߃lKlKldlPlc焈߃llălgl̃lel"
	"lk  GGGn  茩ތҌ`毌i  o    "
	"谊pZppprpp册gH匾"
	"䌾  D댾@{錾ΌT"
	"ьތौP茾jF茾s錾RG"
	"kFvacKӌʌv֌"
	"਌􌾖o֌֌  i焌Kǒ谒N"
	"ƌ谌^JQJJ  RHs泌泎Ҝc  "
	"涍涏涊e涋x涕S涗涙Z涔涔涔LLLLLL"
	"LLR  L  L  LҊLLLLLL^LLӊL"
	"LᶊLĊLLLiL̐ԔԎҔV  Sёx~v"
	"Α瑫둫}摫ǑǑʑ"
	"m_d`E  qґPʑ]@"
	"LΑi冑焑đ摫Ao呫W"
	"g|g{gLgSgggԂԖ  ԎԉԜcԎԎԊe"
	"ԛݎԖԎԖƎVԖԗԗԕvԑtԓcԚ͎ԍԓWԐ"
	"ԐԎԋԊԎԞَԗḐh  hhh  h    c  "
	"  R  O      @                  Y    "
	"  yXh      Rc  U      `    i        "
	"  @      h                u      J  "
	"˔bt        d  đCђћџtъÓщѓішђѐ"
	"ёїѓюMшюMќc泓іL  їRэK  "
	"͋nًҋڋNË"
	"΋cΓBsSKGы䊋"
	"ŋVोFԋc`rv"
	"eah֋cAK"
	"Ɤԋ貋c  Aًl"
	"ˋꞋ谋^^ǋ  剺R啶吅b"
	"sʖ\勤C剗P剂刽劈LҖj  "
	"n  dB焐      ~    S  L    P    y"
	"          c  v    S  @    B  n      "
	"  db  谛调lW谉J谎谉JJщJJJZJ"
	"JJJщJpJJJUJ焉JĉJ漉Jy_߉JމJ_"
	"ʕʌʉ}v͊vvnvvvUvvvv\v}v"
	"vBvvHv_v䧊vpvBvJṽP  ꉹ"
	"٘ŌśݕŐbŋgŊܕœÕŉʕŕFŎvŘœŕpḕ谕"
	"ŉ䕗[[HԐHHHHÐHH]HP"
	"HFHHHHӐHeHSHHMHH֐HHMHHꟐHF"
	"Hj񈽍nqnnnlnjnnnznnnenB"
	"n۔nZnRnn谔nnGnǔnannQnn[nݔnn"
	"nKn@nnḔnbnn谔nn퍜teڍK再"
	"Lic镖镕镖镙f镏镚镕镕镋镋g镏镙镐{"
	"镈镕o镑l||++馎s馋香Z馐  qcSSϋSS㦋S"
	"S  S}ዛ΋~닛|xnы"
	"TՋZV񋛎QՋOcv"
	"Ut狛jЋMM  t_N͋["
	"싛\L{Ḓ{{咹ʒʒ훗"
	"Òߒ𒹍s䒹䒹pޒL"
	"̒ڒ钹R  H  ~㒹Ғ"
	"^ʒŒԒ  d谒}bbĎ  "
	"厭Ď    ˘Қmvvm  m  іt"
	"t׍o荕cg}̋    ꃕ  "
	"ꆝꆓۓ~VplR@    ꏃqꏋꏊꏏꏗꏍꏌ_"
	"ꏌꏑꏉZꏙT  Ӌ    ^ʃ^g  b";

/*------------------------------------------------------------------------------*/

/* ------------------------------------------------------ */
/* -		Mersenne Twister			- */
/* ------------------------------------------------------ */

#define RND(x) (int)((double)(x) * (double)genrand_int32() * (1.0/4294967296.0))
unsigned long genrand_int32(void);

/* Period parameters */  
#define N_MT 624
#define M_MT 397
#define MATRIX_A 0x9908b0dfUL   /* constant vector a */
#define UMASK 0x80000000UL /* most significant w-r bits */
#define LMASK 0x7fffffffUL /* least significant r bits */
#define MIXBITS(u,v) ( ((u) & UMASK) | ((v) & LMASK) )
#define TWIST(u,v) ((MIXBITS(u,v) >> 1) ^ ((v)&1UL ? MATRIX_A : 0UL))

static unsigned long state[N_MT]; /* the array for the state vector  */
static int left = 1;
/*static int initf = 0;*/
static unsigned long *next;

/* initializes state[N] with a seed */
void init_genrand(unsigned long s)
{
    int j;
    state[0]= s & 0xffffffffUL;
    for (j=1; j<N_MT; j++) {
        state[j] = (1812433253UL * (state[j-1] ^ (state[j-1] >> 30)) + j); 
        /* See Knuth TAOCP Vol2. 3rd Ed. P.106 for multiplier. */
        /* In the previous versions, MSBs of the seed affect   */
        /* only MSBs of the array state[].                        */
        /* 2002/01/09 modified by Makoto Matsumoto             */
        state[j] &= 0xffffffffUL;  /* for >32 bit machines */
    }
    left = 1; /*initf = 1;*/
}

static void next_state(void)
{
    unsigned long *p=state;
    int j;

    /* if init_genrand() has not been called, */
    /* a default initial seed is used         */
/*    if (initf==0) init_genrand(5489UL);*/

    left = N_MT;
    next = state;
    
    for (j=N_MT-M_MT+1; --j; p++) 
        *p = p[M_MT] ^ TWIST(p[0], p[1]);

    for (j=M_MT; --j; p++) 
        *p = p[M_MT-N_MT] ^ TWIST(p[0], p[1]);

    *p = p[M_MT-N_MT] ^ TWIST(p[0], state[0]);
}

/* generates a random number on [0,0xffffffff]-interval */
unsigned long genrand_int32(void)
{
    unsigned long y;

    if (--left == 0) next_state();
    y = *next++;

    /* Tempering */
    y ^= (y >> 11);
    y ^= (y << 7) & 0x9d2c5680UL;
    y ^= (y << 15) & 0xefc60000UL;
    y ^= (y >> 18);

    return y;
}

int is_kanji(unsigned char);

/*
 * (1)ǂ𒲂ׂ
 */
int
is_kanji(c)
unsigned char c;
{
#if (('')==0x8181)
	/* SJIS */
	c ^= 0x20;
	c -= 0xa1;
	return (c <= 0x3b);
#else
	/* EUC */
    	return !!(c & 0x80);
#endif
}

int kanji2index(int i) {
	int c1, c2;
	c1 = i >> 8;
	c2 = i & 0xff;
	if (c1 >= 0xe0) c1 -= 0x40;
	c1 -= 0x81;
	if (c2 >= 0x80) c2--;
	c2 -= 0x40;
	return (c1 * (0xfc - 0x40 + 1 - 1)) + c2;
}

/*
 * 蕶̕
 */
int
jrubout(str, nxt)
unsigned char *str;
int nxt;
{
	int i, j;
	const unsigned char *p;

	for (j=0; j<=nxt;) {
	    i = j;
	    j += is_kanji(str[j]) + 1;
	}
	if (!is_kanji(str[i])) return 0;
	j = (str[i] << 8) | (str[i+1]);
	     if (j >= 0x8140 && j <= 0x84be) p = &ro0[(kanji2index(j) - kanji2index(0x8140)) << 2];
	else if (j >= 0x889f && j <= 0x9872) p = &ro1[(kanji2index(j) - kanji2index(0x889f)) << 2];
	else if (j >= 0x989f && j <= 0xeaa4) p = &ro2[(kanji2index(j) - kanji2index(0x989f)) << 2];
	else p = "H";

	if (p[2] != ' ' || p[3] != ' ') p += RND(2) * 2;
{char buf1[16], buf2[16]; buf1[0]=str[i]; buf1[1]=str[i+1]; buf1[2]=0;
			  buf2[0]=p[0]; buf2[1]=p[1]; buf2[2]=0;
			  printf("%s  %s\n", buf1, buf2);
}
	str[i++] = *p++;
	str[i  ] = *p;

	return 1;
}

/* Partial rubouts for engraving characters. -3. */
static const struct {
	char		wipefrom;
	const char *	wipeto;
} rubouts[] = {
	{'A', "^"},     {'B', "Pb["},   {'C', "("},     {'D', "|)["},
	{'E', "|FL[_"}, {'F', "|-"},    {'G', "C("},    {'H', "|-"},
	{'I', "|"},     {'K', "|<"},    {'L', "|_"},    {'M', "|"},
	{'N', "|\\"},   {'O', "C("},    {'P', "F"},     {'Q', "C("},
	{'R', "PF"},    {'T', "|"},     {'U', "J"},     {'V', "/\\"},
	{'W', "V/\\"},  {'Z', "/"},
	{'b', "|"},     {'d', "c|"},    {'e', "c"},     {'g', "c"},
	{'h', "n"},     {'j', "i"},     {'k', "|"},     {'l', "|"},
	{'m', "nr"},    {'n', "r"},     {'o', "c"},     {'q', "c"},
	{'w', "v"},     {'y', "v"},
	{':', "."},     {';', ","},
	{'0', "C("},    {'1', "|"},     {'6', "o"},     {'7', "/"},
	{'8', "3o"}
};

void
wipeout_text(engr, cnt, seed)
char *engr;
int cnt;
unsigned seed;		/* for semi-controlled randomization */
{
	char *s;
	int i, j, nxt, use_rubout, lth = (int)strlen(engr);

	if (lth && cnt > 0) {
	    while (cnt--) {
		/* pick next character */
		if (!seed) {
		    /* random */
		    nxt = RND(lth);
		    use_rubout = RND(4);
		} else {
		    /* predictable; caller can reproduce the same sequence by
		       supplying the same arguments later, or a pseudo-random
		       sequence by varying any of them */
		    nxt = seed % lth;
		    seed *= 31,  seed %= (256-1);
		    use_rubout = seed & 3;
		}

		if (jrubout(engr, nxt)) continue;

		s = &engr[nxt];
		if (*s == ' ') continue;

		/* rub out unreadable & small punctuation marks */
		if (strchr("?.,'`-|_", *s)) {
		    *s = ' ';
		    continue;
		}

		if (!use_rubout)
		    i = SIZE(rubouts);
		else
		    for (i = 0; i < SIZE(rubouts); i++)
			if (*s == rubouts[i].wipefrom) {
			    /*
			     * Pick one of the substitutes at random.
			     */
			    if (!seed)
				j = RND(strlen(rubouts[i].wipeto));
			    else {
				seed *= 31,  seed %= (256-1);
				j = seed % (strlen(rubouts[i].wipeto));
			    }
			    *s = rubouts[i].wipeto[j];
			    break;
			}

		/* didn't pick rubout; use '?' for unreadable character */
		if (i == SIZE(rubouts)) *s = '?';
	    }
	}

	/* trim trailing spaces */
	while (lth && engr[lth-1] == ' ') engr[--lth] = 0;
}

void main(int argc, char **argv) {
	char buf[1024];
	init_genrand((long)time(NULL));
	if (argc >= 2) {
		strcpy(buf, argv[1]);
		wipeout_text(buf, RND(strlen(buf)/3+1)+1, 0);
		printf("w%sx\n", buf);
	}
}

