/*
 * Copyright (c) 2012, Alexey Badalov
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of Tomboy Exporter nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software  * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE. 
 */

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;


public class TomboyNotebookScanner extends DefaultHandler {
	
// data
	
	private final TreeMap<String, ArrayList<String>> notebooks = new TreeMap<String, ArrayList<String>>();
	
	private String currentNoteName = null;
	
	private boolean isInTag = false;
	
// interface
	
	public void setCurrentNoteName(String name) {
		currentNoteName = name;
	}
	
	public Set<String> getNotebooks() {
		return notebooks.keySet();
	}
	
	public Iterable<String> GetNotebookNotes(String notebook) {
		return notebooks.get(notebook);
	}
	
// DefaultHandler overrides
	
	@Override
	public void startElement(String uri, String localName, String qName, Attributes attributes)
			throws SAXException {
		super.startElement(uri, localName, qName, attributes);
		
		isInTag = qName.toLowerCase().equals("tag");
	}
	
	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		super.endElement(uri, localName, qName);
		
		isInTag = false;
	}
	
	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		super.characters(ch, start, length);
		
		// Find tags of the form 'system:notebook:*'.
		// Treat the last part as the notebook name.
		// Add the current note name to the map
		
		String prefix = "system:notebook:";
		
		if (isInTag) {
			String tag = new String(ch, start, length).trim();
			if (tag.toLowerCase().startsWith(prefix)) {
				String notebook = tag.substring(prefix.length());
				if (!notebooks.containsKey(notebook))
					notebooks.put(notebook, new ArrayList<String>());
				notebooks.get(notebook).add(currentNoteName);
			}
		}
	}

}
